(define_automaton "ppc440")
(define_cpu_unit "l_pipe,i_pipe,j_pipe" "ppc440")

;; PPC440 Embedded PowerPC controller
;; Dual issue
(define_insn_reservation "ppc440-load" 3
  (and (eq_attr "type" "load,load_ext,load_ext_u,load_ext_ux,load_ux,load_u")
       (eq_attr "cpu" "ppc440"))
  "l_pipe")

(define_insn_reservation "ppc440-store" 1
  (and (eq_attr "type" "store,store_ux,store_u")
       (eq_attr "cpu" "ppc440"))
  "l_pipe")

(define_insn_reservation "ppc440-integer" 1
  (and (eq_attr "type" "integer")
       (eq_attr "cpu" "ppc440"))
  "i_pipe|j_pipe")

(define_insn_reservation "ppc440-compare" 1
  (and (eq_attr "type" "branch,cmp,compare,cr_logical,delayed_compare,jmpreg,mfcr")
       (eq_attr "cpu" "ppc440"))
  "i_pipe")

(define_insn_reservation "ppc440-imul" 3
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc440"))
  "i_pipe")

(define_insn_reservation "ppc440-imul2" 2
  (and (eq_attr "type" "imul2,imul3")
       (eq_attr "cpu" "ppc440"))
  "i_pipe")

(define_insn_reservation "ppc440-idiv" 6
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc440"))
  "i_pipe")

(define_insn_reservation "ppc440-mtcr" 3
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppc440"))
  "i_pipe")

(define_insn_reservation "ppc440-mtjmpr" 3
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc440"))
  "i_pipe")

