/* Parameters for execution on a Matsushita mn10200 processor.

   Copyright 1997, 1998, 1999, 2000, 2001, 2002, 2003 Free Software
   Foundation, Inc.

   Contributed by Geoffrey Noer <noer@cygnus.com>

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* FIXME: cagney/2001-03-01: The below macros refer to functions
   declared in "regcache.h".  The ``correct fix'' is to convert those
   macros into functions.  */
#include "regcache.h"
#include "symtab.h"		/* For namespace_enum.  */
#include "symfile.h"		/* For entry_point_address().  */

/* ints are only 16bits on the mn10200.  */
#undef TARGET_INT_BIT
#define TARGET_INT_BIT 16

/* The mn10200 doesn't support long long types.  */
#undef TARGET_LONG_LONG_BIT
#define TARGET_LONG_LONG_BIT 32

/* The mn10200 doesn't support double or long double either.  */
#undef TARGET_DOUBLE_BIT
#undef TARGET_LONG_DOUBLE_BIT
#define TARGET_DOUBLE_BIT 32
#define TARGET_LONG_DOUBLE_BIT 32

/* Not strictly correct, but the machine independent code is not
   ready to handle any of the basic sizes not being a power of two.  */
#undef TARGET_PTR_BIT
#define TARGET_PTR_BIT 32

/* The mn10200 really has 24 bit registers but the simulator reads/writes
   them as 32bit values, so we claim they're 32bits each.  This may have
   to be tweaked if the Matsushita emulator/board really deals with them
   as 24bits each.  */
#define REGISTER_SIZE 4

#define MAX_REGISTER_RAW_SIZE REGISTER_SIZE
#define NUM_REGS 11

#define REGISTER_BYTES (NUM_REGS * REGISTER_SIZE)

#define REGISTER_NAMES \
{ "d0", "d1", "d2", "d3", "a0", "a1", "a2", "sp", \
  "pc", "mdr", "psw"}

#define FP_REGNUM 6
#define SP_REGNUM 7
#define PC_REGNUM 8
#define MDR_REGNUM 9
#define PSW_REGNUM 10

/* Treat the registers as 32bit values.  */
#define REGISTER_VIRTUAL_TYPE(REG) builtin_type_long

#define REGISTER_BYTE(REG) ((REG) * REGISTER_SIZE)
#define REGISTER_VIRTUAL_SIZE(REG) REGISTER_SIZE
#define REGISTER_RAW_SIZE(REG) REGISTER_SIZE

#define MAX_REGISTER_VIRTUAL_SIZE REGISTER_SIZE

/* The breakpoint instruction must be the same size as te smallest
   instruction in the instruction set.

   The Matsushita mn10x00 processors have single byte instructions
   so we need a single byte breakpoint.  Matsushita hasn't defined
   one, so we defined it ourselves.

   0xff is the only available single byte insn left on the mn10200.  */
#define BREAKPOINT {0xff}

#define FUNCTION_START_OFFSET 0

#define DECR_PC_AFTER_BREAK 0

/* Stacks grow the normal way.  */
#define INNER_THAN(lhs,rhs) ((lhs) < (rhs))

#define SAVED_PC_AFTER_CALL(frame) \
  (read_memory_integer (read_register (SP_REGNUM), REGISTER_SIZE) & 0xffffff)

struct frame_info;
struct frame_saved_regs;
struct type;
struct value;

#define EXTRA_FRAME_INFO struct frame_saved_regs fsr; int status; int stack_size;

extern void mn10200_init_extra_frame_info (struct frame_info *);
#define INIT_EXTRA_FRAME_INFO(fromleaf, fi) mn10200_init_extra_frame_info (fi)
#define DEPRECATED_INIT_FRAME_PC(x,y) (init_frame_pc_noop (x, y))
#define INIT_FRAME_PC_FIRST(x,y) (init_frame_pc_noop (x, y))

extern void mn10200_frame_find_saved_regs (struct frame_info *,
					   struct frame_saved_regs *);
#define FRAME_FIND_SAVED_REGS(fi, regaddr) regaddr = fi->fsr

extern CORE_ADDR mn10200_frame_chain (struct frame_info *);
#define FRAME_CHAIN(fi) mn10200_frame_chain (fi)

extern CORE_ADDR mn10200_find_callers_reg (struct frame_info *, int);
extern CORE_ADDR mn10200_frame_saved_pc (struct frame_info *);
#define FRAME_SAVED_PC(FI) (mn10200_frame_saved_pc (FI))

/* Extract from an array REGBUF containing the (raw) register state
   a function return value of type TYPE, and copy that, in virtual format,
   into VALBUF.  */

#define DEPRECATED_EXTRACT_RETURN_VALUE(TYPE, REGBUF, VALBUF) \
  { \
    if (TYPE_LENGTH (TYPE) > 8) \
      internal_error (__FILE__, __LINE__, "failed internal consistency check"); \
    else if (TYPE_LENGTH (TYPE) > 2 && TYPE_CODE (TYPE) != TYPE_CODE_PTR) \
      { \
	memcpy (VALBUF, REGBUF + REGISTER_BYTE (0), 2); \
	memcpy (VALBUF + 2, REGBUF + REGISTER_BYTE (1), 2); \
      } \
    else if (TYPE_CODE (TYPE) == TYPE_CODE_PTR)\
      { \
        memcpy (VALBUF, REGBUF + REGISTER_BYTE (4), TYPE_LENGTH (TYPE)); \
      } \
    else \
      { \
        memcpy (VALBUF, REGBUF + REGISTER_BYTE (0), TYPE_LENGTH (TYPE)); \
      } \
  }

#define DEPRECATED_EXTRACT_STRUCT_VALUE_ADDRESS(REGBUF) \
  extract_address (REGBUF + REGISTER_BYTE (4), \
		   REGISTER_RAW_SIZE (4))

#define DEPRECATED_STORE_RETURN_VALUE(TYPE, VALBUF) \
  { \
    if (TYPE_LENGTH (TYPE) > 8) \
      internal_error (__FILE__, __LINE__, "failed internal consistency check"); \
    else if (TYPE_LENGTH (TYPE) > 2 && TYPE_CODE (TYPE) != TYPE_CODE_PTR) \
      { \
	deprecated_write_register_bytes (REGISTER_BYTE (0), VALBUF, 2); \
	deprecated_write_register_bytes (REGISTER_BYTE (1), VALBUF + 2, 2); \
      } \
    else if (TYPE_CODE (TYPE) == TYPE_CODE_PTR)\
      { \
        deprecated_write_register_bytes (REGISTER_BYTE (4), VALBUF, TYPE_LENGTH (TYPE)); \
      } \
    else \
      { \
        deprecated_write_register_bytes (REGISTER_BYTE (0), VALBUF, TYPE_LENGTH (TYPE)); \
      } \
  }


extern CORE_ADDR mn10200_store_struct_return (CORE_ADDR addr, CORE_ADDR sp);
#define STORE_STRUCT_RETURN(STRUCT_ADDR, SP) \
  (SP) = mn10200_store_struct_return (STRUCT_ADDR, SP)

extern CORE_ADDR mn10200_skip_prologue (CORE_ADDR);
#define SKIP_PROLOGUE(pc) (mn10200_skip_prologue (pc))

#define FRAME_ARGS_SKIP 0

#define FRAME_ARGS_ADDRESS(fi) (get_frame_base (fi))
#define FRAME_LOCALS_ADDRESS(fi) (get_frame_base (fi))
#define FRAME_NUM_ARGS(fi) (-1)

extern void mn10200_pop_frame (struct frame_info *);
#define POP_FRAME mn10200_pop_frame (get_current_frame ())

#define DEPRECATED_USE_GENERIC_DUMMY_FRAMES 1
#define CALL_DUMMY                   {0}
#define CALL_DUMMY_START_OFFSET      (0)
#define CALL_DUMMY_BREAKPOINT_OFFSET (0)
#define CALL_DUMMY_LOCATION          AT_ENTRY_POINT
#define FIX_CALL_DUMMY(DUMMY, START, FUNADDR, NARGS, ARGS, TYPE, GCCP)
#define CALL_DUMMY_ADDRESS()         entry_point_address ()

extern CORE_ADDR mn10200_push_return_address (CORE_ADDR, CORE_ADDR);
#define PUSH_RETURN_ADDRESS(PC, SP)  mn10200_push_return_address (PC, SP)

#define PUSH_DUMMY_FRAME	generic_push_dummy_frame ()

extern CORE_ADDR mn10200_push_arguments (int, struct value **, CORE_ADDR,
					 unsigned char, CORE_ADDR);
#define PUSH_ARGUMENTS(NARGS, ARGS, SP, STRUCT_RETURN, STRUCT_ADDR) \
  (mn10200_push_arguments (NARGS, ARGS, SP, STRUCT_RETURN, STRUCT_ADDR))

#define DEPRECATED_PC_IN_CALL_DUMMY(PC, SP, FP) generic_pc_in_call_dummy (PC, SP, FP)

#define REG_STRUCT_HAS_ADDR(gcc_p,TYPE) \
  	(TYPE_LENGTH (TYPE) > 8)

extern use_struct_convention_fn mn10200_use_struct_convention;
#define USE_STRUCT_CONVENTION(GCC_P, TYPE) mn10200_use_struct_convention (GCC_P, TYPE)

/* Define this for Wingdb */
#define TARGET_MN10200
