Attribute VB_Name = "Process"
' From Microsoft Knowledge Base Article - Q129796
'
'
   
Private Type STARTUPINFO
    cb As Long
    lpReserved As String
    lpDesktop As String
    lpTitle As String
    dwX As Long
    dwY As Long
    dwXSize As Long
    dwYSize As Long
    dwXCountChars As Long
    dwYCountChars As Long
    dwFillAttribute As Long
    dwFlags As Long
    wShowWindow As Integer
    cbReserved2 As Integer
    lpReserved2 As Long
    hStdInput As Long
    hStdOutput As Long
    hStdError As Long
End Type

Private Type PROCESS_INFORMATION
    hProcess As Long
    hThread As Long
    dwProcessID As Long
    dwThreadID As Long
End Type

Private Declare Function WaitForSingleObject Lib "kernel32" (ByVal _
                    hHandle As Long, ByVal dwMilliseconds As Long) As Long

Private Declare Function CreateProcessA Lib "kernel32" (ByVal _
                    lpApplicationName As String, ByVal lpCommandLine As String, ByVal _
                    lpProcessAttributes As Long, ByVal lpThreadAttributes As Long, _
                    ByVal bInheritHandles As Long, ByVal dwCreationFlags As Long, _
                    ByVal lpEnvironment As Long, ByVal lpCurrentDirectory As String, _
                    lpStartupInfo As STARTUPINFO, lpProcessInformation As _
                    PROCESS_INFORMATION) As Long

Private Declare Function CloseHandle Lib "kernel32" _
                  (ByVal hObject As Long) As Long

Private Declare Function GetExitCodeProcess Lib "kernel32" _
                    (ByVal hProcess As Long, lpExitCode As Long) As Long

Private Const NORMAL_PRIORITY_CLASS = &H20&
Private Const INFINITE = -1&

'
' Pending issue here: waiting for the called process is infinite
'
Public Function ExecCmd(cmdline$, doWait As Boolean)
      
    Dim proc As PROCESS_INFORMATION
    Dim start As STARTUPINFO

    ' Initialize the STARTUPINFO structure:
    start.cb = Len(start)

    ' Start the shelled application:
    ret& = CreateProcessA(vbNullString, cmdline$, 0&, 0&, 1&, _
         NORMAL_PRIORITY_CLASS, 0&, vbNullString, start, proc)

    ' Wait for the shelled application to finish:
    If doWait = True Then
        ret& = WaitForSingleObject(proc.hProcess, INFINITE)
        Call GetExitCodeProcess(proc.hProcess, ret&)
        Call CloseHandle(proc.hThread)
        Call CloseHandle(proc.hProcess)
    End If
    
    ExecCmd = ret&
End Function

