/*******************************************************************
*                                                                  *
*             This software is part of the ast package             *
*                Copyright (c) 1985-2004 AT&T Corp.                *
*        and it may only be used by you under license from         *
*                       AT&T Corp. ("AT&T")                        *
*         A copy of the Source Code Agreement is available         *
*                at the AT&T Internet web site URL                 *
*                                                                  *
*       http://www.research.att.com/sw/license/ast-open.html       *
*                                                                  *
*    If you have copied or used this software without agreeing     *
*        to the terms of the license you are infringing on         *
*           the license and copyright and are violating            *
*               AT&T's intellectual property rights.               *
*                                                                  *
*            Information and Software Systems Research             *
*                        AT&T Labs Research                        *
*                         Florham Park NJ                          *
*                                                                  *
*               Glenn Fowler <gsf@research.att.com>                *
*                David Korn <dgk@research.att.com>                 *
*                 Phong Vo <kpv@research.att.com>                  *
*                                                                  *
*******************************************************************/
#pragma prototyped

/*
 * Glenn Fowler
 * AT&T Research
 *
 * dynamic single byte character code maps
 */

#include <ast.h>
#include <ccode.h>

/*
 * catenated CC_ASCII to CC_* character code map table
 * order determined by CC_* index definitions
 * old definition values/indices must not change!
 * each table is followed by its inverse
 */

static const unsigned char tab[] =
{
	/* CC_ASCII=>CC_ASCII */

	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0025,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0045,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0112,0113,0114,0115,0116,0117,
	0120,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0132,0133,0134,0135,0136,0137,
	0140,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0152,0153,0154,0155,0156,0157,
	0160,0161,0162,0163,0164,0165,0166,0167,
	0170,0171,0172,0173,0174,0175,0176,0177,
	0200,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0212,0213,0214,0215,0216,0217,
	0220,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0232,0233,0234,0235,0236,0237,
	0240,0241,0242,0243,0244,0245,0246,0247,
	0250,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0312,0313,0314,0315,0316,0317,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0345,0346,0347,
	0350,0351,0352,0353,0354,0355,0356,0357,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0372,0373,0374,0375,0376,0377,

	/* CC_ASCII=>CC_ASCII */

	0000,0001,0002,0003,0004,0005,0006,0007,
	0010,0011,0012,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0024,0025,0026,0027,
	0030,0031,0032,0033,0034,0035,0036,0037,
	0040,0041,0042,0043,0044,0045,0046,0047,
	0050,0051,0052,0053,0054,0055,0056,0057,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0072,0073,0074,0075,0076,0077,
	0100,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0112,0113,0114,0115,0116,0117,
	0120,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0132,0133,0134,0135,0136,0137,
	0140,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0152,0153,0154,0155,0156,0157,
	0160,0161,0162,0163,0164,0165,0166,0167,
	0170,0171,0172,0173,0174,0175,0176,0177,
	0200,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0212,0213,0214,0215,0216,0217,
	0220,0221,0222,0223,0224,0225,0226,0227,
	0230,0231,0232,0233,0234,0235,0236,0237,
	0240,0241,0242,0243,0244,0245,0246,0247,
	0250,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0300,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0312,0313,0314,0315,0316,0317,
	0320,0321,0322,0323,0324,0325,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0345,0346,0347,
	0350,0351,0352,0353,0354,0355,0356,0357,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0372,0373,0374,0375,0376,0377,

	/* CC_ASCII=>CC_EBCDIC_E */

	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0045,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0255,0340,0275,0232,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0137,0007,
	0040,0041,0042,0043,0044,0025,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0341,
	0101,0102,0103,0104,0105,0106,0107,0110,
	0111,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0142,0143,0144,0145,0146,0147,
	0150,0151,0160,0161,0162,0163,0164,0165,
	0166,0167,0170,0200,0212,0213,0214,0215,
	0216,0217,0220,0152,0233,0234,0235,0236,
	0237,0240,0252,0253,0254,0112,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0241,0276,0277,
	0312,0313,0314,0315,0316,0317,0332,0333,
	0334,0335,0336,0337,0352,0353,0354,0355,
	0356,0357,0372,0373,0374,0375,0376,0377,

	/* CC_EBCDIC_E=>CC_ASCII */

	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0205,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0012,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0241,0242,0243,0244,0245,0246,
	0247,0250,0325,0056,0074,0050,0053,0174,
	0046,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0041,0044,0052,0051,0073,0176,
	0055,0057,0262,0263,0264,0265,0266,0267,
	0270,0271,0313,0054,0045,0137,0076,0077,
	0272,0273,0274,0275,0276,0277,0300,0301,
	0302,0140,0072,0043,0100,0047,0075,0042,
	0303,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0304,0305,0306,0307,0310,0311,
	0312,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0136,0314,0315,0316,0317,0320,
	0321,0345,0163,0164,0165,0166,0167,0170,
	0171,0172,0322,0323,0324,0133,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0135,0346,0347,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0350,0351,0352,0353,0354,0355,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0356,0357,0360,0361,0362,0363,
	0134,0237,0123,0124,0125,0126,0127,0130,
	0131,0132,0364,0365,0366,0367,0370,0371,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0372,0373,0374,0375,0376,0377,

	/* CC_ASCII=>CC_EBCDIC_I */

	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0045,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0255,0340,0275,0137,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0241,0007,
	0040,0041,0042,0043,0044,0025,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0341,
	0101,0102,0103,0104,0105,0106,0107,0110,
	0111,0121,0122,0123,0124,0125,0126,0127,
	0130,0131,0142,0143,0144,0145,0146,0147,
	0150,0151,0160,0161,0162,0163,0164,0165,
	0166,0167,0170,0200,0212,0213,0214,0215,
	0216,0217,0220,0232,0233,0234,0235,0236,
	0237,0240,0252,0253,0254,0255,0256,0257,
	0260,0261,0262,0263,0264,0265,0266,0267,
	0270,0271,0272,0273,0274,0275,0276,0277,
	0312,0313,0314,0315,0316,0317,0332,0333,
	0334,0335,0336,0337,0352,0353,0354,0355,
	0356,0357,0372,0373,0374,0375,0376,0377,

	/* CC_EBCDIC_I=>CC_ASCII */

	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0205,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0012,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0241,0242,0243,0244,0245,0246,
	0247,0250,0112,0056,0074,0050,0053,0174,
	0046,0251,0252,0253,0254,0255,0256,0257,
	0260,0261,0041,0044,0052,0051,0073,0136,
	0055,0057,0262,0263,0264,0265,0266,0267,
	0270,0271,0152,0054,0045,0137,0076,0077,
	0272,0273,0274,0275,0276,0277,0300,0301,
	0302,0140,0072,0043,0100,0047,0075,0042,
	0303,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0304,0305,0306,0307,0310,0311,
	0312,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0313,0314,0315,0316,0317,0320,
	0321,0176,0163,0164,0165,0166,0167,0170,
	0171,0172,0322,0323,0324,0133,0326,0327,
	0330,0331,0332,0333,0334,0335,0336,0337,
	0340,0341,0342,0343,0344,0135,0346,0347,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0350,0351,0352,0353,0354,0355,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0356,0357,0360,0361,0362,0363,
	0134,0237,0123,0124,0125,0126,0127,0130,
	0131,0132,0364,0365,0366,0367,0370,0371,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0372,0373,0374,0375,0376,0377,

	/* CC_ASCII=>CC_EBDCID_O */

	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0025,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0255,0340,0275,0137,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0241,0007,
	0040,0041,0042,0043,0044,0045,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0377,
	0101,0252,0112,0261,0237,0262,0152,0265,
	0273,0264,0232,0212,0260,0312,0257,0274,
	0220,0217,0352,0372,0276,0240,0266,0263,
	0235,0332,0233,0213,0267,0270,0271,0253,
	0144,0145,0142,0146,0143,0147,0236,0150,
	0164,0161,0162,0163,0170,0165,0166,0167,
	0254,0151,0355,0356,0353,0357,0354,0277,
	0200,0375,0376,0373,0374,0272,0256,0131,
	0104,0105,0102,0106,0103,0107,0234,0110,
	0124,0121,0122,0123,0130,0125,0126,0127,
	0214,0111,0315,0316,0313,0317,0314,0341,
	0160,0335,0336,0333,0334,0215,0216,0337,

	/* CC_EBDCID_O=>CC_ASCII */

	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0012,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0205,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0342,0344,0340,0341,0343,0345,
	0347,0361,0242,0056,0074,0050,0053,0174,
	0046,0351,0352,0353,0350,0355,0356,0357,
	0354,0337,0041,0044,0052,0051,0073,0136,
	0055,0057,0302,0304,0300,0301,0303,0305,
	0307,0321,0246,0054,0045,0137,0076,0077,
	0370,0311,0312,0313,0310,0315,0316,0317,
	0314,0140,0072,0043,0100,0047,0075,0042,
	0330,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0253,0273,0360,0375,0376,0261,
	0260,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0252,0272,0346,0270,0306,0244,
	0265,0176,0163,0164,0165,0166,0167,0170,
	0171,0172,0241,0277,0320,0133,0336,0256,
	0254,0243,0245,0267,0251,0247,0266,0274,
	0275,0276,0335,0250,0257,0135,0264,0327,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0255,0364,0366,0362,0363,0365,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0271,0373,0374,0371,0372,0377,
	0134,0367,0123,0124,0125,0126,0127,0130,
	0131,0132,0262,0324,0326,0322,0323,0325,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0263,0333,0334,0331,0332,0237,

	/* CC_ASCII=>CC_EBCDIC_S */

	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0025,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0273,0274,0275,0152,0155,
	0112,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0373,0117,0375,0377,0007,
	0040,0041,0042,0043,0044,0045,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0137,
	0101,0252,0260,0261,0237,0262,0320,0265,
	0171,0264,0232,0212,0272,0312,0257,0241,
	0220,0217,0352,0372,0276,0240,0266,0263,
	0235,0332,0233,0213,0267,0270,0271,0253,
	0144,0145,0142,0146,0143,0147,0236,0150,
	0164,0161,0162,0163,0170,0165,0166,0167,
	0254,0151,0355,0356,0353,0357,0354,0277,
	0200,0340,0376,0335,0374,0255,0256,0131,
	0104,0105,0102,0106,0103,0107,0234,0110,
	0124,0121,0122,0123,0130,0125,0126,0127,
	0214,0111,0315,0316,0313,0317,0314,0341,
	0160,0300,0336,0333,0334,0215,0216,0337,

	/* CC_EBCDIC_S=>CC_ASCII */

	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0012,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0205,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0342,0344,0340,0341,0343,0345,
	0347,0361,0140,0056,0074,0050,0053,0174,
	0046,0351,0352,0353,0350,0355,0356,0357,
	0354,0337,0041,0044,0052,0051,0073,0237,
	0055,0057,0302,0304,0300,0301,0303,0305,
	0307,0321,0136,0054,0045,0137,0076,0077,
	0370,0311,0312,0313,0310,0315,0316,0317,
	0314,0250,0072,0043,0100,0047,0075,0042,
	0330,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0253,0273,0360,0375,0376,0261,
	0260,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0252,0272,0346,0270,0306,0244,
	0265,0257,0163,0164,0165,0166,0167,0170,
	0171,0172,0241,0277,0320,0335,0336,0256,
	0242,0243,0245,0267,0251,0247,0266,0274,
	0275,0276,0254,0133,0134,0135,0264,0327,
	0371,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0255,0364,0366,0362,0363,0365,
	0246,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0271,0373,0374,0333,0372,0377,
	0331,0367,0123,0124,0125,0126,0127,0130,
	0131,0132,0262,0324,0326,0322,0323,0325,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0263,0173,0334,0175,0332,0176,

	/* CC_ASCII=>CC_EBCDIC_H */

	0000,0001,0002,0003,0067,0055,0056,0057,
	0026,0005,0045,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0074,0075,0062,0046,
	0030,0031,0077,0047,0034,0035,0036,0037,
	0100,0132,0177,0173,0133,0154,0120,0175,
	0115,0135,0134,0116,0153,0140,0113,0141,
	0360,0361,0362,0363,0364,0365,0366,0367,
	0370,0371,0172,0136,0114,0176,0156,0157,
	0174,0301,0302,0303,0304,0305,0306,0307,
	0310,0311,0321,0322,0323,0324,0325,0326,
	0327,0330,0331,0342,0343,0344,0345,0346,
	0347,0350,0351,0272,0340,0273,0260,0155,
	0171,0201,0202,0203,0204,0205,0206,0207,
	0210,0211,0221,0222,0223,0224,0225,0226,
	0227,0230,0231,0242,0243,0244,0245,0246,
	0247,0250,0251,0300,0117,0320,0241,0007,
	0040,0041,0042,0043,0044,0025,0006,0027,
	0050,0051,0052,0053,0054,0011,0012,0033,
	0060,0061,0032,0063,0064,0065,0066,0010,
	0070,0071,0072,0073,0004,0024,0076,0377,
	0101,0252,0112,0261,0237,0262,0152,0265,
	0275,0264,0232,0212,0137,0312,0257,0274,
	0220,0217,0352,0372,0276,0240,0266,0263,
	0235,0332,0233,0213,0267,0270,0271,0253,
	0144,0145,0142,0146,0143,0147,0236,0150,
	0164,0161,0162,0163,0170,0165,0166,0167,
	0254,0151,0355,0356,0353,0357,0354,0277,
	0200,0375,0376,0373,0374,0255,0256,0131,
	0104,0105,0102,0106,0103,0107,0234,0110,
	0124,0121,0122,0123,0130,0125,0126,0127,
	0214,0111,0315,0316,0313,0317,0314,0341,
	0160,0335,0336,0333,0334,0215,0216,0337,

	/* CC_EBCDIC_H=>CC_ASCII */

	0000,0001,0002,0003,0234,0011,0206,0177,
	0227,0215,0216,0013,0014,0015,0016,0017,
	0020,0021,0022,0023,0235,0205,0010,0207,
	0030,0031,0222,0217,0034,0035,0036,0037,
	0200,0201,0202,0203,0204,0012,0027,0033,
	0210,0211,0212,0213,0214,0005,0006,0007,
	0220,0221,0026,0223,0224,0225,0226,0004,
	0230,0231,0232,0233,0024,0025,0236,0032,
	0040,0240,0342,0344,0340,0341,0343,0345,
	0347,0361,0242,0056,0074,0050,0053,0174,
	0046,0351,0352,0353,0350,0355,0356,0357,
	0354,0337,0041,0044,0052,0051,0073,0254,
	0055,0057,0302,0304,0300,0301,0303,0305,
	0307,0321,0246,0054,0045,0137,0076,0077,
	0370,0311,0312,0313,0310,0315,0316,0317,
	0314,0140,0072,0043,0100,0047,0075,0042,
	0330,0141,0142,0143,0144,0145,0146,0147,
	0150,0151,0253,0273,0360,0375,0376,0261,
	0260,0152,0153,0154,0155,0156,0157,0160,
	0161,0162,0252,0272,0346,0270,0306,0244,
	0265,0176,0163,0164,0165,0166,0167,0170,
	0171,0172,0241,0277,0320,0335,0336,0256,
	0136,0243,0245,0267,0251,0247,0266,0274,
	0275,0276,0133,0135,0257,0250,0264,0327,
	0173,0101,0102,0103,0104,0105,0106,0107,
	0110,0111,0255,0364,0366,0362,0363,0365,
	0175,0112,0113,0114,0115,0116,0117,0120,
	0121,0122,0271,0373,0374,0371,0372,0377,
	0134,0367,0123,0124,0125,0126,0127,0130,
	0131,0132,0262,0324,0326,0322,0323,0325,
	0060,0061,0062,0063,0064,0065,0066,0067,
	0070,0071,0263,0333,0334,0331,0332,0237,

};

#define MAP	256
#define MAPS	(sizeof(tab)/MAP)

struct Map_s; typedef struct Map_s Map_t;

struct Map_s
{
	Map_t*		next;
	int		op;
	unsigned char	map[MAP];
};

static Map_t*	maps;

/*
 * generate and return ccode map from i to o
 */

unsigned char*
_ccmap(int i, int o)
{
	register unsigned char*	a;
	register unsigned char*	m;
	register unsigned char*	z;
	register Map_t*		map;
	register int		n;
	int			op;

	if (!i && !o)
		return (unsigned char*)tab;
	if (CCCONVERT(i))
	{
		o = CCOUT(i);
		i = CCIN(i);
	}
	else if (CCCONVERT(o))
	{
		i = CCIN(o);
		o = CCOUT(o);
	}
	else
	{
		if (i == 0)
			i = CC_NATIVE;
		if (o == 0)
			o = CC_NATIVE;
	}
	if (i == o || i < 1 || i > MAPS || o < 1 || o > MAPS)
		return 0;
	if (i == CC_ASCII)
		return (unsigned char*)tab + MAP * (2 * (o - 1));
	if (o == CC_ASCII)
		return (unsigned char*)tab + MAP * (2 * (i - 1) + 1);
	op = CCOP(i, o);
	for (map = maps; map; map = map->next)
		if (map->op == op)
			return map->map;
	if (!(map = newof(0, Map_t, 1, 0)))
		return 0;
	map->op = op;
	a = (unsigned char*)tab + MAP * (2 * (o - 1));
	z = (unsigned char*)tab + MAP * (2 * (i - 1) + 1);
	m = map->map;
	for (n = 0; n < MAP; n++)
		m[n] = n;
	for (n = MAP - 1; n >= 0; n--)
		m[n] = a[z[n]];
	map->next = maps;
	maps = map;
	return m;
}

void*
_ccmapcpy(register unsigned char* m, void* b, const void* a, size_t n)
{
	register unsigned char*	ub;
	register unsigned char*	ue;
	register unsigned char*	ua;

	if (m)
	{
		ub = (unsigned char*)b;
		ue = ub + n;
		ua = (unsigned char*)a;
		while (ub < ue)
			*ub++ = m[*ua++];
	}
	else
		memcpy(b, a, n);
	return b;
}

void*
_ccmapstr(register unsigned char* m, void* b, size_t n)
{
	register unsigned char*	s;
	register unsigned char*	e;

	if (m)
		for (e = (s = (unsigned char*)b) + n; s < e; s++)
			*s = m[*s];
	return b;
}

#if __OBSOLETE__ && __OBSOLETE__ < 20050101

const unsigned char*	_cc_map[] =
{
    &tab[0],       &tab[(1*2+1)*256], &tab[(2*2+1)*256], &tab[(3*2+1)*256],
    &tab[1*2*256], &tab[0],           &tab[0],           &tab[0],
    &tab[2*2*256], &tab[0],           &tab[0],           &tab[0],
    &tab[3*2*256], &tab[0],           &tab[0],           &tab[0],
};

#if !_BLD_DLL && _dll_import
const unsigned char** _imp___cc_map = _cc_map;
#endif

#if _BLD_ast && defined(__EXPORT__)
#define extern		__EXPORT__
#endif

#undef	ccmapcpy

extern void*
ccmapcpy(void* b, const void* a, size_t n, int in, int out)
{
	return _ccmapcpy(ccmap(in, out), b, a, n);
}

extern void*
_ccmaps(void* b, size_t n, int in, int out)
{
	return _ccmapstr(ccmap(in, out), b, n);
}

#undef	extern

#endif
