/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.42 $ of : mfd-interface.m2c,v $ 
 *
 * $Id: ifXTable_interface.c,v 1.11 2004/10/15 23:52:21 rstory Exp $
 */
/*
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 * ***                                                               ***
 * ***  NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THIS FILE DOES NOT CONTAIN ANY USER EDITABLE CODE.      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THE GENERATED CODE IS INTERNAL IMPLEMENTATION, AND      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***    IS SUBJECT TO CHANGE WITHOUT WARNING IN FUTURE RELEASES.   ***
 * ***                                                               ***
 * ***                                                               ***
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 */

/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ifXTable.h"


#include <net-snmp/library/container.h>

#include "ifXTable_interface.h"

/**********************************************************************
 **********************************************************************
 ***
 *** Table ifXTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * ifXTable is subid 1 of ifMIBObjects.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.31.1.1, length: 9
 */
typedef struct ifXTable_interface_ctx_s {

    netsnmp_container *container;
    netsnmp_cache  *cache;      /* optional cache */

    ifXTable_registration_ptr user_ctx;

    netsnmp_table_registration_info tbl_info;

    netsnmp_baby_steps_access_methods access_multiplexer;

} ifXTable_interface_ctx;

static ifXTable_interface_ctx ifXTable_if_ctx;

static void     _ifXTable_container_init(ifXTable_interface_ctx * if_ctx);


static Netsnmp_Node_Handler _mfd_ifXTable_pre_request;
static Netsnmp_Node_Handler _mfd_ifXTable_post_request;
static Netsnmp_Node_Handler _mfd_ifXTable_object_lookup;
static Netsnmp_Node_Handler _mfd_ifXTable_get_values;
static Netsnmp_Node_Handler _mfd_ifXTable_check_objects;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_setup;
static Netsnmp_Node_Handler _mfd_ifXTable_set_values;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_cleanup;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_values;
static Netsnmp_Node_Handler _mfd_ifXTable_commit;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_commit;
static Netsnmp_Node_Handler _mfd_ifXTable_check_dependencies;

NETSNMP_STATIC_INLINE int _ifXTable_undo_column(ifXTable_rowreq_ctx *
                                                rowreq_ctx,
                                                netsnmp_variable_list *
                                                var, int column);

ifXTable_data  *ifXTable_allocate_data(void);

/**
 * @internal
 * Initialize the table ifXTable 
 *    (Define its contents and how it's structured)
 */
void
_ifXTable_initialize_interface(ifXTable_registration_ptr reg_ptr,
                               u_long flags)
{
    netsnmp_baby_steps_access_methods *access_multiplexer =
        &ifXTable_if_ctx.access_multiplexer;
    netsnmp_table_registration_info *tbl_info = &ifXTable_if_ctx.tbl_info;
    netsnmp_handler_registration *reginfo;
    netsnmp_mib_handler *handler;
    int             mfd_modes = 0;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_initialize_interface",
                "called\n"));


    /*************************************************
     *
     * save interface context for ifXTable
     */
    /*
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(tbl_info, ASN_INTEGER,
                                               /** index: ifIndex */
                                     0);

    /*
     * Define the minimum and maximum accessible columns.  This
     * optimizes retrival. 
     */
    tbl_info->min_column = IFXTABLE_MIN_COL;
    tbl_info->max_column = IFXTABLE_MAX_COL;

    /*
     * save users context
     */
    ifXTable_if_ctx.user_ctx = reg_ptr;

    /*
     * call data access initialization code
     */
    ifXTable_init_data(reg_ptr);

    /*
     * set up the container
     */
    _ifXTable_container_init(&ifXTable_if_ctx);
    if (NULL == ifXTable_if_ctx.container) {
        snmp_log(LOG_ERR, "could not initialize container for ifXTable\n");
        return;
    }

    /*
     * access_multiplexer: REQUIRED wrapper for get request handling
     */
    access_multiplexer->object_lookup = _mfd_ifXTable_object_lookup;
    access_multiplexer->get_values = _mfd_ifXTable_get_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->pre_request = _mfd_ifXTable_pre_request;
    access_multiplexer->post_request = _mfd_ifXTable_post_request;


    /*
     * REQUIRED wrappers for set request handling
     */
    access_multiplexer->object_syntax_checks = _mfd_ifXTable_check_objects;
    access_multiplexer->undo_setup = _mfd_ifXTable_undo_setup;
    access_multiplexer->undo_cleanup = _mfd_ifXTable_undo_cleanup;
    access_multiplexer->set_values = _mfd_ifXTable_set_values;
    access_multiplexer->undo_sets = _mfd_ifXTable_undo_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->commit = _mfd_ifXTable_commit;
    access_multiplexer->undo_commit = _mfd_ifXTable_undo_commit;

    /*
     * REQUIRED for tables with dependencies
     */
    access_multiplexer->consistency_checks =
        _mfd_ifXTable_check_dependencies;

    /*************************************************
     *
     * Create a registration, save our reg data, register table.
     */
    DEBUGMSGTL(("ifXTable:init_ifXTable",
                "Registering ifXTable as a mibs-for-dummies table.\n"));
    handler =
        netsnmp_baby_steps_access_multiplexer_get(access_multiplexer);
    reginfo =
        netsnmp_handler_registration_create("ifXTable", handler,
                                            ifXTable_oid,
                                            ifXTable_oid_size,
                                            HANDLER_CAN_BABY_STEP |
                                            HANDLER_CAN_RWRITE);
    if (NULL == reginfo) {
        snmp_log(LOG_ERR, "error registering table ifXTable\n");
        return;
    }
    reginfo->my_reg_void = &ifXTable_if_ctx;

    /*************************************************
     *
     * set up baby steps handler, create it and inject it
     */
    if (access_multiplexer->object_lookup)
        mfd_modes |= BABY_STEP_OBJECT_LOOKUP;
    if (access_multiplexer->set_values)
        mfd_modes |= BABY_STEP_SET_VALUES;
    if (access_multiplexer->irreversible_commit)
        mfd_modes |= BABY_STEP_IRREVERSIBLE_COMMIT;
    if (access_multiplexer->object_syntax_checks)
        mfd_modes |= BABY_STEP_CHECK_OBJECT;

    if (access_multiplexer->pre_request)
        mfd_modes |= BABY_STEP_PRE_REQUEST;
    if (access_multiplexer->post_request)
        mfd_modes |= BABY_STEP_POST_REQUEST;

    if (access_multiplexer->undo_setup)
        mfd_modes |= BABY_STEP_UNDO_SETUP;
    if (access_multiplexer->undo_cleanup)
        mfd_modes |= BABY_STEP_UNDO_CLEANUP;
    if (access_multiplexer->undo_sets)
        mfd_modes |= BABY_STEP_UNDO_SETS;

    if (access_multiplexer->row_creation)
        mfd_modes |= BABY_STEP_ROW_CREATE;
    if (access_multiplexer->consistency_checks)
        mfd_modes |= BABY_STEP_CHECK_CONSISTENCY;
    if (access_multiplexer->commit)
        mfd_modes |= BABY_STEP_COMMIT;
    if (access_multiplexer->undo_commit)
        mfd_modes |= BABY_STEP_UNDO_COMMIT;

    handler = netsnmp_baby_steps_handler_get(mfd_modes);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject row_merge helper with prefix rootoid_len + 2 (entry.col)
     */
    handler = netsnmp_get_row_merge_handler(reginfo->rootoid_len + 2);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject container_table helper
     */
    handler =
        netsnmp_container_table_handler_get(tbl_info,
                                            ifXTable_if_ctx.container,
                                            TABLE_CONTAINER_KEY_NETSNMP_INDEX);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject cache helper
     */
    if (NULL != ifXTable_if_ctx.cache) {
        handler = netsnmp_cache_handler_get(ifXTable_if_ctx.cache);
        netsnmp_inject_handler(reginfo, handler);
    }

    /*
     * register table
     */
    netsnmp_register_table(reginfo, tbl_info);
}                               /* _ifXTable_initialize_interface */

void
ifXTable_valid_columns_set(netsnmp_column_info *vc)
{
    ifXTable_if_ctx.tbl_info.valid_columns = vc;
}                               /* ifXTable_valid_columns_set */

/**
 * @internal
 * convert the index component stored in the context to an oid
 */
int
ifXTable_index_to_oid(netsnmp_index * oid_idx,
                      ifXTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H
     */
    netsnmp_variable_list var_ifIndex;

    /*
     * set up varbinds
     */
    memset(&var_ifIndex, 0x00, sizeof(var_ifIndex));
    var_ifIndex.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_ifIndex.next_variable = NULL;


    DEBUGMSGTL(("verbose:ifXTable:ifXTable_index_to_oid", "called\n"));

    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H 
     */
    snmp_set_var_value(&var_ifIndex, (u_char *) & mib_idx->ifIndex,
                       sizeof(mib_idx->ifIndex));


    err = build_oid_noalloc(oid_idx->oids, oid_idx->len, &oid_idx->len,
                            NULL, 0, &var_ifIndex);
    if (err)
        snmp_log(LOG_ERR, "error %d converting index to oid\n");

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ifIndex);

    return err;
}                               /* ifXTable_index_to_oid */

/**
 * extract ifXTable indexes from a netsnmp_index
 *
 * @retval SNMP_ERR_NOERROR  : no error
 * @retval SNMP_ERR_GENERR   : error
 */
int
ifXTable_index_from_oid(netsnmp_index * oid_idx,
                        ifXTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H
     */
    netsnmp_variable_list var_ifIndex;

    /*
     * set up varbinds
     */
    memset(&var_ifIndex, 0x00, sizeof(var_ifIndex));
    var_ifIndex.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_ifIndex.next_variable = NULL;


    DEBUGMSGTL(("verbose:ifXTable:ifXTable_index_from_oid", "called\n"));

    /*
     * parse the oid into the individual index components
     */
    err = parse_oid_indexes(oid_idx->oids, oid_idx->len, &var_ifIndex);
    if (err == SNMP_ERR_NOERROR) {
        /*
         * copy out values
         */
        mib_idx->ifIndex = *((long *) var_ifIndex.val.string);


    }

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ifIndex);

    return err;
}                               /* ifXTable_index_from_oid */


/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement ifXTable data context functions.
 */
/*
 * ifXTable_allocate_data
 *
 * Purpose: create new ifXTable_data.
 */
ifXTable_data  *
ifXTable_allocate_data(void)
{
    /*
     * TODO:201:r: |-> allocate memory for the ifXTable data context.
     */
    ifXTable_data  *rtn = SNMP_MALLOC_TYPEDEF(ifXTable_data);

    DEBUGMSGTL(("verbose:ifXTable:ifXTable_allocate_data", "called\n"));

    if (NULL == rtn) {
        snmp_log(LOG_ERR, "unable to malloc memory for new "
                 "ifXTable_data.\n");
    }

    return rtn;
}                               /* ifXTable_allocate_data */

/*
 * ifXTable_release_data
 *
 * Purpose: release ifXTable data.
 */
void
ifXTable_release_data(ifXTable_data * data)
{
    DEBUGMSGTL(("verbose:ifXTable:ifXTable_release_data", "called\n"));

    /*
     * TODO:202:r: |-> release memory for the ifXTable data context.
     */
    free(data);
}                               /* ifXTable_release_data */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ifXTable_pre_request(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *agtreq_info,
                          netsnmp_request_info *requests)
{
    int             rc = ifXTable_pre_request(ifXTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("internal:ifXTable", "error %d from "
                    "ifXTable_pre_request\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_pre_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ifXTable_post_request(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *agtreq_info,
                           netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx;
    int             rc = ifXTable_post_request(ifXTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("internal:ifXTable", "error %d from "
                    "ifXTable_post_request\n", rc));
    }

    /*
     * if it was set, clear row created flag.
     */
    rowreq_ctx = netsnmp_container_table_row_extract(requests);
    if ((NULL != rowreq_ctx)
        && (rowreq_ctx->rowreq_flags & MFD_ROW_CREATED))
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_CREATED;

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_post_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ifXTable_object_lookup(netsnmp_mib_handler *handler,
                            netsnmp_handler_registration *reginfo,
                            netsnmp_agent_request_info *agtreq_info,
                            netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_object_lookup",
                "called\n"));

    /*
     * get our context from mfd
     * ifXTable_interface_ctx *if_ctx =
     *             (ifXTable_interface_ctx *)reginfo->my_reg_void;
     */

    if (NULL == rowreq_ctx) {
        netsnmp_request_set_error_all(requests, SNMP_ERR_NOCREATION);
    } else {
        ifXTable_row_prep(rowreq_ctx);
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_object_lookup */

/***********************************************************************
 *
 * GET processing
 *
 ***********************************************************************/
/*
 * @internal
 * Retrieve the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_get_column(ifXTable_rowreq_ctx * rowreq_ctx,
                     netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_get_column", "called\n"));


    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifName(1)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/H 
         */
    case COLUMN_IFNAME:
        var->type = ASN_OCTET_STR;
        rc = ifName_get(rowreq_ctx, (char **) &var->val.string,
                        &var->val_len);
        break;

        /*
         * ifInMulticastPkts(2)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFINMULTICASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifInMulticastPkts_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifInBroadcastPkts(3)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFINBROADCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifInBroadcastPkts_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifOutMulticastPkts(4)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFOUTMULTICASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifOutMulticastPkts_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ifOutBroadcastPkts(5)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFOUTBROADCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifOutBroadcastPkts_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ifHCInOctets(6)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInOctets_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCInUcastPkts(7)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINUCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInUcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCInMulticastPkts(8)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINMULTICASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInMulticastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCInBroadcastPkts(9)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINBROADCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInBroadcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutOctets(10)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutOctets_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutUcastPkts(11)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTUCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutUcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutMulticastPkts(12)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTMULTICASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutMulticastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutBroadcastPkts(13)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTBROADCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutBroadcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ifLinkUpDownTrapEnable_get(rowreq_ctx,
                                        (u_long *) var->val.string);
        break;

        /*
         * ifHighSpeed(15)/GAUGE/ASN_GAUGE/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHIGHSPEED:
        var->val_len = sizeof(u_long);
        var->type = ASN_GAUGE;
        rc = ifHighSpeed_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ifPromiscuousMode_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifConnectorPresent(17)/TruthValue/ASN_INTEGER/long(u_long)//l/A/w/E/r/d/h 
         */
    case COLUMN_IFCONNECTORPRESENT:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ifConnectorPresent_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        var->type = ASN_OCTET_STR;
        rc = ifAlias_get(rowreq_ctx, (char **) &var->val.string,
                         &var->val_len);
        break;

        /*
         * ifCounterDiscontinuityTime(19)/TimeStamp/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFCOUNTERDISCONTINUITYTIME:
        var->val_len = sizeof(u_long);
        var->type = ASN_TIMETICKS;
        rc = ifCounterDiscontinuityTime_get(rowreq_ctx,
                                            (u_long *) var->val.string);
        break;

    default:
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_get_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_get_column */

int
_mfd_ifXTable_get_values(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    u_char         *old_string;
    void            (*dataFreeHook) (void *);
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_get_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * save old pointer, so we can free it if replaced
         */
        old_string = requests->requestvb->val.string;
        dataFreeHook = requests->requestvb->dataFreeHook;
        if (NULL == requests->requestvb->val.string) {
            requests->requestvb->val.string = requests->requestvb->buf;
            requests->requestvb->val_len =
                sizeof(requests->requestvb->buf);
        } else if (requests->requestvb->buf ==
                   requests->requestvb->val.string) {
            if (requests->requestvb->val_len !=
                sizeof(requests->requestvb->buf))
                requests->requestvb->val_len =
                    sizeof(requests->requestvb->buf);
        }

        /*
         * get column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_get_column(rowreq_ctx, requests->requestvb,
                                  tri->colnum);
        if (rc) {
            if (MFD_SKIP == rc) {
                requests->requestvb->type = ASN_PRIV_RETRY;
                rc = SNMP_ERR_NOERROR;
            }
        } else if (NULL == requests->requestvb->val.string) {
            snmp_log(LOG_ERR, "NULL varbind data pointer!\n");
            rc = SNMP_ERR_GENERR;
        }
        if (rc)
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));

        /*
         * if the buffer wasn't used previously for the old data (i.e. it
         * was allcoated memory)  and the get routine replaced the pointer,
         * we need to free the previous pointer.
         */
        if (old_string && (old_string != requests->requestvb->buf) &&
            (requests->requestvb->val.string != old_string)) {
            if (dataFreeHook)
                (*dataFreeHook) (old_string);
            else
                free(old_string);
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_get_values */

/***********************************************************************
 *
 * SET processing
 *
 ***********************************************************************/

/*----------------------------------------------------------------------
 *
 * SET: Syntax checks
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check the syntax for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_check_column(ifXTable_rowreq_ctx * rowreq_ctx,
                       netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_check_column", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   ifLinkUpDownTrapEnable));
        if (SNMPERR_SUCCESS == rc) {

            /*
             * check that the value is one of defined enums 
             */
            if (1 && (*var->val.integer != IFLINKUPDOWNTRAPENABLE_ENABLED)
                && (*var->val.integer != IFLINKUPDOWNTRAPENABLE_DISABLED)
                ) {
                rc = SNMP_ERR_WRONGVALUE;
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ifLinkUpDownTrapEnable_check_value(rowreq_ctx,
                                                    *((u_long *) var->val.
                                                      string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ifLinkUpDownTrapEnable_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   ifPromiscuousMode));
        if (SNMPERR_SUCCESS == rc) {

            /*
             * check that the value is one of defined enums 
             */
            if (1 && (*var->val.integer != TRUTHVALUE_TRUE)
                && (*var->val.integer != TRUTHVALUE_FALSE)
                ) {
                rc = SNMP_ERR_WRONGVALUE;
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ifPromiscuousMode_check_value(rowreq_ctx,
                                               *((u_long *) var->val.
                                                 string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ifPromiscuousMode_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rc = netsnmp_check_vb_type(var, ASN_OCTET_STR);
        if (SNMPERR_SUCCESS == rc) {
            /*
             * check that the value is in the defined range(s); inefficent
             * * but keeps rc value knowledge in libarary where it belongs. 
             */
            if (1
                && ((rc = netsnmp_check_vb_size_range(var, 0, 64)) !=
                    SNMP_ERR_NOERROR)
                ) {
                ;               /* rc set in condition */
            }
        }
        if (SNMPERR_SUCCESS == rc) {
            rc = ifAlias_check_value(rowreq_ctx, (char *) var->val.string,
                                     var->val_len);
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR, "bad rc %d from ifAlias_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

    default: /** We shouldn't get here */
        rc = SNMP_ERR_GENERR;
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_check_column\n",
                 column);
    }

    return rc;
}                               /* _ifXTable_check_column */

int
_mfd_ifXTable_check_objects(netsnmp_mib_handler *handler,
                            netsnmp_handler_registration *reginfo,
                            netsnmp_agent_request_info *agtreq_info,
                            netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_check_objects",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {

        /*
         * get column number from table request info, and check that column
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_check_column(rowreq_ctx, requests->requestvb,
                                    tri->colnum);
        if (rc) {
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));
            break;
        }

    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_check_objects */



/*----------------------------------------------------------------------
 *
 * SET: check dependencies
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check dependencies wrapper
 */
static int
_mfd_ifXTable_check_dependencies(netsnmp_mib_handler *handler,
                                 netsnmp_handler_registration *reginfo,
                                 netsnmp_agent_request_info *agtreq_info,
                                 netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_check_dependencies",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ifXTable_check_dependencies(rowreq_ctx);
    if (rc) {
        DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                    "ifXTable_check_dependencies\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_check_dependencies */

/*----------------------------------------------------------------------
 *
 * SET: Undo setup
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_undo_setup_column(ifXTable_rowreq_ctx * rowreq_ctx, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_undo_setup_column",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rowreq_ctx->column_set_flags |= FLAG_IFLINKUPDOWNTRAPENABLE;
        rc = ifLinkUpDownTrapEnable_undo_setup(rowreq_ctx);
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rowreq_ctx->column_set_flags |= FLAG_IFPROMISCUOUSMODE;
        rc = ifPromiscuousMode_undo_setup(rowreq_ctx);
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rowreq_ctx->column_set_flags |= FLAG_IFALIAS;
        rc = ifAlias_undo_setup(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ifXTable_undo_setup_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_undo_setup_column */


/**
 * @internal
 * undo setup
 */
int
_mfd_ifXTable_undo_setup(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_setup", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * allocate undo context
     */
    rowreq_ctx->undo = ifXTable_allocate_data();
    if (NULL == rowreq_ctx->undo) {
        /** msg already logged */
        netsnmp_request_set_error_all(requests,
                                      SNMP_ERR_RESOURCEUNAVAILABLE);
        return SNMP_ERR_NOERROR;
    }

    /*
     * row undo setup
     */
    rowreq_ctx->column_set_flags = 0;
    rc = ifXTable_undo_setup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                    "ifXTable_undo_setup\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    } else {
        /*
         * column undo setup
         */
        netsnmp_table_request_info *tri;
        for (; requests; requests = requests->next) {
            /*
             * set column data
             */
            tri = netsnmp_extract_table_info(requests);
            if (NULL == tri)
                continue;

            rc = _ifXTable_undo_setup_column(rowreq_ctx, tri->colnum);
            if (MFD_SUCCESS != rc) {
                DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                            "ifXTable_undo_setup_column\n", rc));
                netsnmp_set_request_error(agtreq_info, requests,
                                          SNMP_VALIDATE_ERR(rc));
            }
        }                       /* for results */
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_undo_setup */

/**
 * @internal
 * undo setup
 */
int
_mfd_ifXTable_undo_cleanup(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *agtreq_info,
                           netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_cleanup",
                "called\n"));

    /*
     * failed row create in early stages has no rowreq_ctx
     */
    if (NULL == rowreq_ctx)
        return MFD_SUCCESS;

    /*
     * call user cleanup
     */
    rc = ifXTable_undo_cleanup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                    "ifXTable_undo_cleanup\n", rc));
    }

    /*
     * release undo context, if needed
     */
    if (rowreq_ctx->undo) {
        ifXTable_release_data(rowreq_ctx->undo);
        rowreq_ctx->undo = NULL;
    }

    /*
     * clear set flags
     */
    rowreq_ctx->column_set_flags = 0;

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_undo_cleanup */

/*----------------------------------------------------------------------
 *
 * SET: Set values
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_set_column(ifXTable_rowreq_ctx * rowreq_ctx,
                     netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_set_column", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        if (var->val_len != sizeof(u_long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(u_long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IFLINKUPDOWNTRAPENABLE;
        rc = ifLinkUpDownTrapEnable_set(rowreq_ctx,
                                        *((u_long *) var->val.string));
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        if (var->val_len != sizeof(u_long)) {
            rc = SNMP_ERR_WRONGLENGTH;
            snmp_log(LOG_ERR,
                     "varbind size of %d does not match expected size %d\n",
                     var->val_len, sizeof(u_long));
            break;
        }
        rowreq_ctx->column_set_flags |= FLAG_IFPROMISCUOUSMODE;
        rc = ifPromiscuousMode_set(rowreq_ctx,
                                   *((u_long *) var->val.string));
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rowreq_ctx->column_set_flags |= FLAG_IFALIAS;
        rc = ifAlias_set(rowreq_ctx, (char *) var->val.string,
                         var->val_len);
        break;

    default:
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_set_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_set_column */

int
_mfd_ifXTable_set_values(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc = SNMP_ERR_NOERROR;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_set_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rowreq_ctx->column_set_flags = 0;
    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_set_column(rowreq_ctx,
                                  requests->requestvb, tri->colnum);
        if (MFD_SUCCESS != rc) {
            DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                        "ifXTable_set_column\n", rc));
            netsnmp_set_request_error(agtreq_info, requests,
                                      SNMP_VALIDATE_ERR(rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_set_values */

/*----------------------------------------------------------------------
 *
 * SET: commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit the values
 */
int
_mfd_ifXTable_commit(netsnmp_mib_handler *handler,
                     netsnmp_handler_registration *reginfo,
                     netsnmp_agent_request_info *agtreq_info,
                     netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_commit", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ifXTable_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                    "ifXTable_commit\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}

int
_mfd_ifXTable_undo_commit(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *agtreq_info,
                          netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ifXTable_undo_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                    "ifXTable_undo_commit\n", rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_commit */

/*----------------------------------------------------------------------
 *
 * SET: Undo
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * undo the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_undo_column(ifXTable_rowreq_ctx * rowreq_ctx,
                      netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_undo_column", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rc = ifLinkUpDownTrapEnable_undo(rowreq_ctx);
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rc = ifPromiscuousMode_undo(rowreq_ctx);
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rc = ifAlias_undo(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_undo_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_undo_column */

int
_mfd_ifXTable_undo_values(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *agtreq_info,
                          netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx =
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_undo_column(rowreq_ctx, requests->requestvb,
                                   tri->colnum);
        if (MFD_SUCCESS != rc) {
            /*
             * nothing we can do about it but log it
             */
            DEBUGMSGTL(("verbose:ifXTable:mfd", "error %d from "
                        "ifXTable_undo_column\n", rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_undo_values */

/***********************************************************************
 *
 * DATA ACCESS
 *
 ***********************************************************************/
/**
 * @internal
 * initialize the iterator container with functions or wrappers
 */
void
_ifXTable_container_init(ifXTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_init", "called\n"));

    /*
     * set up the cache
     *
     * special case: sharing a cache
     */
    if_ctx->cache =
        netsnmp_cache_find_by_oid(ifTable_oid, ifTable_oid_size);
    if (NULL != if_ctx->cache) {
        if_ctx->container = (netsnmp_container *) if_ctx->cache->magic;
        return;
    } else {
        snmp_log(LOG_ERR, "error finding ifTable cache\n");
    }
}

/*
 * allow direct access to container.
 */
netsnmp_container *
_ifXTable_container_get(void)
{
    return ifXTable_if_ctx.container;
}
