/* 
 * KClient 1.9 deprecated API
 *
 * $Header: /cvs/repository/iservers/Libraries/passwordserver_sasl/cyrus_sasl/mac/CommonKClient/mac_kclient3/Headers/KClientCompat/KClientCompat.h,v 1.1 2002/02/28 00:26:47 snsimon Exp $
 */

#ifndef	__KCLIENTCOMPAT__
#define	__KCLIENTCOMPAT__

/* Constants */

/* Error codes, only listing the ones actually returned by the library */
enum {
	cKrbMapDoesntExist			= -1020,	/* tried to access a map that doesn't exist (index too large, or criteria doesn't match anything) */
	cKrbSessDoesntExist			= -1019,	/* tried to access a session that doesn't exist */
	cKrbCredsDontExist			= -1018,	/* tried to access credentials that don't exist */
	cKrbUserCancelled			= -1016,	/* user cancelled a log in operation */
	cKrbConfigurationErr		= -1015,	/* Kerberos Preference file is not configured properly */
	cKrbServerRejected			= -1014,	/* A server rejected our ticket */
	cKrbServerImposter			= -1013,	/* Server appears to be a phoney */
	cKrbServerRespIncomplete	= -1012,	/* Server response is not complete */
	cKrbNotLoggedIn				= -1011,	/* Returned by cKrbGetUserName if user is not logged in */
	cKrbAppInBkgnd				= -1008,	/* driver won't put up password dialog when in background */
	cKrbInvalidSession			= -1007,	/* invalid structure passed to KClient/KServer routine */
		
	cKrbKerberosErrBlock		= -20000	/* start of block of 256 kerberos error numbers */
};

#ifndef rez

#if PRAGMA_ONCE
#pragma once
#endif /* PRAGMA_ONCE */

#include <Kerberos4/Kerberos4.h>
#include <KClient/KClientTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef KClientSession KClientSessionInfo;

enum {
	KClientLoggedIn,
	KClientNotLoggedIn
};

OSErr KClientVersionCompat (
	SInt16*						outMajorVersion,
	SInt16*						outMinorVersion,
	char*						outVersionString);

OSErr KClientNewSessionCompat (
	KClientSessionInfo*			inSession,
	UInt32						inLocalAddress,
	UInt16						inLocalPort,
	UInt32						inRemoteAddress,
	UInt16						inRemotePort);
	
OSErr KClientDisposeSessionCompat (
	KClientSessionInfo*			inSession);
	
OSErr KClientGetTicketForServiceCompat (
	KClientSessionInfo*			inSession,
	char*						inService,
	void*						inBuffer,
	UInt32*						outBufferLength);
	
OSErr KClientGetTicketForServiceWithChecksumCompat (
	KClientSessionInfo*			inSession,
	UInt32						inChecksum,
	char*						inService,
	void*						inBuffer,
	UInt32*						outBufferLength);
	
OSErr KClientLoginCompat (
	KClientSessionInfo*			inSession,
	KClientKey*					outPrivateKey);
	
OSErr KClientPasswordLoginCompat (
	KClientSessionInfo*			inSession,
	char*						inPassword,
	KClientKey*					outPrivateKey);
	
OSErr KClientLogoutCompat (void);

SInt16 KClientStatusCompat (void);

OSErr KClientGetSessionKeyCompat (
	KClientSessionInfo*			inSession,
	KClientKey*					outSessionKey);
	
OSErr KClientEncryptCompat (
	KClientSessionInfo*			inSession,
	void*						inPlainBuffer,
	UInt32						inPlainBufferLength,
	void*						outEncryptedBuffer,
	UInt32*						ioEncryptedBufferLength);
	
OSErr KClientDecryptCompat (
	KClientSessionInfo*			inSession,
	void*						inEncryptedBuffer,
	UInt32						inEncryptedBufferLength,
	UInt32*						outPlainBufferOffset,
	UInt32*						outPlainBufferLength);

OSErr KClientProtectIntegrityCompat (
	KClientSessionInfo*			inSession,
	void*						inPlainBuffer,
	UInt32						inPlainBufferLength,
	void*						outProtectedBuffer,
	UInt32*						ioProtectedBufferLength);

OSErr KClientVerifyIntegrityCompat (
	KClientSessionInfo*			inSession,
	void*						inProtectedBuffer,
	UInt32						inProtectedBufferLength,
	UInt32*						outPlainBufferOffset,
	UInt32*						outPlainBufferLength);

OSErr KServerNewSessionCompat (
	KClientSessionInfo*			inSession,
	char*						inService,
	UInt32						inLocalAddress,
	UInt16						inLocalPort,
	UInt32						inRemoteAddress,
	UInt16						inRemotePort);

OSErr KServerVerifyTicketCompat (
	KClientSessionInfo*			inSession,
	void*						inBuffer,
	char*						inFilename);
	
OSErr KServerGetReplyTicketCompat (
	KClientSessionInfo*			inSession,
	void*						outBuffer,
	UInt32*						ioBufferLength);
	
OSErr KServerAddKeyCompat (
	KClientSessionInfo*			inSession,
	KClientKey*					inPrivateKey,
	char*						inService,
	SInt32						inVersion,
	char*						inFilename);
	
OSErr KServerGetKeyCompat (
	KClientSessionInfo*			inSession,
	KClientKey*					outPrivateKey,
	char*						inService,
	SInt32						inVersion,
	char*						inFilename);

OSErr KServerGetSessionTimeRemainingCompat (
	KClientSessionInfo*			inSession,
	SInt32*						outSeconds);
	
OSErr KClientGetSessionUserNameCompat (
	KClientSessionInfo*			inSession,
	char*						outUserName,
	SInt16						inNameType);

OSErr KClientMakeSendAuthCompat (
	KClientSessionInfo*			inSession,
	char*						inService,
	void*						outBuffer,
	UInt32*						ioBufferLength,
	SInt32						inChecksum,
	char*						inApplicationVersion);
	
OSErr KClientVerifyReplyTicketCompat (
	KClientSessionInfo*			inSession,
	void*						inBuffer,
	UInt32*						ioBufferLength);
	
OSErr KClientVerifyUnencryptedReplyTicketCompat (
	KClientSessionInfo*			inSession,
	void*						inBuffer,
	UInt32*						ioBufferLength);

#ifdef __cplusplus
}
#endif

#endif /* !rez */

#endif /* __KCLIENTCOMPAT__ */