/*
 *      Copyright (c) 1996-1999 Malcolm Beattie
 *
 *      You may distribute under the terms of either the GNU General Public
 *      License or the Artistic License, as specified in the README file.
 *
 */
/*
 * This file is autogenerated from bytecode.pl. Changes made here will be lost.
 */

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#define NO_XSLOCKS
#include "XSUB.h"

#include "byterun.h"
#include "bytecode.h"


static const int optype_size[] = {
    sizeof(OP),
    sizeof(UNOP),
    sizeof(BINOP),
    sizeof(LOGOP),
    sizeof(LISTOP),
    sizeof(PMOP),
    sizeof(SVOP),
    sizeof(PADOP),
    sizeof(PVOP),
    sizeof(LOOP),
    sizeof(COP)
};

void *
bset_obj_store(pTHX_ struct byteloader_state *bstate, void *obj, I32 ix)
{
    if (ix > bstate->bs_obj_list_fill) {
	Renew(bstate->bs_obj_list, ix + 32, void*);
	bstate->bs_obj_list_fill = ix + 31;
    }
    bstate->bs_obj_list[ix] = obj;
    return obj;
}

void
byterun(pTHX_ register struct byteloader_state *bstate)
{
    register int insn;
    U32 ix;
    SV *specialsv_list[6];

    BYTECODE_HEADER_CHECK;	/* croak if incorrect platform */
    New(666, bstate->bs_obj_list, 32, void*); /* set op objlist */
    bstate->bs_obj_list_fill = 31;

    specialsv_list[0] = Nullsv;
    specialsv_list[1] = &PL_sv_undef;
    specialsv_list[2] = &PL_sv_yes;
    specialsv_list[3] = &PL_sv_no;
    specialsv_list[4] = pWARN_ALL;
    specialsv_list[5] = pWARN_NONE;

    while ((insn = BGET_FGETC()) != EOF) {
	switch (insn) {
	  case INSN_COMMENT:		/* 35 */
	    {
		comment_t arg;
		BGET_comment_t(arg);
		arg = arg;
		break;
	    }
	  case INSN_NOP:		/* 10 */
	    {
		break;
	    }
	  case INSN_RET:		/* 0 */
	    {
		BSET_ret(none);
		break;
	    }
	  case INSN_LDSV:		/* 1 */
	    {
		svindex arg;
		BGET_svindex(arg);
		bstate->bs_sv = arg;
		break;
	    }
	  case INSN_LDOP:		/* 2 */
	    {
		opindex arg;
		BGET_opindex(arg);
		PL_op = arg;
		break;
	    }
	  case INSN_STSV:		/* 3 */
	    {
		U32 arg;
		BGET_U32(arg);
		BSET_OBJ_STORE(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_STOP:		/* 4 */
	    {
		U32 arg;
		BGET_U32(arg);
		BSET_OBJ_STORE(PL_op, arg);
		break;
	    }
	  case INSN_STPV:		/* 5 */
	    {
		U32 arg;
		BGET_U32(arg);
		BSET_stpv(bstate->bs_pv.xpv_pv, arg);
		break;
	    }
	  case INSN_LDSPECSV:		/* 6 */
	    {
		U8 arg;
		BGET_U8(arg);
		BSET_ldspecsv(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_NEWSV:		/* 7 */
	    {
		U8 arg;
		BGET_U8(arg);
		BSET_newsv(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_NEWOP:		/* 8 */
	    {
		U8 arg;
		BGET_U8(arg);
		BSET_newop(PL_op, arg);
		break;
	    }
	  case INSN_NEWOPN:		/* 9 */
	    {
		U8 arg;
		BGET_U8(arg);
		BSET_newopn(PL_op, arg);
		break;
	    }
	  case INSN_NEWPV:		/* 11 */
	    {
		PV arg;
		BGET_PV(arg);
		break;
	    }
	  case INSN_PV_CUR:		/* 12 */
	    {
		STRLEN arg;
		BGET_U32(arg);
		bstate->bs_pv.xpv_cur = arg;
		break;
	    }
	  case INSN_PV_FREE:		/* 13 */
	    {
		BSET_pv_free(bstate->bs_pv);
		break;
	    }
	  case INSN_SV_UPGRADE:		/* 14 */
	    {
		U8 arg;
		BGET_U8(arg);
		BSET_sv_upgrade(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_SV_REFCNT:		/* 15 */
	    {
		U32 arg;
		BGET_U32(arg);
		SvREFCNT(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_SV_REFCNT_ADD:		/* 16 */
	    {
		I32 arg;
		BGET_I32(arg);
		BSET_sv_refcnt_add(SvREFCNT(bstate->bs_sv), arg);
		break;
	    }
	  case INSN_SV_FLAGS:		/* 17 */
	    {
		U32 arg;
		BGET_U32(arg);
		SvFLAGS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XRV:		/* 18 */
	    {
		svindex arg;
		BGET_svindex(arg);
		SvRV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XPV:		/* 19 */
	    {
		BSET_xpv(bstate->bs_sv);
		break;
	    }
	  case INSN_XIV32:		/* 20 */
	    {
		I32 arg;
		BGET_I32(arg);
		SvIVX(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIV64:		/* 21 */
	    {
		IV64 arg;
		BGET_IV64(arg);
		SvIVX(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XNV:		/* 22 */
	    {
		NV arg;
		BGET_NV(arg);
		SvNVX(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XLV_TARGOFF:		/* 23 */
	    {
		STRLEN arg;
		BGET_U32(arg);
		LvTARGOFF(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XLV_TARGLEN:		/* 24 */
	    {
		STRLEN arg;
		BGET_U32(arg);
		LvTARGLEN(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XLV_TARG:		/* 25 */
	    {
		svindex arg;
		BGET_svindex(arg);
		LvTARG(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XLV_TYPE:		/* 26 */
	    {
		char arg;
		BGET_U8(arg);
		LvTYPE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XBM_USEFUL:		/* 27 */
	    {
		I32 arg;
		BGET_I32(arg);
		BmUSEFUL(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XBM_PREVIOUS:		/* 28 */
	    {
		U16 arg;
		BGET_U16(arg);
		BmPREVIOUS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XBM_RARE:		/* 29 */
	    {
		U8 arg;
		BGET_U8(arg);
		BmRARE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XFM_LINES:		/* 30 */
	    {
		IV arg;
		BGET_IV(arg);
		FmLINES(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_LINES:		/* 31 */
	    {
		IV arg;
		BGET_IV(arg);
		IoLINES(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_PAGE:		/* 32 */
	    {
		IV arg;
		BGET_IV(arg);
		IoPAGE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_PAGE_LEN:		/* 33 */
	    {
		IV arg;
		BGET_IV(arg);
		IoPAGE_LEN(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_LINES_LEFT:		/* 34 */
	    {
		IV arg;
		BGET_IV(arg);
		IoLINES_LEFT(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_TOP_NAME:		/* 36 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		IoTOP_NAME(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_TOP_GV:		/* 37 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&IoTOP_GV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_FMT_NAME:		/* 38 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		IoFMT_NAME(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_FMT_GV:		/* 39 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&IoFMT_GV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_BOTTOM_NAME:		/* 40 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		IoBOTTOM_NAME(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_BOTTOM_GV:		/* 41 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&IoBOTTOM_GV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_SUBPROCESS:		/* 42 */
	    {
		short arg;
		BGET_U16(arg);
		IoSUBPROCESS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_TYPE:		/* 43 */
	    {
		char arg;
		BGET_U8(arg);
		IoTYPE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XIO_FLAGS:		/* 44 */
	    {
		char arg;
		BGET_U8(arg);
		IoFLAGS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_STASH:		/* 45 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&CvSTASH(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_START:		/* 46 */
	    {
		opindex arg;
		BGET_opindex(arg);
		CvSTART(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_ROOT:		/* 47 */
	    {
		opindex arg;
		BGET_opindex(arg);
		CvROOT(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_GV:		/* 48 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&CvGV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_FILE:		/* 49 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		CvFILE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_DEPTH:		/* 50 */
	    {
		long arg;
		BGET_I32(arg);
		CvDEPTH(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_PADLIST:		/* 51 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&CvPADLIST(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_OUTSIDE:		/* 52 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&CvOUTSIDE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_OUTSIDE_SEQ:		/* 53 */
	    {
		U32 arg;
		BGET_U32(arg);
		CvOUTSIDE_SEQ(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XCV_FLAGS:		/* 54 */
	    {
		U16 arg;
		BGET_U16(arg);
		CvFLAGS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_AV_EXTEND:		/* 55 */
	    {
		SSize_t arg;
		BGET_I32(arg);
		BSET_av_extend(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_AV_PUSH:		/* 56 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_av_push(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_XAV_FILL:		/* 57 */
	    {
		SSize_t arg;
		BGET_I32(arg);
		AvFILLp(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XAV_MAX:		/* 58 */
	    {
		SSize_t arg;
		BGET_I32(arg);
		AvMAX(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XAV_FLAGS:		/* 59 */
	    {
		U8 arg;
		BGET_U8(arg);
		AvFLAGS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XHV_RITER:		/* 60 */
	    {
		I32 arg;
		BGET_I32(arg);
		HvRITER(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_XHV_NAME:		/* 61 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		HvNAME(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_HV_STORE:		/* 62 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_hv_store(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_SV_MAGIC:		/* 63 */
	    {
		char arg;
		BGET_U8(arg);
		BSET_sv_magic(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_MG_OBJ:		/* 64 */
	    {
		svindex arg;
		BGET_svindex(arg);
		SvMAGIC(bstate->bs_sv)->mg_obj = arg;
		break;
	    }
	  case INSN_MG_PRIVATE:		/* 65 */
	    {
		U16 arg;
		BGET_U16(arg);
		SvMAGIC(bstate->bs_sv)->mg_private = arg;
		break;
	    }
	  case INSN_MG_FLAGS:		/* 66 */
	    {
		U8 arg;
		BGET_U8(arg);
		SvMAGIC(bstate->bs_sv)->mg_flags = arg;
		break;
	    }
	  case INSN_MG_PV:		/* 67 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		BSET_mg_pv(SvMAGIC(bstate->bs_sv), arg);
		break;
	    }
	  case INSN_XMG_STASH:		/* 68 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&SvSTASH(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GV_FETCHPV:		/* 69 */
	    {
		strconst arg;
		BGET_strconst(arg);
		BSET_gv_fetchpv(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_GV_STASHPV:		/* 70 */
	    {
		strconst arg;
		BGET_strconst(arg);
		BSET_gv_stashpv(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_GP_SV:		/* 71 */
	    {
		svindex arg;
		BGET_svindex(arg);
		GvSV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_REFCNT:		/* 72 */
	    {
		U32 arg;
		BGET_U32(arg);
		GvREFCNT(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_REFCNT_ADD:		/* 73 */
	    {
		I32 arg;
		BGET_I32(arg);
		BSET_gp_refcnt_add(GvREFCNT(bstate->bs_sv), arg);
		break;
	    }
	  case INSN_GP_AV:		/* 74 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&GvAV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_HV:		/* 75 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&GvHV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_CV:		/* 76 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&GvCV(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_FILE:		/* 77 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		GvFILE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_IO:		/* 78 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&GvIOp(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_FORM:		/* 79 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&GvFORM(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_CVGEN:		/* 80 */
	    {
		U32 arg;
		BGET_U32(arg);
		GvCVGEN(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_LINE:		/* 81 */
	    {
		line_t arg;
		BGET_U16(arg);
		GvLINE(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_GP_SHARE:		/* 82 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_gp_share(bstate->bs_sv, arg);
		break;
	    }
	  case INSN_XGV_FLAGS:		/* 83 */
	    {
		U8 arg;
		BGET_U8(arg);
		GvFLAGS(bstate->bs_sv) = arg;
		break;
	    }
	  case INSN_OP_NEXT:		/* 84 */
	    {
		opindex arg;
		BGET_opindex(arg);
		PL_op->op_next = arg;
		break;
	    }
	  case INSN_OP_SIBLING:		/* 85 */
	    {
		opindex arg;
		BGET_opindex(arg);
		PL_op->op_sibling = arg;
		break;
	    }
	  case INSN_OP_PPADDR:		/* 86 */
	    {
		strconst arg;
		BGET_strconst(arg);
		BSET_op_ppaddr(PL_op->op_ppaddr, arg);
		break;
	    }
	  case INSN_OP_TARG:		/* 87 */
	    {
		PADOFFSET arg;
		BGET_U32(arg);
		PL_op->op_targ = arg;
		break;
	    }
	  case INSN_OP_TYPE:		/* 88 */
	    {
		OPCODE arg;
		BGET_U16(arg);
		BSET_op_type(PL_op, arg);
		break;
	    }
	  case INSN_OP_SEQ:		/* 89 */
	    {
		U16 arg;
		BGET_U16(arg);
		PL_op->op_seq = arg;
		break;
	    }
	  case INSN_OP_FLAGS:		/* 90 */
	    {
		U8 arg;
		BGET_U8(arg);
		PL_op->op_flags = arg;
		break;
	    }
	  case INSN_OP_PRIVATE:		/* 91 */
	    {
		U8 arg;
		BGET_U8(arg);
		PL_op->op_private = arg;
		break;
	    }
	  case INSN_OP_FIRST:		/* 92 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cUNOP->op_first = arg;
		break;
	    }
	  case INSN_OP_LAST:		/* 93 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cBINOP->op_last = arg;
		break;
	    }
	  case INSN_OP_OTHER:		/* 94 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cLOGOP->op_other = arg;
		break;
	    }
	  case INSN_OP_PMREPLROOT:		/* 95 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cPMOP->op_pmreplroot = arg;
		break;
	    }
	  case INSN_OP_PMREPLROOTGV:		/* 96 */
	    {
		svindex arg;
		BGET_svindex(arg);
		*(SV**)&cPMOP->op_pmreplroot = arg;
		break;
	    }
	  case INSN_OP_PMREPLSTART:		/* 97 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cPMOP->op_pmreplstart = arg;
		break;
	    }
	  case INSN_OP_PMNEXT:		/* 98 */
	    {
		opindex arg;
		BGET_opindex(arg);
		*(OP**)&cPMOP->op_pmnext = arg;
		break;
	    }
	  case INSN_PREGCOMP:		/* 99 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		BSET_pregcomp(PL_op, arg);
		break;
	    }
	  case INSN_OP_PMFLAGS:		/* 100 */
	    {
		U16 arg;
		BGET_U16(arg);
		cPMOP->op_pmflags = arg;
		break;
	    }
	  case INSN_OP_PMPERMFLAGS:		/* 101 */
	    {
		U16 arg;
		BGET_U16(arg);
		cPMOP->op_pmpermflags = arg;
		break;
	    }
	  case INSN_OP_SV:		/* 102 */
	    {
		svindex arg;
		BGET_svindex(arg);
		cSVOP->op_sv = arg;
		break;
	    }
	  case INSN_OP_PADIX:		/* 103 */
	    {
		PADOFFSET arg;
		BGET_U32(arg);
		cPADOP->op_padix = arg;
		break;
	    }
	  case INSN_OP_PV:		/* 104 */
	    {
		pvcontents arg;
		BGET_pvcontents(arg);
		cPVOP->op_pv = arg;
		break;
	    }
	  case INSN_OP_PV_TR:		/* 105 */
	    {
		op_tr_array arg;
		BGET_op_tr_array(arg);
		cPVOP->op_pv = arg;
		break;
	    }
	  case INSN_OP_REDOOP:		/* 106 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cLOOP->op_redoop = arg;
		break;
	    }
	  case INSN_OP_NEXTOP:		/* 107 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cLOOP->op_nextop = arg;
		break;
	    }
	  case INSN_OP_LASTOP:		/* 108 */
	    {
		opindex arg;
		BGET_opindex(arg);
		cLOOP->op_lastop = arg;
		break;
	    }
	  case INSN_COP_LABEL:		/* 109 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		cCOP->cop_label = arg;
		break;
	    }
	  case INSN_COP_STASHPV:		/* 110 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		BSET_cop_stashpv(cCOP, arg);
		break;
	    }
	  case INSN_COP_FILE:		/* 111 */
	    {
		pvindex arg;
		BGET_pvindex(arg);
		BSET_cop_file(cCOP, arg);
		break;
	    }
	  case INSN_COP_SEQ:		/* 112 */
	    {
		U32 arg;
		BGET_U32(arg);
		cCOP->cop_seq = arg;
		break;
	    }
	  case INSN_COP_ARYBASE:		/* 113 */
	    {
		I32 arg;
		BGET_I32(arg);
		cCOP->cop_arybase = arg;
		break;
	    }
	  case INSN_COP_LINE:		/* 114 */
	    {
		line_t arg;
		BGET_U16(arg);
		BSET_cop_line(cCOP, arg);
		break;
	    }
	  case INSN_COP_WARNINGS:		/* 115 */
	    {
		svindex arg;
		BGET_svindex(arg);
		cCOP->cop_warnings = arg;
		break;
	    }
	  case INSN_MAIN_START:		/* 116 */
	    {
		opindex arg;
		BGET_opindex(arg);
		PL_main_start = arg;
		break;
	    }
	  case INSN_MAIN_ROOT:		/* 117 */
	    {
		opindex arg;
		BGET_opindex(arg);
		PL_main_root = arg;
		break;
	    }
	  case INSN_CURPAD:		/* 118 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_curpad(PL_curpad, arg);
		break;
	    }
	  case INSN_PUSH_BEGIN:		/* 119 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_push_begin(PL_beginav, arg);
		break;
	    }
	  case INSN_PUSH_INIT:		/* 120 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_push_init(PL_initav, arg);
		break;
	    }
	  case INSN_PUSH_END:		/* 121 */
	    {
		svindex arg;
		BGET_svindex(arg);
		BSET_push_end(PL_endav, arg);
		break;
	    }
	  default:
	    Perl_croak(aTHX_ "Illegal bytecode instruction %d\n", insn);
	    /* NOTREACHED */
	}
    }
}
