'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: return.n,v 1.1.1.4 2003/03/06 00:09:37 landonf Exp $
'\" 
.so man.macros
.TH return n 7.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
return \- Return from a procedure
.SH SYNOPSIS
\fBreturn \fR?\fB\-code \fIcode\fR? ?\fB\-errorinfo \fIinfo\fR? ?\fB\-errorcode\fI code\fR? ?\fIstring\fR?
.BE

.SH DESCRIPTION
.PP
Return immediately from the current procedure
(or top-level command or \fBsource\fR command),
with \fIstring\fR as the return value.  If \fIstring\fR is not specified then
an empty string will be returned as result.

.SH "EXCEPTIONAL RETURNS"
.PP
In the usual case where the \fB\-code\fR option isn't
specified the procedure will return normally (its completion
code will be TCL_OK).
However, the \fB\-code\fR option may be used to generate an
exceptional return from the procedure.
\fICode\fR may have any of the following values:
.TP 10
\fBok\fR
Normal return:  same as if the option is omitted.
.TP 10
\fBerror\fR
Error return: same as if the \fBerror\fR command were used to
terminate the procedure, except for handling of \fBerrorInfo\fR
and \fBerrorCode\fR variables (see below).
.TP 10
\fBreturn\fR
The current procedure will return with a completion code of
TCL_RETURN, so that the procedure that invoked it will return
also.
.TP 10
\fBbreak\fR
The current procedure will return with a completion code of
TCL_BREAK, which will terminate the innermost nested loop in
the code that invoked the current procedure.
.TP 10
\fBcontinue\fR
The current procedure will return with a completion code of
TCL_CONTINUE, which will terminate the current iteration of
the innermost nested loop in the code that invoked the current
procedure.
.TP 10
\fIvalue\fR
\fIValue\fR must be an integer;  it will be returned as the
completion code for the current procedure.
.LP
The \fB\-code\fR option is rarely used.
It is provided so that procedures that implement
new control structures can reflect exceptional conditions back to
their callers.
.PP
Two additional options, \fB\-errorinfo\fR and \fB\-errorcode\fR,
may be used to provide additional information during error
returns.
These options are ignored unless \fIcode\fR is \fBerror\fR.
.PP
The \fB\-errorinfo\fR option specifies an initial stack
trace for the \fBerrorInfo\fR variable;  if it is not specified then
the stack trace left in \fBerrorInfo\fR will include the call to
the procedure and higher levels on the stack but it will not include
any information about the context of the error within the procedure.
Typically the \fIinfo\fR value is supplied from the value left
in \fBerrorInfo\fR after a \fBcatch\fR command trapped an error within
the procedure.
.PP
If the \fB\-errorcode\fR option is specified then \fIcode\fR provides
a value for the \fBerrorCode\fR variable.
If the option is not specified then \fBerrorCode\fR will
default to \fBNONE\fR.

.SH "SEE ALSO"
break(n), continue(n), error(n), proc(n)

.SH KEYWORDS
break, continue, error, procedure, return
