'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2001 Donal K. Fellows
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: subst.n,v 1.1.1.4 2003/03/06 00:09:41 landonf Exp $
'\" 
.so man.macros
.TH subst n 7.4 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
subst \- Perform backslash, command, and variable substitutions
.SH SYNOPSIS
\fBsubst \fR?\fB\-nobackslashes\fR? ?\fB\-nocommands\fR? ?\fB\-novariables\fR? \fIstring\fR
.BE

.SH DESCRIPTION
.PP
This command performs variable substitutions, command substitutions,
and backslash substitutions on its \fIstring\fR argument and
returns the fully-substituted result.
The substitutions are performed in exactly the same way as for
Tcl commands.
As a result, the \fIstring\fR argument is actually substituted twice,
once by the Tcl parser in the usual fashion for Tcl commands, and
again by the \fIsubst\fR command.
.PP
If any of the \fB\-nobackslashes\fR, \fB\-nocommands\fR, or
\fB\-novariables\fR are specified, then the corresponding substitutions
are not performed.
For example, if \fB\-nocommands\fR is specified, command substitution
is not performed:  open and close brackets are treated as ordinary characters
with no special interpretation.
.PP
.VS 8.4
Note that the substitution of one kind can include substitution of 
other kinds.  For example, even when the \fB-novariables\fR option
is specified, command substitution is performed without restriction.
This means that any variable substitution necessary to complete the
command substitution will still take place.  Likewise, any command
substitution necessary to complete a variable substitution will
take place, even when \fB-nocommands\fR is specified.  See the
EXAMPLES below.
.PP
If an error occurs during substitution, then \fBsubst\fR will return
that error.  If a break exception occurs during command or variable
substitution, the result of the whole substitution will be the
string (as substituted) up to the start of the substitution that
raised the exception.  If a continue exception occurs during the
evaluation of a command or variable substitution, an empty string
will be substituted for that entire command or variable substitution
(as long as it is well-formed Tcl.)  If a return exception occurs,
or any other return code is returned during command or variable
substitution, then the returned value is substituted for that
substitution.  See the EXAMPLES below.  In this way, all exceptional
return codes are ``caught'' by \fBsubst\fR.  The \fBsubst\fR command
itself will either return an error, or will complete successfully.
.VE
.SH EXAMPLES
.PP
When it performs its substitutions, \fIsubst\fR does not give any
special treatment to double quotes or curly braces (except within
command substitutions) so the script
.CS
\fBset a 44
subst {xyz {$a}}\fR
.CE
returns ``\fBxyz {44}\fR'', not ``\fBxyz {$a}\fR''
.VS 8.4
and the script
.CS
\fBset a "p\\} q \\{r"
subst {xyz {$a}}\fR
.CE
return ``\fBxyz {p} q {r}\fR'', not ``\fBxyz {p\\} q \\{r}\fR''.
.PP
When command substitution is performed, it includes any variable
substitution necessary to evaluate the script.  
.CS
\fBset a 44
subst -novariables {$a [format $a]}\fR
.CE
returns ``\fB$a 44\fR'', not ``\fB$a $a\fR''.  Similarly, when
variable substitution is performed, it includes any command
substitution necessary to retrieve the value of the variable.
.CS
\fBproc b {} {return c}
array set a {c c [b] tricky}
subst -nocommands {[b] $a([b])}\fR
.CE
returns ``\fB[b] c\fR'', not ``\fB[b] tricky\fR''.
.PP
The continue and break exceptions allow command substitutions to
prevent substitution of the rest of the command substitution and the
rest of \fIstring\fR respectively, giving script authors more options
when processing text using \fIsubst\fR.  For example, the script
.CS
\fBsubst {abc,[break],def}\fR
.CE
returns ``\fBabc,\fR'', not ``\fBabc,,def\fR'' and the script
.CS
\fBsubst {abc,[continue;expr 1+2],def}\fR
.CE
returns ``\fBabc,,def\fR'', not ``\fBabc,3,def\fR''.
.PP
Other exceptional return codes substitute the returned value
.CS
\fBsubst {abc,[return foo;expr 1+2],def}\fR
.CE
returns ``\fBabc,foo,def\fR'', not ``\fBabc,3,def\fR'' and
.CS
\fBsubst {abc,[return -code 10 foo;expr 1+2],def}\fR
.CE
also returns ``\fBabc,foo,def\fR'', not ``\fBabc,3,def\fR''.
.VE

.SH "SEE ALSO"
Tcl(n), eval(n), break(n), continue(n)

.SH KEYWORDS
backslash substitution, command substitution, variable substitution
