/*
 * TclAE.r --
 *
 *	This file creates resources used by the TclAE package.
 *
 * Copyright (c) 2000 Jonathan E. Guyer
 * Copyright (c) 1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include <Types.r>
#include <SysTypes.r>

#include "tclAEid.h"

#define TCLAE_LIBRARY_RESOURCES 5000

// TclAE version
// The appropriate resources are created automatically, below.
// Just set the values in tclAEid.h appropriately

// Construct a version string
// 	Final (release) versions don't get stage or pre-release code
//	Include patch level only if non-zero
#if	(TCLAE_STAGE == finalStage)
#	if	TCLAE_PATCH != 0
#		define	TCLAE_VERSION_STRING	\
			$$Format("%d.%d.%d", TCLAE_MAJOR, TCLAE_MINOR, TCLAE_PATCH)
#	else
#		define	TCLAE_VERSION_STRING	\
			$$Format("%d.%d", TCLAE_MAJOR, TCLAE_MINOR)
#	endif
#else
#	if	(TCLAE_STAGE == developStage)
#		define	TCLAE_STAGE_CODE	'd'
#	elif	(TCLAE_STAGE == alphaStage)
#		define	TCLAE_STAGE_CODE	'a'
#	elif	(TCLAE_STAGE == betaStage)
#	 	define	TCLAE_STAGE_CODE	'b'
#	endif
#	if	TCLAE_PATCH != 0
#		define	TCLAE_VERSION_STRING	\
			$$Format("%d.%d.%d%c%d", TCLAE_MAJOR, TCLAE_MINOR, TCLAE_PATCH, \
						TCLAE_STAGE_CODE, TCLAE_PRERELEASE)
#	else
#		define	TCLAE_VERSION_STRING	\
			$$Format("%d.%d%c%d", TCLAE_MAJOR, TCLAE_MINOR, \
						TCLAE_STAGE_CODE, TCLAE_PRERELEASE)
#	endif
#endif

#define	TCLAE_MAJOR_BCD	((TCLAE_MAJOR / 10) * 16) + (TCLAE_MAJOR % 10)
#define	TCLAE_MINOR_BCD	(TCLAE_MINOR * 16) + TCLAE_PATCH

resource 'vers' (1) {
	TCLAE_MAJOR_BCD, TCLAE_MINOR_BCD, TCLAE_STAGE, TCLAE_PRERELEASE,
	verUS, TCLAE_VERSION_STRING,	
	$$Format("%s %s  1990-%d\nby Jonathan E. Guyer, Daniel A. Steffen, Peter J. Keleher & Tim Endres ", 
					"Tcl", TCLAE_VERSION_STRING, $$YEAR)
};

resource 'vers' (2) {
	TCLAE_MAJOR_BCD, TCLAE_MINOR_BCD, TCLAE_STAGE, TCLAE_PRERELEASE,
	verUS, TCLAE_VERSION_STRING,	
	$$Format("%s %s  1990%d", "Tcl", TCLAE_VERSION_STRING, $$YEAR)
};

/*
 * The -16397 string will be displayed by Finder when a user
 * tries to open the shared library. The string should
 * give the user a little detail about the library's capabilities
 * and enough information to install the library in the correct location.  
 * A similar string should be placed in all shared libraries.
 */
resource 'STR ' (-16397, purgeable) {
	"Tcl Library\n\n"
	"This library provides the ability to use the AppleEvent "
	"Manager from Tcl/Tk programs.  To work properly, it "
	"should be placed in one of the $tcl_library paths, such as "
	"in the :Tool Command Language: folder "
	"within the :Extensions: folder."
};


/* 
 * We now load the TclAE library into the resource fork of the library.
 * There is no define for CFM68K in CodeWarrior (so far as I can tell)
 * so you will have to change this by hand if you have different names
 * for the CFM & PPC versions of the library.
 */

data 'TEXT' (4000, "pkgIndex", purgeable, preload) {
	"# TclAE package index file, version " TCLAE_VERSION "\n"
	"package ifneeded " TCLAE_NAME " " TCLAE_BASIC_VERSION 
	" \"load [list [file join $dir " TCLAE_FILENAME "[info sharedlibextension]]] " TCLAE_NAME "\n" /* das 25/10/00: Carbonization */
	"source -rsrc tclAE_aeteIndex\""
};

read 'TEXT' (TCLAE_LIBRARY_RESOURCES    , "aelegacy.tcl", purgeable)  ":Tcl:aelegacy.tcl";
read 'TEXT' (TCLAE_LIBRARY_RESOURCES + 1, "aebuild.tcl", purgeable) ":Tcl:aebuild.tcl";
read 'TEXT' (TCLAE_LIBRARY_RESOURCES + 2, "oserrors.tcl", purgeable)    ":Tcl:oserrors.tcl";
read 'TEXT' (TCLAE_LIBRARY_RESOURCES + 3, "aete.tcl", purgeable)    ":Tcl:aete.tcl";

read 'TEXT' (TCLAE_LIBRARY_RESOURCES + 1000, "tclAE_aeteIndex", purgeable) ":Tcl:tclIndex";
