[comment {-*- tcl -*- doctools}]
[manpage_begin memchan n 2.1]
[moddesc   {Memory channels}]
[titledesc {Create and manipulate memory channels}]
[copyright {1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[require Tcl]
[require memchan]
[description]

This manpage documents both the overall package and the command
[cmd memchan]. The package itself provides a number of in-memory
channels which can utilized to

[list_begin bullet]

	[bullet]
	capture stream-like information in a natural way instead of using
	[cmd set] and [cmd append] to manipulate strings

	[bullet]
	or to transfer data between interpreters, in the same thread or not.

[list_end]

[section COMMAND]
[para]
[list_begin definitions]

[call [cmd memchan] [opt "-initial-size [arg len]"]]

creates a chunk-oriented in-memory channel and returns its handle. If
an initial size is specified the system will pre-allocate [arg len]
bytes of buffer space for the contents. This is no restriction on the
ultimate size of the channel, it will always grow as much as is
necessary to accomodate the data written into it.
[nl]
The channels created here can be transfered between interpreters in
the same thread and between threads, but only as a whole. It is not
possible to use them to create a bi- or unidirectional connection
between two interpreters.

[list_end]
[para]
Memory channels created by [cmd memchan] provide two read-only options
which can be queried via the standard [cmd fconfigure] command. These
are

[list_begin definitions]
	[lst_item -length]

	The value of this option is the number of bytes currently
	stored in the queried memory channel.

	[lst_item -allocated]
	The value of this option is the number of bytes currently
	allocated by the queried memory channel. This number is at
	least as big as the value of [strong -length].
	
[list_end]
[para]
As the channels generated by [cmd memchan] grow as necessary they are
always writable. This means that a writable [cmd fileevent]-handler
will fire continuously.

[para]
The channels are also readable if they contain more than zero bytes
and the seek location is not and the end of the channel. Under these
conditions a readable [cmd fileevent]-handler will fire continuously.

[para]
Note that writing to such a channel usually occurs at the end, thus
supressing readable events. This also means that users have to take
care to [cmd seek] the channel to a location before the end before
trying to read data back.

[see_also fifo fifo2 null]
[keywords memchan chunk {in-memory channel} channel i/o]
[manpage_end]
