/* 
 * tclMatherr.c --
 *
 *	This function provides a default implementation of the
 *	"matherr" function, for SYS-V systems where it's needed.
 *
 * Copyright (c) 1993-1994 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclMtherr.c,v 1.2 2000/12/08 03:55:05 wsanchez Exp $
 */

#include "tclInt.h"
#include <math.h>

#ifndef TCL_GENERIC_ONLY
#include "tclPort.h"
#else
#define NO_ERRNO_H
#endif

#ifdef NO_ERRNO_H
extern int errno;			/* Use errno from tclExecute.c. */
#define EDOM 33
#define ERANGE 34
#endif

/*
 * The following definitions allow matherr to compile on systems
 * that don't really support it.  The compiled procedure is bogus,
 * but it will never be executed on these systems anyway.
 */

#ifndef NEED_MATHERR
struct exception {
    int type;
};
#define DOMAIN 0
#define SING 0
#endif

/*
 *----------------------------------------------------------------------
 *
 * matherr --
 *
 *	This procedure is invoked on Sys-V systems when certain
 *	errors occur in mathematical functions.  Type "man matherr"
 *	for more information on how this function works.
 *
 * Results:
 *	Returns 1 to indicate that we've handled the error
 *	locally.
 *
 * Side effects:
 *	Sets errno based on what's in xPtr.
 *
 *----------------------------------------------------------------------
 */

#ifdef __APPLE_CC__
__private_extern__
#endif
int
matherr(xPtr)
    struct exception *xPtr;	/* Describes error that occurred. */
{
    if (TclMathInProgress()) {
	return 0;
    }
    if ((xPtr->type == DOMAIN) || (xPtr->type == SING)) {
	errno = EDOM;
    } else {
	errno = ERANGE;
    }
    return 1;
}
