'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 1999 Scriptics Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: lsort.n,v 1.1.1.4 2002/04/05 16:13:02 jevans Exp $
'\" 
.so man.macros
.TH lsort n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lsort \- Sort the elements of a list
.SH SYNOPSIS
\fBlsort \fR?\fIoptions\fR? \fIlist\fR
.BE

.SH DESCRIPTION
.PP
This command sorts the elements of \fIlist\fR, returning a new
list in sorted order.  The implementation of the \fBlsort\fR command
uses the merge\-sort algorithm which is a stable sort that has O(n log
n) performance characteristics.
.PP
By default ASCII sorting is used with the result returned in
increasing order.  However, any of the following options may be
specified before \fIlist\fR to control the sorting process (unique
abbreviations are accepted):
.TP 20
\fB\-ascii\fR
Use string comparison with ASCII collation order.  This is the default.
.TP 20
\fB\-dictionary\fR
Use dictionary-style comparison.  This is the same as \fB\-ascii\fR
except (a) case is ignored except as a tie-breaker and (b) if two
strings contain embedded numbers, the numbers compare as integers,
not characters.  For example, in \fB\-dictionary\fR mode, \fBbigBoy\fR
sorts between \fBbigbang\fR and \fBbigboy\fR, and \fBx10y\fR
sorts between \fBx9y\fR and \fBx11y\fR.
.TP 20
\fB\-integer\fR
Convert list elements to integers and use integer comparison.
.TP 20
\fB\-real\fR
Convert list elements to floating-point values and use floating comparison.
.TP 20
\fB\-command\0\fIcommand\fR
Use \fIcommand\fR as a comparison command.
To compare two elements, evaluate a Tcl script consisting of
\fIcommand\fR with the two elements appended as additional
arguments.  The script should return an integer less than,
equal to, or greater than zero if the first element is to
be considered less than, equal to, or greater than the second,
respectively.
.TP 20
\fB\-increasing\fR
Sort the list in increasing order (``smallest'' items first).
This is the default.
.TP 20
\fB\-decreasing\fR
Sort the list in decreasing order (``largest'' items first).
.TP 20
\fB\-index\0\fIindex\fR
If this option is specified, each of the elements of \fIlist\fR must
itself be a proper Tcl sublist.  Instead of sorting based on whole
sublists, \fBlsort\fR will extract the \fIindex\fR'th element from
each sublist and sort based on the given element.  The keyword
\fBend\fP is allowed for the \fIindex\fP to sort on the last sublist
element,
.VS 8.3.4
and \fBend-\fIindex\fR sorts on a sublist element offset from
the end.
.VE
For example,
.RS
.CS
lsort -integer -index 1 {{First 24} {Second 18} {Third 30}}
.CE
returns \fB{Second 18} {First 24} {Third 30}\fR, and
.VS 8.3.4
'\"
'\" This example is from the test suite!
'\"
.CS
lsort -index end-1 {{a 1 e i} {b 2 3 f g} {c 4 5 6 d h}}
.CE
returns \fB{c 4 5 6 d h} {a 1 e i} {b 2 3 f g}\fR.
.VE
This option is much more efficient than using \fB\-command\fR
to achieve the same effect.
.RE
.TP 20
\fB\-unique\fR
If this option is specified, then only the last set of duplicate
elements found in the list will be retained.  Note that duplicates are
determined relative to the comparison used in the sort.  Thus if 
\fI-index 0\fR is used, \fB{1 a}\fR and \fB{1 b}\fR would be
considered duplicates and only the second element, \fB{1 b}\fR, would
be retained.

.SH "NOTES"
.PP
The options to \fBlsort\fR only control what sort of comparison is
used, and do not necessarily constrain what the values themselves
actually are.  This distinction is only noticeable when the list to be
sorted has fewer than two elements.
.PP
The \fBlsort\fR command is reentrant, meaning it is safe to use as
part of the implementation of a command used in the \fB\-command\fR
option.

.SH "EXAMPLES"

.PP
Sorting a list using ASCII sorting:
.CS
% lsort {a10 B2 b1 a1 a2}
B2 a1 a10 a2 b1
.CE

.PP
Sorting a list using Dictionary sorting:
.CS
% lsort -dictionary {a10 B2 b1 a1 a2}
a1 a2 a10 b1 B2
.CE

.PP
Sorting lists of integers:
.CS
% lsort -integer {5 3 1 2 11 4}
1 2 3 4 5 11
% lsort -integer {1 2 0x5 7 0 4 -1}
-1 0 1 2 4 0x5 7
.CE

.PP
Sorting lists of floating-point numbers:
.CS
% lsort -real {5 3 1 2 11 4}
1 2 3 4 5 11
% lsort -real {.5 0.07e1 0.4 6e-1}
0.4 .5 6e-1 0.07e1
.CE

.PP
Sorting using indices:
.CS
% # Note the space character before the c
% lsort {{a 5} { c 3} {b 4} {e 1} {d 2}}
{ c 3} {a 5} {b 4} {d 2} {e 1}
% lsort -index 0 {{a 5} { c 3} {b 4} {e 1} {d 2}}
{a 5} {b 4} { c 3} {d 2} {e 1}
% lsort -index 1 {{a 5} { c 3} {b 4} {e 1} {d 2}}
{e 1} {d 2} { c 3} {b 4} {a 5}
.CE

.PP
Stripping duplicate values using sorting:
.CS
% lsort -unique {a b c a b c a b c}
a b c
.CE

.PP
More complex sorting using a comparison function:
.CS
% proc compare {a b} {
    set a0 [lindex $a 0]
    set b0 [lindex $b 0]
    if {$a0 < $b0} {
        return -1
    } elseif {$a0 > $b0} {
        return 1
    }
    return [string compare [lindex $a 1] [lindex $b 1]]
}
% lsort -command compare \\
        {{3 apple} {0x2 carrot} {1 dingo} {2 banana}}
{1 dingo} {2 banana} {0x2 carrot} {3 apple}
.CE

.SH "SEE ALSO"
lappend(n), lindex(n), linsert(n), list(n), llength(n), lrange(n),
lreplace(n), lsearch(n)

.SH KEYWORDS
element, list, order, sort
