'\"
'\" Copyright (c) 1998 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: regexp.n,v 1.1.1.5 2002/04/05 16:13:05 jevans Exp $
'\" 
.so man.macros
.TH regexp n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
regexp \- Match a regular expression against a string

.SH SYNOPSIS
\fBregexp \fR?\fIswitches\fR? \fIexp string \fR?\fImatchVar\fR? ?\fIsubMatchVar subMatchVar ...\fR?
.BE

.SH DESCRIPTION
.PP
Determines whether the regular expression \fIexp\fR matches part or
all of \fIstring\fR and returns 1 if it does, 0 if it doesn't, unless
\fB-inline\fR is specified (see below).
(Regular expression matching is described in the \fBre_syntax\fR
reference page.)
.LP
If additional arguments are specified after \fIstring\fR then they
are treated as the names of variables in which to return
information about which part(s) of \fIstring\fR matched \fIexp\fR.
\fIMatchVar\fR will be set to the range of \fIstring\fR that
matched all of \fIexp\fR.  The first \fIsubMatchVar\fR will contain
the characters in \fIstring\fR that matched the leftmost parenthesized
subexpression within \fIexp\fR, the next \fIsubMatchVar\fR will
contain the characters that matched the next parenthesized
subexpression to the right in \fIexp\fR, and so on.
.PP
If the initial arguments to \fBregexp\fR start with \fB\-\fR then
they are treated as switches.  The following switches are
currently supported:
.TP 15
\fB\-about\fR
Instead of attempting to match the regular expression, returns a list
containing information about the regular expression.  The first
element of the list is a subexpression count.  The second element is a
list of property names that describe various attributes of the regular
expression. This switch is primarily intended for debugging purposes.
.TP 15
\fB\-expanded\fR
Enables use of the expanded regular expression syntax where
whitespace and comments are ignored.  This is the same as specifying
the \fB(?x)\fR embedded option (see METASYNTAX, below).
.TP 15
\fB\-indices\fR
Changes what is stored in the \fIsubMatchVar\fRs. 
Instead of storing the matching characters from \fIstring\fR,
each variable
will contain a list of two decimal strings giving the indices
in \fIstring\fR of the first and last characters in the matching
range of characters.
.TP 15
\fB\-line\fR
Enables newline-sensitive matching.  By default, newline is a
completely ordinary character with no special meaning.  With this
flag, `[^' bracket expressions and `.' never match newline, `^'
matches an empty string after any newline in addition to its normal
function, and `$' matches an empty string before any newline in
addition to its normal function.  This flag is equivalent to
specifying both \fB\-linestop\fR and \fB\-lineanchor\fR, or the
\fB(?n)\fR embedded option (see METASYNTAX, below).
.TP 15
\fB\-linestop\fR
Changes the behavior of `[^' bracket expressions and `.' so that they
stop at newlines.  This is the same as specifying the \fB(?p)\fR
embedded option (see METASYNTAX, below).
.TP 15
\fB\-lineanchor\fR
Changes the behavior of `^' and `$' (the ``anchors'') so they match the
beginning and end of a line respectively.  This is the same as
specifying the \fB(?w)\fR embedded option (see METASYNTAX, below).
.TP 15
\fB\-nocase\fR
Causes upper-case characters in \fIstring\fR to be treated as
lower case during the matching process.
.VS 8.3
.TP 15
\fB\-all\fR
Causes the regular expression to be matched as many times as possible
in the string, returning the total number of matches found.  If this
is specified with match variables, they will continue information for
the last match only.
.TP 15
\fB\-inline\fR
Causes the command to return, as a list, the data that would otherwise
be placed in match variables.  When using \fB-inline\fR,
match variables may not be specified.  If used with \fB-all\fR, the
list will be concatenated at each iteration, such that a flat list is
always returned.  For each match iteration, the command will append the
overall match data, plus one element for each subexpression in the
regular expression.  Examples are:
.CS
    regexp -inline -- {\\w(\\w)} " inlined "
 => {in n}
    regexp -all -inline -- {\\w(\\w)} " inlined "
 => {in n li i ne e}
.CE
.TP 15
\fB\-start\fR \fIindex\fR
Specifies a character index offset into the string to start
matching the regular expression at.  When using this switch, `^'
will not match the beginning of the line, and \\A will still
match the start of the string at \fIindex\fR.  If \fB\-indices\fR
is specified, the indices will be indexed starting from the
absolute beginning of the input string.
\fIindex\fR will be constrained to the bounds of the input string.
.VE 8.3
.TP 15
\fB\-\|\-\fR
Marks the end of switches.  The argument following this one will
be treated as \fIexp\fR even if it starts with a \fB\-\fR.
.PP
If there are more \fIsubMatchVar\fR's than parenthesized
subexpressions within \fIexp\fR, or if a particular subexpression
in \fIexp\fR doesn't match the string (e.g. because it was in a
portion of the expression that wasn't matched), then the corresponding
\fIsubMatchVar\fR will be set to ``\fB\-1 \-1\fR'' if \fB\-indices\fR
has been specified or to an empty string otherwise.

.SH "SEE ALSO"
re_syntax(n), regsub(n)

.SH KEYWORDS
match, regular expression, string
