#!/usr/bin/perl
#/*
# * (c) Copyright 1998-2001 by Rob Braun
# * All rights reserved.  The file named COPYRIGHT specifies the terms
# * and conditions for redistribution.
# */

# $RCSid = "$Id: xconv.pl,v 1.1.1.2 2002/06/17 22:51:29 zarzycki Exp $";

sub print_header;
sub print_defaults;


print_header;
print_defaults;

while( <STDIN> ) {

	chomp;

	# Remove comment lines
	if( grep /^#/, $_ ) {
		next;
	}

	@command = split ;

	if( !defined $command[0] ) {
		next;
	}

	if( grep /rpc/, $command[2] ) {
		print STDERR "Warning: Service $command[0] not added because\n";
		print STDERR "xinetd does not handle rpc services well\n";
		next;
	}

	print "service $command[0]\n";
	print "{\n";
	print "\tflags       = NAMEINARGS\n";
	print "\tsocket_type = $command[1]\n";
	print "\tprotocol    = $command[2]\n";
	if( grep /no/, $command[3] ) {
		print "\twait        = no\n";
	} else {
		print "\twait        = yes\n";
	}
	@user = split /\./, $command[4];
	print "\tuser        = $user[0]\n";
	if( defined $user[1] ) {
		print "\tgroup       = $user[1]\n";
	}
	if( grep /internal/, $command[5] ) {
		print "\ttype        = INTERNAL\n";
		print "\tid          = $command[0]-$command[1]\n";
	} else {
		print "\tserver      = $command[5]\n";
		print "\tserver_args = ";

		$i = 6;
		while( defined $command[$i] ) {
			print "$command[$i] ";
			$i++;
		}

		print "\n";
	}
	print "}\n";
	print "\n";
}

sub print_defaults
{
	print "# The defaults section sets some information for all services\n";
	print "defaults\n";
	print "{\n";
	print "\t#The maximum number of requests a particular service may handle\n";
	print "\t# at once.\n";
	print "\tinstances   = 25\n";
	print "\n";
	print "\t# The type of logging.  This logs to a file that is specified.\n";
	print "\t# Another option is: SYSLOG syslog_facility [syslog_level]\n";
	print "\tlog_type    = FILE /var/log/servicelog\n";
	print "\n";
	print "\t# What to log when the connection succeeds.\n";
	print "\t# PID logs the pid of the server processing the request.\n";
	print "\t# HOST logs the remote host's ip address.\n";
	print "\t# USERID logs the remote user (using RFC 1413)\n";
	print "\t# EXIT logs the exit status of the server.\n";
	print "\t# DURATION logs the duration of the session.\n";
	print "\tlog_on_success = HOST PID\n";
	print "\n";
	print "\t# What to log when the connection fails.  Same options as above\n";
	print "\tlog_on_failure = HOST RECORD\n";
	print "\n";
	print "\t# The maximum number of connections a specific IP address can\n";
	print "\t# have to a specific service.  \n";
	print "\tper_source  = 5\n";

	print "}\n";
	print "\n";
}

sub print_header
{
	print "# This file generated by xconv.pl, included with the xinetd\n";
	print "# package.  xconv.pl was written by Rob Braun (bbraun\@synack.net)\n";
	print "#\n";
	print "# The file is merely a translation of your inetd.conf file into\n";
	print "# the equivalent in xinetd.conf syntax.  xinetd has many \n";
	print "# features that may not be taken advantage of with this translation.\n";
	print "# Please refer to the xinetd.conf man page for more information \n";
	print "# on how to properly configure xinetd.\n";
	print "\n";
	print "\n";
}
