/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2002 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Prof Brochs gate 6, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_SOBOUNDINGBOXCACHE_H
#define COIN_SOBOUNDINGBOXCACHE_H

#include <Inventor/caches/SoCache.h>
#include <Inventor/SbXfBox3f.h>

class COIN_DLL_API SoBoundingBoxCache : public SoCache {
  typedef SoCache inherited;
public:
  SoBoundingBoxCache(SoState *state);
  ~SoBoundingBoxCache();

  void set(const SbXfBox3f &boundingBox,
           SbBool centerSet,
           const SbVec3f &centerPoint);

  const SbXfBox3f &getBox() const;
  const SbBox3f &getProjectedBox() const;

  SbBool isCenterSet() const;
  const SbVec3f &getCenter() const;

  static void setHasLinesOrPoints(SoState *state);
  SbBool hasLinesOrPoints() const;

private:
  SbXfBox3f bbox;
  SbBox3f localBBox;
  SbVec3f centerPoint;
  unsigned int centerSet : 1;
  unsigned int linesOrPoints : 1;
};

#endif // !COIN_SOBOUNDINGBOXCACHE_H
