/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netrexx.process;

import COM.ibm.netrexx.process.RxClass;
import COM.ibm.netrexx.process.RxClassImage;
import COM.ibm.netrexx.process.RxClassInfo;
import COM.ibm.netrexx.process.RxClassPool;
import COM.ibm.netrexx.process.RxClauseParser;
import COM.ibm.netrexx.process.RxConvert;
import COM.ibm.netrexx.process.RxCursor;
import COM.ibm.netrexx.process.RxField;
import COM.ibm.netrexx.process.RxFlag;
import COM.ibm.netrexx.process.RxProgram;
import COM.ibm.netrexx.process.RxQuit;
import COM.ibm.netrexx.process.RxToken;
import COM.ibm.netrexx.process.RxTranslator;
import COM.ibm.netrexx.process.RxType;
import COM.ibm.netrexx.process.RxWarn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxParse;

public class RxClasser {
    private static final char[] $01;
    private static final char[] $02;
    private static final Rexx $03;
    private static final Rexx $04;
    private static final Rexx $05;
    private static final Rexx $06;
    private static final Rexx $07;
    private static final Rexx $08;
    private static final Rexx $09;
    private static final Rexx $010;
    private static final Rexx $011;
    private static final Rexx $012;
    private static final Rexx $013;
    private static final Rexx $014;
    private static final Rexx $015;
    private static final Rexx $016;
    private static final Rexx $017;
    private static final Rexx $018;
    private static final Rexx $019;
    private static final Rexx $020;
    private static final Rexx $021;
    private static final Rexx $022;
    private static final Rexx $023;
    private static final Rexx $024;
    private static final Rexx $025;
    private static final Rexx $026;
    private static final Rexx $027;
    private static final Rexx $028;
    private static final String $0 = "RxClasser.nrx";
    String copyright = "Copyright (c) IBM Corporation, 2001.  All rights reserved.";
    private RxTranslator rxt;
    private char psep;
    private char fsep;
    private char zsep = (char)47;
    private char dot = (char)46;
    private String[] standpacks;
    private RxClassPool classpool;
    private Hashtable javakeytable;
    private Hashtable packagetable;
    private Vector localclasses;
    private Vector localfields;
    private Vector importclasses;
    private int classpaths = 0;
    private Vector classpathseg;
    private Vector classpathzip;
    private Vector classpathpax;
    private Vector classdefines;

    static {
        char[] cArray = new char[10];
        cArray[0] = 6;
        cArray[1] = '\u0001';
        cArray[2] = 10;
        cArray[3] = '\u0001';
        cArray[5] = '\u0001';
        cArray[6] = 10;
        cArray[7] = '\u0001';
        cArray[8] = 2;
        $01 = cArray;
        char[] cArray2 = new char[16];
        cArray2[0] = 6;
        cArray2[1] = '\u0001';
        cArray2[2] = 10;
        cArray2[3] = '\u0001';
        cArray2[5] = 4;
        cArray2[6] = '\u0001';
        cArray2[7] = 3;
        cArray2[8] = 10;
        cArray2[9] = '\u0001';
        cArray2[10] = 2;
        cArray2[11] = '\u0001';
        cArray2[12] = 10;
        cArray2[13] = '\u0001';
        cArray2[14] = 3;
        $02 = cArray2;
        $03 = Rexx.toRexx("");
        $04 = new Rexx(':');
        $05 = Rexx.toRexx("# Import:");
        $06 = new Rexx('[');
        $07 = new Rexx(']');
        $08 = new Rexx('*');
        $09 = new Rexx('.');
        $010 = Rexx.toRexx("'...");
        $011 = new Rexx('\'');
        $012 = new Rexx('0');
        $013 = Rexx.toRexx("null");
        $014 = new Rexx('(');
        $015 = new Rexx(')');
        $016 = Rexx.toRexx("in '");
        $017 = Rexx.toRexx("# prop:");
        $018 = Rexx.toRexx("[type");
        $019 = Rexx.toRexx("] found");
        $020 = Rexx.toRexx("in");
        $021 = Rexx.toRexx("# method:");
        $022 = Rexx.toRexx(") returns");
        $023 = Rexx.toRexx("found in");
        $024 = Rexx.toRexx("# +excep:");
        $025 = Rexx.toRexx("$0");
        $026 = new Rexx(',');
        $027 = Rexx.toRexx(") [");
        $028 = Rexx.toRexx("]:");
    }

    public RxClasser(RxTranslator rxTranslator, String[] stringArray) {
        int n = 0;
        this.rxt = rxTranslator;
        this.fsep = Rexx.tochar(System.getProperty("file.separator"));
        this.psep = Rexx.tochar(System.getProperty("path.separator"));
        this.classpathseg = new Vector(50);
        this.classpathzip = new Vector(50);
        this.classpathpax = new Vector(50);
        this.classdefines = new Vector(5);
        this.localclasses = new Vector(10);
        this.localfields = new Vector(30);
        this.importclasses = new Vector(50);
        this.packagetable = new Hashtable(300);
        this.classpool = new RxClassPool(this.rxt);
        this.standpacks = !this.rxt.program.flag.strictimport ? stringArray : new String[0];
        this.initclasspath();
        this.importclasses(new Rexx('*'), true, null, true);
        int n2 = RxTranslator.primitives.words().toint();
        n = 1;
        while (n <= n2) {
            this.classpool.register("", Rexx.toString(RxTranslator.primitives.word(new Rexx(n))), null, null, true, null, false);
            ++n;
        }
        if (this.rxt.superflag.diag) {
            this.classpool.stats();
            RexxIO.Say("# " + this.packagetable.size() + " " + "packages");
        }
    }

    private boolean accessible(RxCursor rxCursor, RxClassInfo rxClassInfo, RxField rxField, RxToken rxToken) {
        int n = rxField.fieldvisib;
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            if (rxClassInfo.packname.equals(rxField.fieldinfo.packname)) {
                return true;
            }
            return this.issubclass(rxCursor, rxClassInfo, rxField.fieldinfo, rxToken);
        }
        if (n == 3) {
            return rxClassInfo.packname.equals(rxField.fieldinfo.packname);
        }
        if (n == 4) {
            return rxClassInfo.type.equals(rxField.fieldinfo.type);
        }
        throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxClasser: access " + n));
    }

    public void addlookaside(RxClassInfo rxClassInfo) {
        this.classdefines.addElement(rxClassInfo);
    }

    void addpackage(String string) {
        this.addpackage(string, null);
    }

    void addpackage(String string, Hashtable hashtable) {
        int n;
        if (hashtable != null) {
            if (hashtable.containsKey(string)) {
                return;
            }
            hashtable.put(string, string);
        }
        if (this.packagetable.containsKey(string)) {
            return;
        }
        this.packagetable.put(string, string);
        if (this.rxt.superflag.diag && this.rxt.program.flag.verbose > 4) {
            RexxIO.Say("# AddPackage: " + string);
        }
        if ((n = string.lastIndexOf(this.dot, string.length() - 1)) < 0) {
            return;
        }
        string = string.substring(0, n);
        this.addpackage(string, hashtable);
    }

    public void addshortref(RxClassInfo rxClassInfo) {
        String string = null;
        String string2 = rxClassInfo.shortname.toString();
        string = this.rxt.program.flag.strictcase ? string2 : string2.toLowerCase();
        if (this.rxt.program.shortref.containsKey(string)) {
            return;
        }
        this.rxt.program.shortref.put(string, string2);
    }

    private Rexx argtlist(RxType[] rxTypeArray) {
        int n = 0;
        String string = "";
        if (rxTypeArray != null) {
            int n2 = rxTypeArray.length;
            n = 0;
            while (n2 > 0) {
                if (n > 0) {
                    string = String.valueOf(string) + ",";
                }
                string = Rexx.toString(Rexx.toRexx(string).OpCc(null, rxTypeArray[n].toSig()));
                --n2;
                ++n;
            }
        }
        return Rexx.toRexx(string);
    }

    public void cleanlookaside() {
        int n = 0;
        RxClassInfo rxClassInfo = null;
        int n2 = this.classdefines.size();
        n = 0;
        while (n2 > 0) {
            rxClassInfo = (RxClassInfo)this.classdefines.elementAt(n);
            rxClassInfo.classobject = null;
            rxClassInfo.initialized = false;
            --n2;
            ++n;
        }
        this.classdefines = new Vector(5);
        if (this.rxt.superflag.diag) {
            this.classpool.stats();
            RexxIO.Say("# " + this.packagetable.size() + " " + "packages");
        }
    }

    public Rexx currpackage() {
        int n = 0;
        ZipFile zipFile = null;
        Rexx rexx = null;
        Rexx rexx2 = Rexx.toRexx(System.getProperty("user.dir"));
        int n2 = this.classpaths;
        n = 0;
        while (n2 > 0) {
            zipFile = (ZipFile)this.classpathzip.elementAt(n);
            if (zipFile == null && rexx2.left((rexx = (Rexx)this.classpathseg.elementAt(n)).length()).OpEq(null, rexx)) {
                return rexx2.substr(new Rexx(rexx.length().toint() + 2)).translate(new Rexx('.'), new Rexx(this.fsep));
            }
            --n2;
            ++n;
        }
        return Rexx.toRexx("");
    }

    public int dirfind(String string, String string2, String string3, boolean bl, RxProgram rxProgram) {
        return this.dirfind(string, string2, string3, bl, rxProgram, false);
    }

    public int dirfind(String string, String string2, String string3, boolean bl, RxProgram rxProgram, boolean bl2) {
        File file;
        String string4 = null;
        String string5 = null;
        long l = 0L;
        String string6 = null;
        File file2 = null;
        RxClassInfo rxClassInfo = null;
        int n = 0;
        int n2 = 0;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = string2.replace('.', this.fsep);
        if (string.equals("")) {
            string4 = System.getProperty("user.dir");
            bl2 = false;
        } else {
            string4 = string;
        }
        if (string10.length() > 0) {
            string4 = String.valueOf(string4) + String.valueOf(this.fsep) + string10;
        }
        if (!(file = new File(string4)).isDirectory()) {
            return 0;
        }
        if (this.rxt.superflag.diag) {
            string5 = string3 == null ? "[all]" : string3;
            RexxIO.Say("# DIRFIND: " + string4 + " " + "\"" + string + "\"" + " " + "'" + string10 + "'" + " " + "'" + string5 + "'");
            l = System.currentTimeMillis();
        }
        if (string3 != null) {
            string6 = String.valueOf(string3.replace('.', '$')) + ".class";
            file2 = new File(file, string6);
            if (file2.exists()) {
                rxClassInfo = this.classpool.register(string2, string3, file2, null, bl, rxProgram, true);
                if (rxProgram != null) {
                    this.importclasses.addElement(rxClassInfo);
                }
                n = 1;
            } else {
                n = 0;
            }
            if (this.rxt.superflag.diag) {
                RexxIO.Say("# DIRFIND checked [" + n + "] after" + " " + (System.currentTimeMillis() - l) + "ms");
            }
            return n;
        }
        int n3 = 0;
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n4 = stringArray.length;
            n2 = 0;
            while (n4 > 0) {
                string7 = stringArray[n2];
                if (!string7.endsWith(".class")) {
                    if (bl2 && string7.indexOf(this.dot, 0) < 0 && (file2 = new File(file, string7)).isDirectory() && file2.exists()) {
                        string8 = string2.length() == 0 ? string7 : String.valueOf(string2) + "." + string7;
                        n3 += this.dirfind(string, string8, null, bl, rxProgram);
                    }
                } else {
                    file2 = new File(file, string7);
                    string9 = string7.substring(0, string7.length() - 6);
                    rxClassInfo = this.classpool.register(string2, string9, file2, null, bl, rxProgram, false);
                    if (rxProgram != null) {
                        this.importclasses.addElement(rxClassInfo);
                    }
                    ++n3;
                }
                --n4;
                ++n2;
            }
        }
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# DIRFIND loop end with [" + n3 + "] after" + " " + (System.currentTimeMillis() - l) + "ms");
        }
        return n3;
    }

    public void discardlocals() {
        int n = 0;
        RxClassInfo rxClassInfo = null;
        this.classpool.unhide();
        int n2 = this.localclasses.size();
        n = 0;
        while (n2 > 0) {
            rxClassInfo = (RxClassInfo)this.localclasses.elementAt(n);
            this.classpool.discard(rxClassInfo);
            --n2;
            ++n;
        }
        int n3 = this.importclasses.size();
        n = 0;
        while (n3 > 0) {
            rxClassInfo = (RxClassInfo)this.importclasses.elementAt(n);
            this.classpool.discard(rxClassInfo);
            --n3;
            ++n;
        }
        this.localclasses = new Vector(10);
        this.localfields = new Vector(30);
        this.importclasses = new Vector(50);
    }

    public RxClassInfo findanyclass(RxCursor rxCursor, Rexx rexx, RxToken rxToken) {
        RxClass rxClass = null;
        RxClassInfo rxClassInfo = null;
        int n = 0;
        RxClassInfo rxClassInfo2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (rexx.pos(new Rexx('.')).OpEqS(null, $012) && (rxClass = rxCursor.curclass) != null && (rxClassInfo = rxClass.classinfo) != null) {
            int n2;
            if (rxClassInfo.children != null) {
                n2 = rxClassInfo.children.size();
                n = 0;
                while (n2 > 0) {
                    rxClassInfo2 = (RxClassInfo)rxClassInfo.children.elementAt(n);
                    bl = this.rxt.program.flag.strictcase ? rexx.OpEqS(null, Rexx.toRexx(rxClassInfo2.shortname)) : rexx.OpEq(null, Rexx.toRexx(rxClassInfo2.shortname));
                    if (!bl) {
                        --n2;
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                rxClassInfo2 = rxClassInfo;
                n2 = 1;
                while (true) {
                    if (n2 != 0) {
                        n2 = 0;
                    } else if (rxClassInfo2 == null) break;
                    bl2 = this.rxt.program.flag.strictcase ? rexx.OpEqS(null, Rexx.toRexx(rxClassInfo2.shortname)) : rexx.OpEq(null, Rexx.toRexx(rxClassInfo2.shortname));
                    if (bl2) break;
                    rxClassInfo2 = rxClassInfo2.parentinfo;
                }
            }
        }
        if (rxClassInfo2 == null) {
            rxClassInfo2 = this.findpackclass(rxCursor, true, rexx, rxToken, true);
        }
        if (rxClassInfo2 != null && rxClassInfo2.isdeprecated) {
            this.warndep(rxToken, rxClassInfo2);
        }
        return rxClassInfo2;
    }

    public RxClassInfo findclass(RxCursor rxCursor, RxType rxType, RxToken rxToken, boolean bl) {
        RxClassInfo rxClassInfo;
        RxProgram rxProgram = null;
        rxProgram = rxCursor == null ? null : rxCursor.curprogram;
        Rexx rexx = rxType.getPackageName();
        Rexx rexx2 = rxType.getClassName();
        if (rexx == null) {
            rexx = Rexx.toRexx("");
        }
        if ((rxClassInfo = this.classpool.find(rxProgram, Rexx.toString(rexx), Rexx.toString(rexx2), true)) != null) {
            this.loadclass(rxCursor, rxClassInfo, rxToken, bl);
            return rxClassInfo;
        }
        return this.findpackclass(rxCursor, false, rxType.classname, rxToken, bl);
    }

    public RxClassInfo findclass(RxCursor rxCursor, Rexx rexx, RxToken rxToken, boolean bl) {
        return this.findpackclass(rxCursor, false, rexx, rxToken, bl);
    }

    public RxClassInfo findclassbyid(int n) {
        if (--n < 0 || n >= this.localclasses.size()) {
            return null;
        }
        return (RxClassInfo)this.localclasses.elementAt(n);
    }

    public RxField findfield(RxCursor rxCursor, boolean bl, boolean bl2, boolean bl3, boolean bl4, RxClassInfo rxClassInfo, Rexx rexx, RxType[] rxTypeArray, RxToken rxToken) {
        return this.findfield(rxCursor, bl, bl2, bl3, bl4, rxClassInfo, rexx, rxTypeArray, rxToken, true);
    }

    public RxField findfield(RxCursor rxCursor, boolean bl, boolean bl2, boolean bl3, boolean bl4, RxClassInfo rxClassInfo, Rexx rexx, RxType[] rxTypeArray, RxToken rxToken, boolean bl5) {
        RxField rxField;
        RxFlag rxFlag = null;
        Rexx rexx2 = null;
        rxFlag = rxCursor == null ? this.rxt.superflag : rxCursor.curprogram.flag;
        if (rxFlag.diag) {
            rexx2 = this.argtlist(rxTypeArray);
            if (rexx2.OpNotEqS(null, $03)) {
                rexx2 = $014.OpCc(null, rexx2).OpCc(null, $015);
            }
            RexxIO.Say(Rexx.toRexx("# FF: " + (bl ? "1" : "0") + (bl2 ? "1" : "0") + (bl3 ? "1" : "0") + (bl4 ? "1" : "0") + " " + "looking for '").OpCc(null, rexx).OpCc(null, rexx2).OpCc(null, $011).OpCcblank(null, $016).OpCc(null, rxClassInfo.type.toSig()).OpCc(null, $010).OpCcblank(null, new Rexx(bl5)));
        }
        if (rxClassInfo == null) {
            return null;
        }
        if (rxClassInfo.type.isarray()) {
            return null;
        }
        if (rxClassInfo.type.isprimitive()) {
            return null;
        }
        boolean bl6 = false;
        if (bl2) {
            bl6 = rxFlag.strictcase ? rexx.OpEqS(null, Rexx.toRexx(rxClassInfo.shortname)) : rexx.OpEq(null, Rexx.toRexx(rxClassInfo.shortname));
        }
        if ((rxField = this.searchfield(rxCursor, bl, bl2, bl3, bl4, rxClassInfo, rxClassInfo, rexx, rxTypeArray, rxToken, bl5, bl6)) == null) {
            return null;
        }
        if (rxToken == null) {
            return rxField;
        }
        if (rxField.isDeprecated()) {
            this.warndep(rxToken, rxField);
        } else if (rxField.fieldinfo.isdeprecated) {
            this.warndep(rxToken, rxField.fieldinfo);
        }
        return rxField;
    }

    public RxField findfieldbyid(int n) {
        if (--n < 0 || n >= this.localfields.size()) {
            return null;
        }
        return (RxField)this.localfields.elementAt(n);
    }

    public void findimps(RxCursor rxCursor, RxClassInfo rxClassInfo, RxToken rxToken) {
        int n = 0;
        int n2 = 0;
        n = rxClassInfo.impnames == null ? 0 : rxClassInfo.impnames.length;
        RxClassInfo[] rxClassInfoArray = new RxClassInfo[n];
        int n3 = n;
        n2 = 0;
        while (n3 > 0) {
            rxClassInfoArray[n2] = this.findclass(rxCursor, Rexx.toRexx(rxClassInfo.impnames[n2]), rxToken, false);
            if (rxClassInfoArray[n2] == null) {
                throw new RxQuit(this.rxt, rxToken, "class.not.found", Rexx.toRexx(rxClassInfo.impnames[n2]));
            }
            --n3;
            ++n2;
        }
        rxClassInfo.impinfos = rxClassInfoArray;
        rxClassInfo.impnames = null;
    }

    public RxClassInfo findknownclass(Rexx rexx) {
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        int n = rexx.lastpos(new Rexx('.')).toint();
        if (n == 0) {
            rexx2 = rexx;
            rexx3 = Rexx.toRexx("");
        } else {
            rexx2 = rexx.substr(new Rexx(n + 1));
            rexx3 = rexx.left(new Rexx(n - 1));
        }
        rexx2 = rexx2.changestr(new Rexx('$'), new Rexx('.'));
        RxClassInfo rxClassInfo = this.classpool.find(this.rxt.program, Rexx.toString(rexx3), Rexx.toString(rexx2), true);
        if (rxClassInfo == null) {
            return null;
        }
        if (rxClassInfo.local) {
            return rxClassInfo;
        }
        if (rxClassInfo.imagedata != null) {
            return rxClassInfo;
        }
        return null;
    }

    private RxClassInfo findpackclass(RxCursor rxCursor, boolean bl, Rexx rexx, RxToken rxToken, boolean bl2) {
        String string;
        RxProgram rxProgram = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        rxProgram = rxCursor == null ? null : rxCursor.curprogram;
        String string5 = null;
        string2 = bl ? null : "";
        RxClassInfo rxClassInfo = this.classpool.find(rxProgram, string2, string = rexx.toString(), true);
        if (rxClassInfo == null) {
            if (string.length() == 4) {
                if (string.equals("null")) {
                    return null;
                }
                if (string.equals("void")) {
                    return null;
                }
            }
            if ((string5 = this.getpackage(string, true)) == null) {
                string3 = string2;
                string4 = string;
            } else {
                string3 = string5;
                string4 = string.substring(string3.length() + 1, string.length());
            }
            rxClassInfo = this.classpool.find(rxProgram, string3, string4, true);
            if (rxClassInfo == null && string3 != null && string3.length() > 0 && this.importclasses(rexx, false, null).OpNotEqS(null, $012)) {
                rxClassInfo = this.classpool.find(rxProgram, string3, string4, true);
            }
            if (rxClassInfo == null && bl && !this.rxt.program.flag.strictcase && (rxClassInfo = this.classpool.find(rxProgram, string2, string, false)) == null) {
                rxClassInfo = this.classpool.find(rxProgram, string3, string4, false);
            }
        }
        if (rxClassInfo != null) {
            if (rxClassInfo.ambiguous && string5 == null) {
                throw new RxQuit(this.rxt, rxToken, "ambiguous.class.reference", rexx);
            }
            this.loadclass(rxCursor, rxClassInfo, rxToken, bl2);
            return rxClassInfo;
        }
        if (this.rxt.superflag.diag) {
            RexxIO.Say(Rexx.toRexx("# unfound class: '").OpCc(null, rexx).OpCc(null, $011).OpCcblank(null, new Rexx(bl)));
        }
        return null;
    }

    String getpackage(String string) {
        return this.getpackage(string, true);
    }

    String getpackage(String string, boolean bl) {
        String string2 = null;
        int n = 0;
        int n2 = string.length();
        if (bl) {
            n2 = string.lastIndexOf(this.dot, n2 - 1);
        }
        while (n2 >= 0) {
            string2 = string.substring(0, n2);
            if (this.ispackage(string2)) {
                return string2;
            }
            n = n2 - 1;
            n2 = string.lastIndexOf(this.dot, n);
        }
        return null;
    }

    public String getshortref(String string) {
        String string2 = null;
        string2 = this.rxt.program.flag.strictcase ? string : string.toLowerCase();
        return (String)this.rxt.program.shortref.get(string2);
    }

    public Rexx importclasses(Rexx rexx) {
        return this.importclasses(rexx, true, this.rxt.program, false);
    }

    public Rexx importclasses(Rexx rexx, boolean bl) {
        return this.importclasses(rexx, bl, this.rxt.program, false);
    }

    public Rexx importclasses(Rexx rexx, boolean bl, RxProgram rxProgram) {
        return this.importclasses(rexx, bl, rxProgram, false);
    }

    public Rexx importclasses(Rexx rexx, boolean bl, RxProgram rxProgram, boolean bl2) {
        int n;
        long l = 0L;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        int n2 = 0;
        String string3 = null;
        int n3 = 0;
        Hashtable hashtable = null;
        ZipFile zipFile = null;
        Rexx rexx2 = null;
        if (this.rxt.superflag.diag) {
            RexxIO.Say($05.OpCcblank(null, rexx).OpCcblank(null, $06).OpCc(null, new Rexx(bl)).OpCcblank(null, new Rexx(bl2)).OpCcblank(null, new Rexx(rxProgram == null)).OpCc(null, $07));
            l = System.currentTimeMillis();
        }
        RxClassInfo rxClassInfo = null;
        String string4 = rexx.toString();
        int n4 = string4.length();
        if (rexx.OpEqS(null, $08)) {
            string = "";
            string2 = string4;
            bl3 = true;
        } else if (rexx.right(new Rexx(1)).OpEqS(null, $09)) {
            string = string4.substring(0, n4 - 1);
            n = this.standpacks.length;
            n2 = 0;
            while (n > 0) {
                if (this.standpacks[n2].equals(string)) {
                    return new Rexx(-1);
                }
                --n;
                ++n2;
            }
            string2 = null;
            bl3 = false;
        } else {
            string = this.getpackage(string4, false);
            if (string == null) {
                string = "";
                string2 = rexx.OpEqS(null, $03) ? null : string4;
            } else if (string.length() == n4) {
                string2 = null;
                n = this.standpacks.length;
                n2 = 0;
                while (n > 0) {
                    if (this.standpacks[n2].equals(string)) {
                        return new Rexx(-1);
                    }
                    --n;
                    ++n2;
                }
            } else {
                string2 = string4.substring(string.length() + 1, n4);
            }
            if (string2 != null && bl && (rxClassInfo = this.classpool.find(rxProgram, null, string2, true)) != null && rxClassInfo.explicit) {
                return new Rexx(-2);
            }
            bl3 = false;
        }
        if (this.rxt.superflag.diag) {
            string3 = string2;
            if (string3 == null) {
                string3 = "[null]";
            }
            RexxIO.Say("# ImportFind: " + string + " " + ":" + " " + string3);
        }
        int n5 = 0;
        n = this.classpaths;
        n3 = 0;
        while (n > 0) {
            hashtable = (Hashtable)this.classpathpax.elementAt(n3);
            if (string.equals("") || hashtable.containsKey(string)) {
                zipFile = (ZipFile)this.classpathzip.elementAt(n3);
                if (zipFile != null) {
                    n5 += this.zipfind(zipFile, string, string2, bl, rxProgram, bl2, hashtable);
                } else {
                    rexx2 = (Rexx)this.classpathseg.elementAt(n3);
                    if (!bl3) {
                        n5 += this.dirfind(Rexx.toString(rexx2), string, string2, bl, rxProgram, bl2);
                    } else {
                        this.packdirfind(Rexx.toString(rexx2), hashtable);
                        int n6 = this.standpacks.length;
                        n2 = 0;
                        while (n6 > 0) {
                            n5 += this.dirfind(Rexx.toString(rexx2), this.standpacks[n2], null, bl, rxProgram, bl2);
                            --n6;
                            ++n2;
                        }
                    }
                }
            }
            --n;
            ++n3;
        }
        if (n5 == 1 && bl && string2 != null) {
            if (string.equals("")) {
                this.rxt.program.javaimports.put(string2, string2);
            } else {
                this.rxt.program.javaimports.put(string4, string4);
            }
        }
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# Imported " + n5 + " " + "after" + " " + (System.currentTimeMillis() - l) + "ms");
        }
        return new Rexx(n5);
    }

    public void initclasspath() {
        String[] stringArray = null;
        int n = 0;
        String string = null;
        Rexx rexx = null;
        String string2 = null;
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        Rexx rexx4 = null;
        int n2 = 0;
        File file = null;
        int n3 = 0;
        ZipFile zipFile = null;
        ZipException zipException = null;
        IOException iOException = null;
        String string3 = System.getProperty("java.class.path");
        String string4 = System.getProperty("java.home");
        String string5 = String.valueOf(string4) + String.valueOf(this.fsep) + "lib" + String.valueOf(this.fsep);
        string3 = String.valueOf(string3) + String.valueOf(this.psep) + string5 + "classes.zip";
        string3 = String.valueOf(string3) + String.valueOf(this.psep) + string5 + "classes.jar";
        string3 = String.valueOf(string3) + String.valueOf(this.psep) + string5 + "rt.jar";
        string3 = String.valueOf(string3) + String.valueOf(this.psep) + string4 + String.valueOf(this.fsep) + ".." + String.valueOf(this.fsep) + "lib" + String.valueOf(this.fsep) + "tools.jar";
        String string6 = String.valueOf(string5) + "ext" + String.valueOf(this.fsep);
        File file2 = new File(string6);
        if (file2.isDirectory() && (stringArray = file2.list()) != null) {
            int n4 = stringArray.length;
            n = 0;
            while (n4 > 0) {
                string = stringArray[n];
                if (string.endsWith(".jar")) {
                    string3 = String.valueOf(string3) + String.valueOf(this.psep) + string6 + string;
                    if (this.rxt.superflag.diag) {
                        RexxIO.Say("# ext: " + string);
                    }
                }
                --n4;
                ++n;
            }
        }
        this.classpaths = 0;
        Rexx rexx5 = Rexx.toRexx("");
        String string7 = string3;
        block4: while (!string7.equals("")) {
            Rexx[] rexxArray = new Rexx[3];
            rexxArray[1] = new Rexx(this.psep);
            RexxParse.parse(Rexx.toRexx(string7), $01, rexxArray);
            rexx = rexxArray[0];
            string7 = Rexx.toString(rexxArray[2]);
            if (rexx.right(new Rexx(1)).OpEqS(null, new Rexx(this.fsep))) {
                rexx = rexx.left(new Rexx(rexx.length().toint() - 1));
            }
            rexx = rexx.strip(new Rexx('b'), new Rexx('\"'));
            string2 = String.valueOf(String.valueOf(this.fsep)) + "..";
            while (true) {
                Rexx[] rexxArray2 = new Rexx[4];
                rexxArray2[1] = Rexx.toRexx(string2);
                RexxParse.parse(rexx, $02, rexxArray2);
                rexx2 = rexxArray2[0];
                rexx3 = rexxArray2[2];
                rexx4 = rexxArray2[3];
                if (rexx3.OpEqS(null, $03) || (n2 = rexx2.lastpos(new Rexx(this.fsep)).toint()) == 0) break;
                rexx = rexx2.left(new Rexx(n2 - 1)).OpCc(null, rexx4);
            }
            file = new File(Rexx.toString(rexx));
            if (!file.exists()) continue;
            int n5 = this.classpathseg.size();
            n3 = 0;
            while (n5 > 0) {
                if (rexx.OpEq(null, (Rexx)this.classpathseg.elementAt(n3))) continue block4;
                --n5;
                ++n3;
            }
            if (rexx.right(new Rexx(1)).OpEqS(null, $04)) {
                rexx = rexx.OpCc(null, new Rexx(this.fsep));
            }
            ++this.classpaths;
            this.classpathseg.addElement(rexx);
            this.classpathpax.addElement(new Hashtable());
            if (this.classpaths > 1) {
                rexx5 = rexx5.OpCc(null, new Rexx(this.psep));
            }
            rexx5 = rexx5.OpCc(null, rexx);
            if (this.rxt.superflag.diag) {
                RexxIO.Say(Rexx.toRexx("# Classpathseg").OpCcblank(null, rexx));
            }
            if (file.isDirectory()) {
                this.classpathzip.addElement(null);
                continue;
            }
            try {
                zipFile = new ZipFile(file);
                this.classpathzip.addElement(zipFile);
            }
            catch (ZipException zipException2) {
                zipException = zipException2;
                throw new RxQuit(this.rxt, null, "bad.zip.file.format", rexx, Rexx.toRexx(zipException.getMessage()));
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                throw new RxQuit(this.rxt, null, "cannot.read.zip.file", rexx, Rexx.toRexx(iOException.getMessage()));
            }
        }
        if (this.classpaths == 0) {
            throw new RxQuit(this.rxt, null, "no.valid.classpath.segments", Rexx.toRexx(string3));
        }
        this.rxt.classpath = Rexx.toString(rexx5);
    }

    public boolean isambiguous(RxProgram rxProgram, Rexx rexx) {
        String string = rexx.toString();
        RxClassInfo rxClassInfo = this.classpool.find(rxProgram, null, string, true);
        if (rxClassInfo == null) {
            return false;
        }
        if (!rxClassInfo.ambiguous) {
            return false;
        }
        if (this.rxt.exec) {
            return true;
        }
        return rxProgram.parser == null || rxProgram.packagename != null || rxProgram.parser.cursor.curclass == null || !rxProgram.parser.cursor.curclass.classname.OpEqS(null, rexx);
    }

    public boolean ispackage(String string) {
        return this.packagetable.get(string) != null;
    }

    public boolean isshortref(String string) {
        String string2 = null;
        string2 = this.rxt.program.flag.strictcase ? string : string.toLowerCase();
        return this.rxt.program.shortref.containsKey(string2);
    }

    public boolean issubclass(RxCursor rxCursor, RxClassInfo rxClassInfo, RxClassInfo rxClassInfo2, RxToken rxToken) {
        return this.testsubclass(rxCursor, rxClassInfo, rxClassInfo2, rxToken, null);
    }

    public boolean issubclass(RxCursor rxCursor, RxClassInfo rxClassInfo, RxType rxType, RxToken rxToken) {
        RxClassInfo rxClassInfo2 = this.findclass(rxCursor, rxType, rxToken, false);
        if (rxClassInfo2 == null) {
            return false;
        }
        return this.testsubclass(rxCursor, rxClassInfo, rxClassInfo2, rxToken, null);
    }

    public boolean issubclass(RxCursor rxCursor, RxType rxType, RxType rxType2, RxToken rxToken) {
        if (rxType.classname.OpEqS(null, $013)) {
            return !rxType2.isprimitive();
        }
        RxClassInfo rxClassInfo = this.findclass(rxCursor, rxType, rxToken, false);
        if (rxClassInfo == null) {
            return false;
        }
        return this.issubclass(rxCursor, rxClassInfo, rxType2, rxToken);
    }

    public boolean javakey(String string) {
        Object object = null;
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c < 'a') {
            return false;
        }
        if (c > 'w') {
            return false;
        }
        if (this.javakeytable == null) {
            this.javakeytable = new Hashtable(101);
            object = new Object();
            this.javakeytable.put("abstract", object);
            this.javakeytable.put("boolean", object);
            this.javakeytable.put("break", object);
            this.javakeytable.put("byte", object);
            this.javakeytable.put("case", object);
            this.javakeytable.put("catch", object);
            this.javakeytable.put("char", object);
            this.javakeytable.put("class", object);
            this.javakeytable.put("const", object);
            this.javakeytable.put("continue", object);
            this.javakeytable.put("default", object);
            this.javakeytable.put("do", object);
            this.javakeytable.put("double", object);
            this.javakeytable.put("else", object);
            this.javakeytable.put("extends", object);
            this.javakeytable.put("false", object);
            this.javakeytable.put("final", object);
            this.javakeytable.put("finally", object);
            this.javakeytable.put("float", object);
            this.javakeytable.put("for", object);
            this.javakeytable.put("goto", object);
            this.javakeytable.put("if", object);
            this.javakeytable.put("implements", object);
            this.javakeytable.put("import", object);
            this.javakeytable.put("instanceof", object);
            this.javakeytable.put("int", object);
            this.javakeytable.put("interface", object);
            this.javakeytable.put("long", object);
            this.javakeytable.put("native", object);
            this.javakeytable.put("new", object);
            this.javakeytable.put("null", object);
            this.javakeytable.put("package", object);
            this.javakeytable.put("private", object);
            this.javakeytable.put("protected", object);
            this.javakeytable.put("public", object);
            this.javakeytable.put("return", object);
            this.javakeytable.put("short", object);
            this.javakeytable.put("static", object);
            this.javakeytable.put("super", object);
            this.javakeytable.put("switch", object);
            this.javakeytable.put("synchronized", object);
            this.javakeytable.put("this", object);
            this.javakeytable.put("throw", object);
            this.javakeytable.put("throws", object);
            this.javakeytable.put("transient", object);
            this.javakeytable.put("true", object);
            this.javakeytable.put("try", object);
            this.javakeytable.put("void", object);
            this.javakeytable.put("volatile", object);
            this.javakeytable.put("while", object);
        }
        return this.javakeytable.get(string) != null;
    }

    private void loadclass(RxCursor rxCursor, RxClassInfo rxClassInfo, RxToken rxToken, boolean bl) {
        IOException iOException = null;
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        File file = null;
        long l = 0L;
        Rexx rexx = null;
        int n = 0;
        RxField[] rxFieldArray = null;
        int n2 = 0;
        RxField rxField = null;
        long l2 = 0L;
        String string = null;
        String string2 = null;
        if (rxClassInfo.loaded) {
            return;
        }
        rxClassInfo.loaded = true;
        if (rxClassInfo.type.isprimitive()) {
            return;
        }
        if (rxClassInfo.type.equals(RxTranslator.nulltype)) {
            return;
        }
        if (this.rxt.program.flag.verbose > 4) {
            this.rxt.say(Rexx.toRexx("  Loading class '").OpCc(null, rxClassInfo.type.classname).OpCc(null, $010));
        } else if (this.rxt.superflag.diag) {
            RexxIO.Say(Rexx.toRexx("# Loadclass").OpCcblank(null, rxClassInfo.type.classname));
        }
        Object object = rxClassInfo.fileitem;
        if (object == null) {
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxClasser: null fileitem for").OpCcblank(null, rxClassInfo.type.classname));
        }
        InputStream inputStream = null;
        long l3 = 0L;
        if (object instanceof ZipFile) {
            try {
                zipFile = (ZipFile)object;
                if (this.rxt.superflag.diag) {
                    RexxIO.Say("# ... from zipfile " + zipFile.getName());
                }
                if (rxClassInfo.entry == null) {
                    throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxClasser: null entry for").OpCcblank(null, rxClassInfo.type.classname));
                }
                zipEntry = (ZipEntry)rxClassInfo.entry;
                inputStream = zipFile.getInputStream(zipEntry);
                l3 = zipEntry.getSize();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                if (iOException instanceof ZipException) {
                    throw new RxQuit(this.rxt, rxToken, "classes.zip.format.error", Rexx.toRexx(iOException.getMessage()));
                }
                throw new RxQuit(this.rxt, rxToken, "classes.zip.read.error", Rexx.toRexx(iOException.getMessage()));
            }
        }
        try {
            file = (File)object;
            if (this.rxt.superflag.diag) {
                RexxIO.Say("# ... from file " + file.toString());
            }
            inputStream = new FileInputStream(file);
            l3 = ((InputStream)inputStream).available();
        }
        catch (FileNotFoundException fileNotFoundException) {
            iOException = fileNotFoundException;
            throw new RxQuit(this.rxt, rxToken, "class.file.not.found", Rexx.toRexx(iOException.getMessage()));
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw new RxQuit(this.rxt, rxToken, "cannot.read.class", Rexx.toRexx(file.getName()), Rexx.toRexx(iOException.getMessage()));
        }
        if (this.rxt.superflag.diag) {
            l = System.currentTimeMillis();
        }
        RxClassImage rxClassImage = new RxClassImage(this.rxt, rxClassInfo, inputStream, l3, rxToken);
        if (rxClassInfo.type.classname.OpNotEqS(null, Rexx.toRexx(rxClassImage.thisname))) {
            throw new RxQuit(this.rxt, rxToken, "class.imposter", rxClassInfo.type.classname, Rexx.toRexx(rxClassImage.thisname));
        }
        if (bl) {
            rexx = this.rxt.program.packagename;
            if (rexx == null) {
                rexx = Rexx.toRexx("");
            }
            if (!rxClassImage.isvisible(Rexx.toString(rexx))) {
                throw new RxQuit(this.rxt, rxToken, "class.not.public", rxClassInfo.type.classname);
            }
        }
        rxClassInfo.fullname = rxClassImage.thisfullname;
        rxClassInfo.parents = rxClassImage.thisparents;
        rxClassInfo.minors = rxClassImage.thisminors;
        rxClassInfo.ispublic = rxClassImage.ispublic;
        rxClassInfo.isinterface = rxClassImage.isinterface;
        rxClassInfo.isabstract = rxClassImage.isabstract;
        rxClassInfo.isfinal = rxClassImage.isfinal;
        rxClassInfo.isdeprecated = rxClassImage.isdeprecated;
        rxClassInfo.isdependent = rxClassImage.isdependent;
        rxClassInfo.isallpublic = rxClassImage.isallpublic;
        rxClassInfo.impnames = rxClassImage.interfaces;
        if (!this.rxt.wontexec) {
            rxClassInfo.imagedata = rxClassImage.data;
        }
        if (rxClassImage.supername != null) {
            rxClassInfo.superinfo = this.findclass(rxCursor, Rexx.toRexx(rxClassImage.supername), null, false);
        }
        if (rxClassImage.parentname != null) {
            rxClassInfo.parentinfo = this.findclass(rxCursor, Rexx.toRexx(rxClassImage.parentname), null, false);
        }
        int n3 = 0;
        int n4 = 0;
        n = 0;
        while (n <= 1) {
            rxFieldArray = n == 0 ? rxClassImage.propfields : rxClassImage.methfields;
            int n5 = rxFieldArray.length;
            n2 = 0;
            while (n5 > 0) {
                rxField = rxFieldArray[n2];
                if (rxField.fieldvisib != 4) {
                    this.registerfield(rxField);
                    if (this.rxt.program.flag.verbose >= 5) {
                        if (n == 1) {
                            ++n3;
                        } else {
                            ++n4;
                        }
                    }
                }
                --n5;
                ++n2;
            }
            ++n;
        }
        if (this.rxt.program.flag.verbose > 3) {
            if (this.rxt.superflag.diag) {
                l2 = System.currentTimeMillis();
            }
            string = "";
            string2 = "    ";
            if (this.rxt.pass < 1) {
                string2 = "";
            }
            if (this.rxt.program.flag.verbose > 4) {
                string2 = "";
                string = " (Visible:";
                string = n3 == 0 ? String.valueOf(string) + " " + "no methods" : (n3 == 1 ? String.valueOf(string) + " " + "one method" : String.valueOf(string) + " " + n3 + " " + "methods");
                string = n4 == 0 ? String.valueOf(string) + ", no properties)" : (n4 == 1 ? String.valueOf(string) + ", one property)" : String.valueOf(string) + "," + " " + n4 + " " + "properties)");
            }
            if (this.rxt.superflag.diag) {
                string = String.valueOf(string) + " " + "[" + (l2 - l) + "ms]";
            }
            this.rxt.say(Rexx.toRexx(String.valueOf(string2) + "  Loaded" + " " + rxClassImage.modifiers + " " + "class '").OpCc(null, rxClassInfo.type.classname).OpCc(null, $011).OpCc(null, Rexx.toRexx(string)));
        }
        rxClassImage = null;
    }

    private void packdirfind(String string, Hashtable hashtable) {
        String string2 = null;
        long l = 0L;
        string2 = string.equals("") ? System.getProperty("user.dir") : string;
        File file = new File(string2);
        if (!file.isDirectory()) {
            return;
        }
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# PACKDIRFIND '" + file.getPath() + "' loop start");
            l = System.currentTimeMillis();
        }
        this.packdirsearch(file, "", hashtable, string.length() > 0);
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# PACKDIRFIND loop end after " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    private void packdirsearch(File file, String string, Hashtable hashtable, boolean bl) {
        int n = 0;
        String string2 = null;
        File file2 = null;
        String string3 = null;
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        boolean bl2 = false;
        int n2 = stringArray.length;
        n = 0;
        while (n2 > 0) {
            string2 = stringArray[n];
            if (string2.indexOf(this.dot, 0) >= 0) {
                if (!bl2 && string2.endsWith(".class")) {
                    bl2 = true;
                }
            } else if (bl && string2.indexOf(this.dot, 0) < 0 && (file2 = new File(file, string2)).isDirectory()) {
                string3 = string.length() == 0 ? string2 : String.valueOf(string) + "." + string2;
                this.packdirsearch(file2, string3, hashtable, bl);
            }
            --n2;
            ++n;
        }
        if (bl2 && string.length() != 0) {
            this.addpackage(string, hashtable);
        }
    }

    public RxField registerfield(RxField rxField) {
        int n;
        Rexx rexx = null;
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        Rexx rexx4 = rxField.fieldname.lower();
        rxField.fieldcount = n = rxField.fieldinfo.registerfield(Rexx.toString(rexx4), rxField);
        if (this.rxt.program.flag.verbose > 4 | this.rxt.program.flag.verbose > 3 & this.rxt.superflag.diag) {
            rexx = rxField.fieldinfo.type.classname;
            rexx2 = RxType.toConciseString(this.rxt.program, rxField.fieldargtypes);
            rexx3 = rxField.fieldexcep;
            if (rexx3 != null) {
                rexx2 = rexx2.OpCcblank(null, rexx3);
            }
            this.rxt.say(Rexx.toRexx("    RegisterField(").OpCc(null, rexx).OpCc(null, $026).OpCc(null, rxField.fieldname).OpCc(null, $027).OpCc(null, rexx4).OpCc(null, $04).OpCc(null, new Rexx(n)).OpCc(null, $028).OpCcblank(null, rxField.fieldtype.toSig().OpCcblank(null, this.rxt.program.babel.fieldModifiers(rxField)).OpCcblank(null, rexx2).space()));
        }
        return rxField;
    }

    public RxField registerfield(RxToken rxToken, RxClassInfo rxClassInfo, Rexx rexx, RxType rxType, int n, int n2, RxType[] rxTypeArray, Rexx rexx2) {
        return this.registerfield(rxToken, rxClassInfo, rexx, rxType, n, n2, rxTypeArray, rexx2, null);
    }

    public RxField registerfield(RxToken rxToken, RxClassInfo rxClassInfo, Rexx rexx, RxType rxType, int n, int n2, RxType[] rxTypeArray, Rexx rexx2, RxClauseParser rxClauseParser) {
        if (this.rxt.program.parser != null && this.rxt.program.parser.level > 0 && rxClassInfo.shortname.equals(this.rxt.program.parser.cursor.curclass.classinfo.shortname) && rxClassInfo.packname.equals(this.rxt.program.parser.cursor.curclass.classinfo.packname)) {
            if (this.javakey(Rexx.toString(rexx))) {
                throw new RxQuit(this.rxt, rxToken, "name.is.reserved", rexx);
            }
            if (rexx.left(new Rexx(2)).OpEqS(null, $025) && rxTypeArray == null) {
                throw new RxQuit(this.rxt, rxToken, "name.is.dollar0", rexx);
            }
        }
        RxField rxField = new RxField(this.rxt.program, rxClassInfo, rexx, rxType, n, n2, rxTypeArray, rexx2);
        rxField.fieldlocal = rxClauseParser;
        if (rxClauseParser != null) {
            this.localfields.addElement(rxField);
            rxField.fieldid = this.localfields.size();
        }
        return this.registerfield(rxField);
    }

    public RxClassInfo registerlocalclass(String string, String string2, String string3, RxToken rxToken) {
        String string4 = null;
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# registerlocalclass '" + string + "' '" + string3 + "'");
        }
        this.classpool.invalidatenonlocal(string, string3);
        RxClassInfo rxClassInfo = this.findanyclass(this.rxt.program.parser.cursor, Rexx.toRexx(string2), rxToken);
        RxClassInfo rxClassInfo2 = this.classpool.register(string, string3, null, null, true, null, false);
        rxClassInfo2.loaded = true;
        this.localclasses.addElement(rxClassInfo2);
        rxClassInfo2.classid = this.localclasses.size();
        if (this.rxt.pass0) {
            if (this.javakey(rxClassInfo2.shortname)) {
                throw new RxQuit(this.rxt, rxToken, "name.is.reserved", Rexx.toRexx(rxClassInfo2.shortname));
            }
            if (rxClassInfo2.local) {
                string4 = string.equals("") ? string3 : String.valueOf(string) + "." + string3;
                if (rxClassInfo2.implied) {
                    throw new RxQuit(this.rxt, rxToken, "class.is.implied", Rexx.toRexx(string4));
                }
                throw new RxQuit(this.rxt, rxToken, "class.name.duplicate", Rexx.toRexx(string4));
            }
            if (rxClassInfo != null && rxClassInfo.explicit) {
                throw new RxQuit(this.rxt, rxToken, "class.name.explicit", rxClassInfo.type.classname);
            }
            if (rxToken == null) {
                rxClassInfo2.implied = true;
            }
            rxClassInfo2.local = true;
        }
        return rxClassInfo2;
    }

    private RxField searchfield(RxCursor rxCursor, boolean bl, boolean bl2, boolean bl3, boolean bl4, RxClassInfo rxClassInfo, RxClassInfo rxClassInfo2, Rexx rexx, RxType[] rxTypeArray, RxToken rxToken, boolean bl5, boolean bl6) {
        int n;
        RxClassInfo rxClassInfo3;
        int n2;
        RxField rxField;
        Rexx rexx2;
        RxClassInfo rxClassInfo4;
        block31: {
            RxFlag rxFlag = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            RxField rxField2 = null;
            RxClassInfo rxClassInfo5 = null;
            RxField rxField3 = null;
            RxConvert[] rxConvertArray = null;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            RxConvert[] rxConvertArray2 = null;
            int n10 = 0;
            RxType rxType = null;
            RxType rxType2 = null;
            RxConvert rxConvert = null;
            RxField rxField4 = null;
            Rexx rexx3 = null;
            rxClassInfo4 = null;
            rexx2 = null;
            rxField = null;
            n2 = 0;
            rxClassInfo3 = null;
            rxFlag = rxCursor == null ? this.rxt.superflag : rxCursor.curprogram.flag;
            n3 = rxTypeArray == null ? 0 : rxTypeArray.length;
            Rexx rexx4 = rexx.lower();
            RxField[] rxFieldArray = rxClassInfo2.getfieldarray(Rexx.toString(rexx4));
            if (rxFieldArray == null) break block31;
            n = rxFlag.strictcase ? 1 : 0;
            n4 = 1;
            while (n4 >= n) {
                block36: {
                    int n11;
                    block32: {
                        if (!bl3) break block32;
                        n5 = 0;
                        n11 = rxFieldArray.length;
                        n6 = 0;
                        while (n11 > 0) {
                            block33: {
                                block35: {
                                    block34: {
                                        rxField2 = rxFieldArray[n6];
                                        if (rxField2.isMethod() || new Rexx(n4 & (rexx.OpNotEqS(null, rxField2.fieldname) ? 1 : 0)).toboolean() || n4 == 0 & rexx.OpEqS(null, rxField2.fieldname) || bl4 && !rxField2.isStatic()) break block33;
                                        if (this.accessible(rxCursor, rxClassInfo, rxField2, rxToken)) break block34;
                                        if (bl5) break block33;
                                        rxField2.fieldhidden = rxClassInfo;
                                        break block35;
                                    }
                                    if (rxCursor == null || rxClassInfo == (rxClassInfo5 = rxCursor.curclass.classinfo) || this.accessible(rxCursor, rxClassInfo5, rxField2, rxToken)) break block35;
                                    if (bl5) break block33;
                                    rxField2.fieldhidden = rxClassInfo5;
                                }
                                if (++n5 > 1) break;
                                rxField3 = rxField2;
                            }
                            --n11;
                            ++n6;
                        }
                        if (n5 > 0) {
                            rxField2 = rxField3;
                            boolean bl7 = rxField2.fieldambig = n5 > 1;
                            if (rxFlag.diag) {
                                RexxIO.Say($017.OpCcblank(null, rxField2.fieldname).OpCcblank(null, $018).OpCcblank(null, rxField2.fieldtype.toSig()).OpCc(null, $019).OpCcblank(null, $020).OpCcblank(null, rxField2.fieldinfo.type.classname).OpCcblank(null, $06).OpCc(null, new Rexx(rxField2.isMethod())).OpCcblank(null, new Rexx(rxField2.fieldvisib)).OpCcblank(null, new Rexx(rxField2.fieldatts)).OpCc(null, $07));
                                if (rxField2.fieldambig) {
                                    RexxIO.Say("# Ambiguous");
                                }
                            }
                            return rxField2;
                        }
                    }
                    if (!bl2) break block36;
                    rxConvertArray = null;
                    n7 = 999999999;
                    n8 = 0;
                    n11 = rxFieldArray.length;
                    n6 = 0;
                    while (n11 > 0) {
                        block30: {
                            block38: {
                                block37: {
                                    rxField2 = rxFieldArray[n6];
                                    if (!rxField2.isMethod() || bl3 && rxField2.isConstructor() || new Rexx(n4 & (rexx.OpNotEqS(null, rxField2.fieldname) ? 1 : 0)).toboolean() || n4 == 0 & rexx.OpEqS(null, rxField2.fieldname) || bl4 && !rxField2.isStatic() || rxField2.fieldargtypes.length != n3) break block30;
                                    if (this.accessible(rxCursor, rxClassInfo, rxField2, rxToken)) break block37;
                                    if (bl5) break block30;
                                    rxField2.fieldhidden = rxClassInfo;
                                    break block38;
                                }
                                if (rxCursor == null || rxClassInfo == (rxClassInfo5 = rxCursor.curclass.classinfo) || this.accessible(rxCursor, rxClassInfo5, rxField2, rxToken)) break block38;
                                if (bl5) break block30;
                                rxField2.fieldhidden = rxClassInfo5;
                            }
                            n9 = 0;
                            rxConvertArray2 = new RxConvert[n3];
                            int n12 = n3;
                            n10 = 0;
                            while (n12 > 0) {
                                rxType = rxField2.fieldargtypes[n10];
                                rxType2 = rxTypeArray[n10];
                                rxConvert = this.rxt.converter.assigncost(rxCursor, rxType, rxType2);
                                if (rxConvert.cost <= rxFlag.maxassign && (n9 += rxConvert.cost) <= n7) {
                                    rxConvertArray2[n10] = rxConvert;
                                    --n12;
                                    ++n10;
                                    continue;
                                }
                                break block30;
                            }
                            if (n9 < n7) {
                                n8 = 1;
                                rxField4 = rxField2;
                                n7 = n9;
                                rxConvertArray = rxConvertArray2;
                                if (n9 == 0 && new Rexx(n4).toboolean()) {
                                    break;
                                }
                            } else {
                                ++n8;
                                rxField4 = rxField2;
                                if (n9 == 0) break;
                            }
                        }
                        --n11;
                        ++n6;
                    }
                    if (n8 > 0) {
                        rxField2 = rxField4;
                        rxField2.fieldcost = n7;
                        if (n8 == 1) {
                            rxField2.fieldambig = false;
                            rxField2.fieldconvert = rxConvertArray;
                        } else {
                            rxField2.fieldambig = true;
                            rxField2.fieldconvert = null;
                        }
                        if (rxFlag.diag) {
                            rexx3 = this.argtlist(rxField2.fieldargtypes);
                            RexxIO.Say($021.OpCcblank(null, rxField2.fieldname).OpCc(null, $014).OpCc(null, rexx3).OpCc(null, $022).OpCcblank(null, rxField2.fieldtype.toSig()).OpCcblank(null, $023).OpCcblank(null, rxField2.fieldinfo.type.classname).OpCcblank(null, $06).OpCc(null, new Rexx(n7)).OpCc(null, $07));
                            if (rxField2.fieldexcep != null) {
                                RexxIO.Say($024.OpCcblank(null, rxField2.fieldexcep));
                            }
                            if (rxField2.fieldambig) {
                                RexxIO.Say("# Ambiguous");
                            }
                        }
                        return rxField2;
                    }
                }
                --n4;
            }
        }
        if (bl) {
            return null;
        }
        if (bl6) {
            return null;
        }
        rxClassInfo4 = rxClassInfo2.isinterface ? null : rxClassInfo2.superinfo;
        if (rxClassInfo4 != null && (rxField = this.searchfield(rxCursor, false, bl2, bl3, bl4, rxClassInfo, rxClassInfo4, rexx2 = rexx, rxTypeArray, rxToken, bl5, bl6)) != null) {
            return rxField;
        }
        if (rxClassInfo2.impinfos == null) {
            this.findimps(rxCursor, rxClassInfo2, rxToken);
        }
        n = rxClassInfo2.impinfos.length;
        n2 = 0;
        while (n > 0) {
            rxClassInfo3 = rxClassInfo2.impinfos[n2];
            rxField = this.searchfield(rxCursor, false, bl2, bl3, bl4, rxClassInfo, rxClassInfo3, rexx, rxTypeArray, rxToken, bl5, bl6);
            if (rxField != null) {
                return rxField;
            }
            --n;
            ++n2;
        }
        return null;
    }

    private boolean testsubclass(RxCursor rxCursor, RxClassInfo rxClassInfo, RxClassInfo rxClassInfo2, RxToken rxToken, RxType rxType) {
        block7: {
            int n = 0;
            RxClassInfo rxClassInfo3 = null;
            RxType rxType2 = rxClassInfo.type;
            RxType rxType3 = rxClassInfo2.type;
            if (rxType == null) {
                rxType = rxType2;
            }
            Rexx rexx = rxType.classname;
            do {
                if (rxType2.equals(rxType3)) {
                    return true;
                }
                if (rxClassInfo.impinfos == null) {
                    this.findimps(rxCursor, rxClassInfo, rxToken);
                }
                int n2 = rxClassInfo.impinfos.length;
                n = 0;
                while (n2 > 0) {
                    rxClassInfo3 = rxClassInfo.impinfos[n];
                    if (rxClassInfo3.type.classname.OpEqS(null, rexx)) {
                        throw new RxQuit(this.rxt, rxToken, "class.implements.cycle");
                    }
                    if (this.testsubclass(rxCursor, rxClassInfo3, rxClassInfo2, rxToken, rxType)) {
                        return true;
                    }
                    --n2;
                    ++n;
                }
                if (rxType2.equals(RxTranslator.objecttype) || (rxClassInfo = rxClassInfo.superinfo) == null) break block7;
                rxType2 = rxClassInfo.type;
            } while (!rxClassInfo.type.classname.OpEqS(null, rexx));
            throw new RxQuit(this.rxt, rxToken, "class.superclass.cycle");
        }
        return false;
    }

    public Vector unimplemented(RxCursor rxCursor, RxClassInfo rxClassInfo, RxClassInfo rxClassInfo2) {
        int n;
        Object object = null;
        String string = null;
        RxField[] rxFieldArray = null;
        int n2 = 0;
        RxField rxField = null;
        RxField rxField2 = null;
        boolean bl = false;
        Vector<RxField> vector = new Vector<RxField>(10);
        if (rxClassInfo2.fields == null) {
            return vector;
        }
        Hashtable hashtable = rxClassInfo2.fields;
        Object[] objectArray = new Object[hashtable.size()];
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            for (n = 0; n != objectArray.length; ++n) {
                objectArray[n] = enumeration.nextElement();
            }
        }
        while (--n >= 0) {
            object = objectArray[n];
            string = (String)object;
            rxFieldArray = rxClassInfo2.getfieldarray(string);
            int n3 = rxFieldArray.length;
            n2 = 0;
            while (n3 > 0) {
                rxField = rxFieldArray[n2];
                if (rxField.isMethod() && rxField.isAbstract() && (bl = (rxField2 = this.findfield(rxCursor, false, true, false, false, rxClassInfo, rxField.fieldname, rxField.fieldargtypes, null)) == null ? true : (rxField2.isAbstract() ? true : !rxField2.fieldtype.equals(rxField.fieldtype)))) {
                    vector.addElement(rxField);
                }
                --n3;
                ++n2;
            }
        }
        return vector;
    }

    void warndep(RxToken rxToken, RxClassInfo rxClassInfo) {
        if (this.rxt.deprecateds.containsKey(rxClassInfo)) {
            return;
        }
        new RxWarn(this.rxt, rxToken, "deprecated.class", rxClassInfo.type.classname);
        this.rxt.deprecateds.put(rxClassInfo, rxClassInfo);
    }

    void warndep(RxToken rxToken, RxField rxField) {
        if (this.rxt.deprecateds.containsKey(rxField)) {
            return;
        }
        if (rxField.isMethod()) {
            if (rxField.isConstructor()) {
                new RxWarn(this.rxt, rxToken, "deprecated.constructor", Rexx.toRexx(rxField.toConciseString(this.rxt.program)));
            } else {
                new RxWarn(this.rxt, rxToken, "deprecated.method", Rexx.toRexx(rxField.toConciseString(this.rxt.program)));
            }
        } else {
            new RxWarn(this.rxt, rxToken, "deprecated.property", Rexx.toRexx(rxField.toConciseString(this.rxt.program)));
        }
        this.rxt.deprecateds.put(rxField, rxField);
    }

    private int zipfind(ZipFile zipFile, String string, String string2, boolean bl, RxProgram rxProgram, boolean bl2, Hashtable hashtable) {
        boolean bl3 = false;
        long l = 0L;
        ZipEntry zipEntry = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        String string4 = null;
        String string5 = null;
        int n3 = 0;
        int n4 = 0;
        RxClassInfo rxClassInfo = null;
        String string6 = null;
        if (string2 == null) {
            bl3 = false;
        } else {
            bl3 = string2.equals("*");
            if (!bl3) {
                string6 = string2.replace('.', '$');
            }
        }
        boolean bl4 = string6 != null;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        int n5 = 0;
        int n6 = string.length();
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# ZIPFIND '" + zipFile.getName() + "' loop start:" + " " + string + " " + (bl3 ? "1" : "0"));
            l = System.currentTimeMillis();
        }
        String string7 = "";
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            string3 = zipEntry.getName();
            if (!string3.startsWith(".class", (n = string3.length()) - 6)) continue;
            n2 = string3.lastIndexOf(this.zsep, n - 1);
            string4 = string3.substring(n2 + 1, n - 6);
            if (bl4 && !string4.equals(string6) && (this.rxt.program.flag.strictcase || !string4.equalsIgnoreCase(string6))) continue;
            if (n2 < 1) {
                string5 = "";
                n3 = 0;
            } else {
                string5 = string3.substring(0, n2).replace(this.zsep, '.');
                n3 = n2;
            }
            if (bl3) {
                if (!string5.equals(string7) && n3 != 0) {
                    this.addpackage(string5, hashtable);
                    string7 = string5;
                }
                int n7 = this.standpacks.length;
                n4 = 0;
                while (n7 > 0) {
                    if (string5.startsWith(this.standpacks[n4], 0)) break;
                    --n7;
                    ++n4;
                }
                if (n4 == this.standpacks.length) {
                    continue;
                }
            } else if (!string5.equals(string) && (!bl2 || !string5.startsWith(string, 0) || string5.charAt(n6) != '.')) continue;
            rxClassInfo = this.classpool.register(string5, string4, zipFile, zipEntry, bl, rxProgram, bl4);
            if (rxProgram != null) {
                this.importclasses.addElement(rxClassInfo);
            }
            ++n5;
            if (!bl4) continue;
        }
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# ZIPFIND loop end with [" + n5 + "] after" + " " + (System.currentTimeMillis() - l) + "ms");
        }
        return n5;
    }
}

