/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netrexx.process;

import COM.ibm.netrexx.process.RxProgram;
import COM.ibm.netrexx.process.RxTranslator;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;

public class RxType {
    private static final Rexx $01 = new Rexx('.');
    private static final Rexx $02 = new Rexx('[');
    private static final Rexx $03 = new Rexx(']');
    private static final Rexx $04 = new Rexx('L');
    private static final Rexx $05 = new Rexx(';');
    private static final Rexx $06 = new Rexx(',');
    private static final String $0 = "RxType.nrx";
    public Rexx classname;
    public int dimension = 0;
    private Rexx packagename;
    private Rexx classfilename;
    private Class ourclass;
    private boolean primitive;
    private boolean hadprimitive;

    public RxType(Rexx rexx, int n) {
        this.dimension = n;
        this.split(rexx);
    }

    public RxType(Rexx rexx, Rexx rexx2, int n) {
        this.packagename = rexx;
        this.classfilename = rexx2.changestr(new Rexx('.'), new Rexx('$'));
        this.dimension = n;
        this.classname = rexx == null ? rexx2 : rexx.OpCc(null, $01).OpCc(null, rexx2);
    }

    public RxType basetype() {
        return this.basetype(0);
    }

    public RxType basetype(int n) {
        return new RxType(this.packagename, this.classfilename.changestr(new Rexx('$'), new Rexx('.')), n);
    }

    public boolean equals(Object object) {
        RxType rxType = (RxType)object;
        if (this.dimension != rxType.dimension) {
            return false;
        }
        return this.classname.OpEqS(null, rxType.classname);
    }

    public Rexx getClassFileName() {
        return this.classfilename;
    }

    public Rexx getClassName() {
        return this.classfilename.changestr(new Rexx('$'), new Rexx('.'));
    }

    public Class getClassObject() {
        return this.getClassObject(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class getClassObject(ClassLoader classLoader) {
        String string = null;
        if (this.ourclass != null) return this.ourclass;
        if (this.isprimitive()) {
            if (this.classname.OpEqS(null, Rexx.toRexx("int"))) {
                this.ourclass = Integer.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("byte"))) {
                this.ourclass = Byte.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("short"))) {
                this.ourclass = Short.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("long"))) {
                this.ourclass = Long.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("char"))) {
                this.ourclass = Character.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("float"))) {
                this.ourclass = Float.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("double"))) {
                this.ourclass = Double.TYPE;
                return this.ourclass;
            } else {
                if (!this.classname.OpEqS(null, Rexx.toRexx("boolean"))) throw new NoOtherwiseException();
                this.ourclass = Boolean.TYPE;
            }
            return this.ourclass;
        }
        try {
            string = this.dimension == 0 ? (this.packagename == null ? Rexx.toString(this.classfilename) : Rexx.toString(this.packagename.OpCc(null, $01).OpCc(null, this.classfilename))) : this.toJavaSig();
            if (classLoader == null) {
                this.ourclass = Class.forName(string);
                return this.ourclass;
            }
            this.ourclass = Class.forName(string, true, classLoader);
            return this.ourclass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.ourclass = null;
        }
        return this.ourclass;
    }

    public Rexx getPackageName() {
        return this.packagename;
    }

    public boolean isarray() {
        return this.dimension > 0;
    }

    public boolean isbaseprimitive() {
        if (this.packagename != null) {
            return false;
        }
        if (this.classname.length().toint() > 7) {
            return false;
        }
        return RxTranslator.primitives.wordpos(this.classname, new Rexx(1)).toint() > 0;
    }

    public boolean isnull() {
        if (this.classname.length().toint() != 4) {
            return false;
        }
        if (this.dimension > 0) {
            return false;
        }
        return this.classname.OpEqS(null, RxTranslator.nullclass);
    }

    public boolean isprimitive() {
        if (!this.hadprimitive) {
            if (this.dimension == 0) {
                this.primitive = this.isbaseprimitive();
            }
            this.hadprimitive = true;
        }
        return this.primitive;
    }

    private void split(Rexx rexx) {
        int n = rexx.lastpos(new Rexx('.')).toint();
        if (n == 0) {
            this.classfilename = rexx;
            this.packagename = null;
            this.classname = rexx.changestr(new Rexx('$'), new Rexx('.'));
        } else {
            this.classfilename = rexx.substr(new Rexx(n + 1));
            this.packagename = rexx.left(new Rexx(n - 1));
            this.classname = this.packagename.OpCc(null, $01).OpCc(null, this.classfilename.changestr(new Rexx('$'), new Rexx('.')));
        }
    }

    public static Rexx toConciseString(RxProgram rxProgram, RxType[] rxTypeArray) {
        int n = 0;
        Rexx rexx = Rexx.toRexx("");
        if (rxTypeArray != null) {
            int n2 = rxTypeArray.length;
            n = 0;
            while (n2 > 0) {
                if (n > 0) {
                    rexx = rexx.OpCc(null, $06);
                }
                rexx = rexx.OpCc(null, rxProgram.babel.typeConcise(rxTypeArray[n]));
                --n2;
                ++n;
            }
        }
        return rexx;
    }

    public Rexx toJava() {
        if (this.dimension == 0) {
            return this.classname;
        }
        return this.classname.OpCc(null, $02).OpCc(null, Rexx.toRexx("][").copies(new Rexx(this.dimension - 1))).OpCc(null, $03);
    }

    public String toJavaSig() {
        int n = 0;
        Rexx rexx = null;
        n = this.packagename != null || this.classname.length().toint() > 7 ? 0 : RxTranslator.primitives.wordpos(this.classname, new Rexx(1)).toint();
        rexx = n == 0 ? (this.packagename == null ? $04.OpCc(null, this.classfilename).OpCc(null, $05) : $04.OpCc(null, this.packagename).OpCc(null, $01).OpCc(null, this.classfilename).OpCc(null, $05)) : RxTranslator.primitivesigs.word(new Rexx(n));
        if (this.dimension > 0) {
            return Rexx.toString(new Rexx('[').copies(new Rexx(this.dimension)).OpCc(null, rexx));
        }
        return Rexx.toString(rexx);
    }

    public static Rexx toJavaString(RxTranslator rxTranslator, RxType[] rxTypeArray) {
        int n = 0;
        Rexx rexx = Rexx.toRexx("");
        if (rxTypeArray != null) {
            int n2 = rxTypeArray.length;
            n = 0;
            while (n2 > 0) {
                if (n > 0) {
                    rexx = rexx.OpCc(null, $06);
                }
                rexx = rexx.OpCc(null, rxTypeArray[n].toJava());
                --n2;
                ++n;
            }
        }
        return rexx;
    }

    public Rexx toSig() {
        if (this.dimension == 0) {
            return this.classname;
        }
        return this.classname.OpCc(null, $02).OpCc(null, new Rexx(',').copies(new Rexx(this.dimension - 1))).OpCc(null, $03);
    }

    public String toString() {
        return this.toSig().toString();
    }

    public String toString(RxProgram rxProgram) {
        return Rexx.toString(rxProgram.babel.typeString(this));
    }

    public static Rexx toString(RxProgram rxProgram, RxType[] rxTypeArray) {
        int n = 0;
        Rexx rexx = Rexx.toRexx("");
        if (rxTypeArray != null) {
            int n2 = rxTypeArray.length;
            n = 0;
            while (n2 > 0) {
                if (n > 0) {
                    rexx = rexx.OpCc(null, $06);
                }
                rexx = rexx.OpCc(null, rxProgram.babel.typeString(rxTypeArray[n]));
                --n2;
                ++n;
            }
        }
        return rexx;
    }
}

