# OpenVerse InitMainWindow
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Init Main Window Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Main Module
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

#NOTE
#
# Now using curley braces arounf functions for increased speed.

source "$MV(libdir)/Passage.tcl"
source "$MV(libdir)/Objects.tcl"
source "$MV(libdir)/SetFuncs.tcl"
source "$MV(libdir)/Avatars.tcl"
source "$MV(libdir)/ChtFuncs.tcl"
source "$MV(libdir)/AvEd.tcl"
source "$MV(libdir)/URL.tcl"
source "$MV(libdir)/Bubble.tcl"
source "$MV(libdir)/tkohlp.tcl"
source "$MV(libdir)/ServGUI.tcl"
source "$MV(libdir)/Debug.tcl"

set MV(default_host) "$MV(roomhost)"
set MV(default_port) "$MV(roomport)"
if ![file exists "$MV(configfile)"] {
	Setup
	set MV($MV(nick).haschat) 0
	set MV($MV(nick).chatque) {}
} else {
	source "$MV(configfile)"
}

# Always source the english file first! this is the default.
# 
source [file nativename "$MV(libbase)/language/English"]
if {[string compare $MV(language) "English"]} {
        source [file nativename "$MV(libbase)/language/$MV(language)"]
}


set MV($MV(nick).haschat) 0
set MV($MV(nick).moving) 0
set MV($MV(nick).chatque) {}
set MV($MV(nick).moves) {}

wm title . [Trns welcome_msg]
wm resizable . 0 0

image create photo OpenVerse_Image_room -file "$MV(roomdir)/room.gif"

frame .menu 
frame .top -relief sunken -borderwidth 2
canvas .top.c -height 480.0 -width 640.0
pack .menu -side top -fill both -expand y 
pack .top -fill both -expand y
pack .top.c
.top.c create image 320 240 -image OpenVerse_Image_room

#
# Panel Initalization
#

source "$MV(homedir)/panels/$MV(panel)"
#
# Quick Keys!
#
proc QuickKeys { window } {
	global MV
	bind $window <Alt-a> {if $MV(anim.stop) {set MV(anim.stop) 0} else {set MV(anim.stop) 1;AnimateAvatar}}
	bind $window <Alt-d> {ToggleDebug}
	bind $window <Alt-e> {AvEd}
	bind $window <Alt-h> "source \"$MV(helpdir)/$MV(help.file.main)\""
	bind $window <Alt-n> {if $MV(names) {set MV(names) 0} else {set MV(names) 1};ShowNames}
	bind $window <Alt-s> {if $MV(bell) {set MV(bell) 0} else {set MV(bell) 1}}
	# generates an error of you try and toggle within textchat
	if {[string compare $window ".chat"] != 0} {
		bind $window <Alt-t> {ToggleText}
	}
	bind $window <Alt-s> {StartServer}
	bind $window <Control-k> "$MV(chat_entry) insert end \x03"
}
QuickKeys "."
bind .top.c <Button-1> {MoveTo %x %y 0}
bind .top.c <Button-3> {RightClick %x %y %X %Y}

if {[file exists "$MV(images)/$MV(avatar)"]} {
	image create photo OpenVerse_Image_pic -file "$MV(images)/$MV(avatar)"
} else {
	image create photo OpenVerse_Image_pic -file "$MV(images)/default.gif"
}
AnimateMe "$MV(anim)" 3
set MV(img) [.top.c create image 320 200 -image OpenVerse_Image_pic]
#if $MV(names) {ShowName $MV(nick)}

# Done with OpenVerse initalization. Init external plugins.
source "$MV(libdir)/Plugin.tcl"

# Some final things to do before we exit.
#
# Delete old images from the remote images directory.
#
foreach file  [List_Rimages] {
	if {[expr [clock seconds] - [file atime $file]] > [expr $MV(keep_images) * 64800]} {
		catch {file delete $file}
	}
}

CheckTimeouts

if {[string compare $argv ""] == 0 && $MV(connect_on_startup)} {
	ConnectToRoom $MV(roomhost) $MV(roomport)
}
