/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class GDirectionButton
extends Canvas {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    int direction;
    int margin;
    boolean pressed = false;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;

    public GDirectionButton() {
        this(0);
    }

    public GDirectionButton(int n) {
        this.direction = n;
        this.margin = 2;
    }

    public void setDirection(int n) {
        if (this.direction != n) {
            this.direction = n;
            this.repaint();
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 7, dimension.height + 7);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 3, dimension.height + 3);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.paintArrow(this.offgraphics);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private void paintArrow(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.margin = dimension.width / 6;
        if (this.margin < 2) {
            this.margin = 2;
        }
        if (this.pressed) {
            graphics.setColor(Color.darkGray);
        } else {
            graphics.setColor(Color.lightGray);
        }
        boolean bl = true;
        if (this.pressed) {
            bl = false;
        }
        graphics.fill3DRect(0, 0, dimension.width, dimension.height, bl);
        Polygon polygon = new Polygon();
        switch (this.direction) {
            case 0: {
                polygon.addPoint(this.margin, dimension.height / 2);
                polygon.addPoint(dimension.width - this.margin, this.margin);
                polygon.addPoint(dimension.width - this.margin, dimension.height - this.margin);
                break;
            }
            case 1: {
                polygon.addPoint(dimension.width - this.margin, dimension.height / 2);
                polygon.addPoint(this.margin, this.margin);
                polygon.addPoint(this.margin, dimension.height - this.margin);
                break;
            }
            case 2: {
                polygon.addPoint(dimension.width / 2, this.margin);
                polygon.addPoint(this.margin, dimension.height - this.margin);
                polygon.addPoint(dimension.width - this.margin, dimension.height - this.margin);
                break;
            }
            case 3: {
                polygon.addPoint(dimension.width / 2, dimension.height - this.margin);
                polygon.addPoint(this.margin, this.margin);
                polygon.addPoint(dimension.width - this.margin, this.margin);
                break;
            }
        }
        if (this.pressed) {
            graphics.setColor(Color.lightGray);
        } else {
            graphics.setColor(Color.darkGray);
        }
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width, dimension.height);
    }

    public void setPressed(boolean bl) {
        this.pressed = bl;
    }
}

