/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class GScroll
extends Panel {
    static final int NORMAL = 0;
    static final int SLIDER = 1;
    GDirectionButton sbtn;
    GDirectionButton lbtn;
    GSCanvas scanvas;
    boolean fComponentsAdjusted = false;
    int mode;
    int unitincrement;
    ScrollBoss boss;
    int dragoffset = 0;
    static final int busize = 15;
    static final int slidersize = 10;
    int type;

    GScroll(ScrollBoss scrollBoss, int n) {
        this.setVars(scrollBoss, n, 0);
    }

    GScroll(ScrollBoss scrollBoss, int n, int n2) {
        this.setVars(scrollBoss, n, n2);
    }

    private void setVars(ScrollBoss scrollBoss, int n, int n2) {
        this.type = n2;
        this.boss = scrollBoss;
        this.mode = n;
        this.setLayout(null);
        if (this.type == 0) {
            this.scanvas = new GSCanvas(this, 15, this.mode);
        } else if (this.type == 1) {
            this.scanvas = new GSCanvas(this, 10, this.mode);
        }
        if (this.mode == 0) {
            this.sbtn = new GDirectionButton(0);
            this.lbtn = new GDirectionButton(1);
        } else {
            this.sbtn = new GDirectionButton(2);
            this.lbtn = new GDirectionButton(3);
        }
        if (this.type == 0) {
            if (this.mode == 0) {
                this.add("East", this.lbtn);
                this.add("West", this.sbtn);
                this.add("Center", this.scanvas);
            } else if (this.mode == 1) {
                this.add("South", this.lbtn);
                this.add("North", this.sbtn);
                this.add("Center", this.scanvas);
            }
        } else if (this.type == 1) {
            this.add("Center", this.scanvas);
        }
        SymMouse symMouse = new SymMouse();
        this.sbtn.addMouseListener(symMouse);
        this.lbtn.addMouseListener(symMouse);
        this.scanvas.addMouseListener(symMouse);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.scanvas.addMouseMotionListener(symMouseMotion);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.mode == 0) {
            this.sbtn.setBounds(0, 0, 15, 15);
            this.scanvas.setBounds(15, 0, n3 - 30, 15);
            this.lbtn.setBounds(n3 - 15, 0, 15, 15);
        } else {
            this.sbtn.setBounds(0, 0, 15, 15);
            this.scanvas.setBounds(0, 15, 15, n4 - 30);
            this.lbtn.setBounds(0, n4 - 15, 15, 15);
        }
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.scanvas.setValues(n, n2, n3, n4);
    }

    public int getValue() {
        return this.scanvas.getValue();
    }

    public void setUnitIncrement(int n) {
        this.unitincrement = n;
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        if (this.mode == 0) {
            return new Dimension(Math.max(dimension.width, 60), Math.max(dimension.height, 15));
        }
        return new Dimension(Math.max(dimension.width, 15), Math.max(dimension.height, 60));
    }

    public Dimension getMinimumSize() {
        if (this.mode == 0) {
            return new Dimension(60, 15);
        }
        return new Dimension(15, 60);
    }

    public int getType() {
        return this.type;
    }

    void GScroll_MouseReleased(GDirectionButton gDirectionButton, int n) {
        gDirectionButton.setPressed(false);
        gDirectionButton.repaint();
        this.scanvas.setChangeValue(n);
        this.scanvas.repaint();
    }

    void GScroll_MouseReleasedOnCV(MouseEvent mouseEvent) {
        if (this.scanvas.getDragMode()) {
            this.scanvas.confirmValue();
            this.scanvas.setDragMode(false);
            this.scanvas.repaint();
        } else {
            int n = mouseEvent.getX();
            if (this.mode == 1) {
                n = mouseEvent.getY();
            }
            this.scanvas.chgBlockValue(n);
            this.scanvas.repaint();
        }
    }

    void GScroll_MousePressedOnCV(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (this.mode == 1) {
            n = mouseEvent.getY();
        }
        if (this.scanvas.isOnMarker(n)) {
            this.scanvas.setDragMode(true);
            this.dragoffset = this.scanvas.getBarX() - n;
        } else {
            this.scanvas.setDragMode(false);
        }
    }

    void GScroll_MouseDragged(MouseEvent mouseEvent) {
        if (!this.scanvas.getDragMode()) {
            return;
        }
        int n = mouseEvent.getX();
        if (this.mode == 1) {
            n = mouseEvent.getY();
        }
        this.scanvas.setTempValue(n + this.dragoffset);
        this.scanvas.repaint();
        if (this.type == 1) {
            this.scanvas.confirmValue();
            this.boss.changeScroll(this.scanvas.getValue(), this.mode);
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == GScroll.this.sbtn) {
                GScroll.this.GScroll_MouseReleased(GScroll.this.sbtn, -1 * GScroll.this.unitincrement);
            } else if (object == GScroll.this.lbtn) {
                GScroll.this.GScroll_MouseReleased(GScroll.this.lbtn, GScroll.this.unitincrement);
            } else if (object == GScroll.this.scanvas) {
                GScroll.this.GScroll_MouseReleasedOnCV(mouseEvent);
            }
            GScroll.this.boss.changeScroll(GScroll.this.scanvas.getValue(), GScroll.this.mode);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == GScroll.this.scanvas) {
                GScroll.this.GScroll_MousePressedOnCV(mouseEvent);
            } else if (object == GScroll.this.sbtn) {
                GScroll.this.sbtn.setPressed(true);
                GScroll.this.sbtn.repaint();
            } else if (object == GScroll.this.lbtn) {
                GScroll.this.lbtn.setPressed(true);
                GScroll.this.lbtn.repaint();
            }
        }

        SymMouse() {
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == GScroll.this.scanvas) {
                GScroll.this.GScroll_MouseDragged(mouseEvent);
            }
        }

        SymMouseMotion() {
        }
    }
}

