/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ListDialog
extends Dialog {
    List datalist;
    Button okButton;
    Button cancelButton;
    Button addButton;
    Button deleteButton;
    Button changeNameButton;
    Panel sidePanel;
    Label strlabel;
    TextField inputtext;
    Button acceptButton;
    TextArea dataText;
    Choice colorChoice;
    SETISupport boss;
    Vector cvect = new Vector();
    DirData selectedItem;
    int dispmode;
    boolean fComponentsAdjusted = false;

    public ListDialog(Frame frame, String string, int n) {
        super(frame, string);
        Object object;
        this.boss = (SETISupport)frame;
        int n2 = 450;
        int n3 = 0;
        if (n == 0) {
            n3 = 180;
        } else if (n == 1) {
            n3 = 220;
        } else if (n == 2) {
            n3 = 180;
            n2 = 500;
        }
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(n2, n3);
        ((Component)this).setBackground(Color.black);
        this.datalist = new List(4, false);
        this.datalist.setBackground(Color.black);
        this.datalist.setForeground(Color.cyan);
        this.datalist.setSize(n2, (int)((double)n3 * 0.3));
        if (n == 0 || n == 2) {
            this.add("Center", this.datalist);
        } else if (n == 1) {
            this.add("North", this.datalist);
        }
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        panel.setBackground(Color.black);
        this.add("South", panel);
        if (n == 0 || n == 2) {
            object = new Panel();
            ((Component)object).setBackground(Color.black);
            ((Container)object).setLayout(new FlowLayout(0));
            panel.add("North", (Component)object);
            this.strlabel = new Label("Input Short Name");
            ((Container)object).add(this.strlabel);
            this.strlabel.setVisible(false);
            this.strlabel.setForeground(Color.pink);
            this.strlabel.setBackground(Color.black);
            this.inputtext = new TextField(8);
            ((Container)object).add(this.inputtext);
            this.inputtext.setVisible(false);
            this.inputtext.setForeground(Color.pink);
            ((Component)this.inputtext).setBackground(Color.black);
            this.acceptButton = new Button("Accept");
            this.acceptButton.setBackground(Color.white);
            this.acceptButton.setForeground(Color.black);
            ((Container)object).add(this.acceptButton);
            this.acceptButton.setVisible(false);
            if (n == 2) {
                this.colorChoice = new Choice();
                this.colorChoice.setBackground(Color.white);
                this.colorChoice.setForeground(Color.black);
                panel.add("Center", this.colorChoice);
                this.colorChoice.add("Yellow");
                this.colorChoice.add("LightBlue");
                this.colorChoice.add("Green");
                this.colorChoice.add("Orange");
                this.colorChoice.add("Pink");
                this.colorChoice.add("Red");
                this.colorChoice.add("White");
            }
        } else {
            this.dataText = new TextArea();
            this.dataText.setSize(n2, (int)((double)n3 * 0.7));
            ((Component)this.dataText).setBackground(Color.black);
            this.dataText.setForeground(Color.pink);
            this.add("Center", this.dataText);
        }
        this.sidePanel = new Panel();
        this.sidePanel.setLayout(new FlowLayout(0, 3, 3));
        this.sidePanel.setForeground(Color.black);
        panel.add("South", this.sidePanel);
        this.addButton = new Button("Add..");
        this.addButton.setBackground(Color.white);
        this.addButton.setForeground(Color.black);
        this.deleteButton = new Button("Delete");
        this.deleteButton.setForeground(Color.black);
        this.deleteButton.setBackground(Color.white);
        this.changeNameButton = new Button("Change Name..");
        this.changeNameButton.setForeground(Color.black);
        this.changeNameButton.setBackground(Color.white);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.setForeground(Color.black);
        this.cancelButton.setBackground(Color.white);
        this.okButton = new Button("OK");
        this.okButton.setForeground(Color.black);
        this.okButton.setBackground(Color.white);
        if (n == 0 || n == 2) {
            this.sidePanel.add(this.addButton);
            this.sidePanel.add(this.deleteButton);
            this.sidePanel.add(this.changeNameButton);
        }
        this.sidePanel.add(this.okButton);
        if (n == 0 || n == 2) {
            this.sidePanel.add(this.cancelButton);
        }
        object = new SymWindow();
        this.addWindowListener((WindowListener)object);
        SymAction symAction = new SymAction();
        this.okButton.addActionListener(symAction);
        if (n == 0 || n == 2) {
            this.cancelButton.addActionListener(symAction);
            this.addButton.addActionListener(symAction);
            this.deleteButton.addActionListener(symAction);
            this.changeNameButton.addActionListener(symAction);
            this.acceptButton.addActionListener(symAction);
        }
        SymItem symItem = new SymItem();
        this.datalist.addItemListener(symItem);
        if (n == 2) {
            this.colorChoice.addItemListener(symItem);
        }
        this.adjustButton();
        this.validate();
        this.doLayout();
    }

    public ListDialog(Frame frame, Vector vector, String string, int n) {
        this(frame, string, n);
        this.dispmode = n;
        int n2 = 0;
        while (n2 < vector.size()) {
            DirData dirData = (DirData)((DirData)vector.elementAt(n2)).clone();
            this.cvect.addElement(dirData);
            ++n2;
        }
        this.setDataList();
    }

    private void setDataList() {
        this.selectedItem = null;
        this.datalist.removeAll();
        int n = 0;
        int n2 = 0;
        while (n2 < this.cvect.size()) {
            DirData dirData = (DirData)this.cvect.elementAt(n2);
            this.datalist.add(String.valueOf(dirData.getShortName()) + " : " + dirData.getDir());
            ResultData resultData = dirData.getProg();
            if (resultData != null && resultData.getSelected()) {
                n = n2;
            }
            ++n2;
        }
        this.adjustButton();
        if (this.dispmode == 1) {
            if (this.datalist.getItemCount() > 0) {
                this.datalist.select(n);
            }
            this.ptChoice_ItemStateChanged(null);
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    void InputDialog_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void okButton_Clicked(ActionEvent actionEvent) {
        if (this.dispmode == 0) {
            this.boss.updateDirData(this.cvect);
        } else if (this.dispmode == 2) {
            this.boss.updatePastDirData(this.cvect);
        }
        this.dispose();
    }

    void addButton_Clicked(ActionEvent actionEvent) {
        DirData dirData = null;
        if (this.dispmode == 0) {
            dirData = this.boss.miOpen_Action(null, this.cvect);
        } else if (this.dispmode == 2) {
            dirData = this.boss.miOpen_Action(null, this.cvect, false);
        }
        if (dirData == null) {
            return;
        }
        this.cvect.addElement(dirData);
        this.setDataList();
    }

    void deleteButton_Clicked(ActionEvent actionEvent) {
        if (this.selectedItem == null) {
            return;
        }
        if (this.dispmode == 2 && this.datalist.getSelectedIndex() == 0) {
            return;
        }
        this.cvect.removeElement(this.selectedItem);
        this.setDataList();
    }

    void acceptButton_Clicked(ActionEvent actionEvent) {
        String string = this.inputtext.getText();
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                bl = false;
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.cvect.size()) {
            DirData dirData = (DirData)this.cvect.elementAt(n2);
            if (dirData != this.selectedItem && string.equals(dirData.getShortName())) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.selectedItem.setShortName(string);
        }
        this.strlabel.setVisible(false);
        this.inputtext.setVisible(false);
        this.acceptButton.setVisible(false);
        this.validate();
        this.doLayout();
        this.setDataList();
    }

    void changeNameButton_Clicked(ActionEvent actionEvent) {
        this.strlabel.setVisible(true);
        this.inputtext.setVisible(true);
        this.acceptButton.setVisible(true);
        ((TextComponent)this.inputtext).setText(this.selectedItem.getShortName());
        this.inputtext.selectAll();
        this.validate();
        this.doLayout();
    }

    void cancelButton_Clicked(ActionEvent actionEvent) {
        this.dispose();
    }

    void colorChoice_ItemStateChanged(ItemEvent itemEvent) {
        if (this.selectedItem == null) {
            return;
        }
        String string = this.colorChoice.getSelectedItem();
        this.selectedItem.setColorName(string);
    }

    void ptChoice_ItemStateChanged(ItemEvent itemEvent) {
        int n = this.datalist.getSelectedIndex();
        this.selectedItem = n >= 0 ? (DirData)this.cvect.elementAt(n) : null;
        if (this.dispmode == 0 || this.dispmode == 2) {
            this.adjustButton();
            if (this.dispmode == 2 && this.selectedItem != null) {
                this.colorChoice.select(this.selectedItem.getColorName());
            }
        } else if (this.dispmode == 1 && this.selectedItem != null) {
            this.dataText.setText(FileAnalyzer.getUserString(this.selectedItem.getDir()));
        }
    }

    private void adjustButton() {
        if (this.selectedItem == null) {
            this.deleteButton.setEnabled(false);
            this.changeNameButton.setEnabled(false);
        } else {
            this.changeNameButton.setEnabled(true);
            if (this.dispmode == 2 && this.datalist.getSelectedIndex() == 0) {
                this.deleteButton.setEnabled(false);
            } else {
                this.deleteButton.setEnabled(true);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == ListDialog.this) {
                ListDialog.this.InputDialog_WindowClosing(windowEvent);
            }
        }

        SymWindow() {
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ListDialog.this.okButton) {
                ListDialog.this.okButton_Clicked(actionEvent);
            } else if (object == ListDialog.this.addButton) {
                ListDialog.this.addButton_Clicked(actionEvent);
            } else if (object == ListDialog.this.deleteButton) {
                ListDialog.this.deleteButton_Clicked(actionEvent);
            } else if (object == ListDialog.this.changeNameButton) {
                ListDialog.this.changeNameButton_Clicked(actionEvent);
            } else if (object == ListDialog.this.cancelButton) {
                ListDialog.this.cancelButton_Clicked(actionEvent);
            } else if (object == ListDialog.this.acceptButton) {
                ListDialog.this.acceptButton_Clicked(actionEvent);
            }
        }

        SymAction() {
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == ListDialog.this.datalist) {
                ListDialog.this.ptChoice_ItemStateChanged(itemEvent);
            } else if (object == ListDialog.this.colorChoice) {
                ListDialog.this.colorChoice_ItemStateChanged(itemEvent);
            }
        }

        SymItem() {
        }
    }
}

