/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class MtxCanvas
extends Canvas {
    MatrixViewer boss;
    Vector datavect;
    Vector titlevect;
    MxPrefValue pref;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    FontMetrics fm;
    FontMetrics boldfm;
    Font font;
    Font boldfont;
    int charHeight;
    int charDescent;
    int charLeading;
    int charAscent;
    int arrowWidth;
    TitleData selectedTd;
    boolean sortRequiredFlag = true;
    boolean cutOffRequiredFlag = true;
    int lineHeight;
    int arrowindex = -1;
    int tindex = 1;
    int dindex = 1;
    int maxTIndex = 0;
    int maxDIndex = 0;
    int tvisible = 0;
    int dvisible = 0;
    int hgap = 4;
    int vgap = 2;
    boolean vfinishflag = true;
    boolean hfinishflag = true;

    public MtxCanvas(MatrixViewer matrixViewer, MxPrefValue mxPrefValue) {
        this.pref = mxPrefValue;
        this.boss = matrixViewer;
        Vector<TitleData> vector = new Vector<TitleData>();
        int n = 0;
        while (n < GLBX.TITLE.length + 1) {
            vector.addElement(null);
            ++n;
        }
        vector.setElementAt(new TitleData("No"), 0);
        Vector vector2 = new Vector();
        this.pref.getTitleVect(vector2);
        Vector vector3 = this.pref.getCondVect();
        int n2 = 0;
        while (n2 < GLBX.TITLE.length) {
            TitleData titleData = new TitleData(GLBX.TITLE[n2]);
            boolean bl = false;
            int n3 = 0;
            while (n3 < vector2.size()) {
                String string = (String)vector2.elementAt(n3);
                boolean bl2 = true;
                if (string.charAt(0) == '*') {
                    bl2 = false;
                    string = string.substring(1);
                }
                if (string.equals(titleData.getTitle())) {
                    vector.setElementAt(titleData, n3);
                    titleData.setVisible(bl2);
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                vector.addElement(titleData);
            }
            int n4 = 0;
            while (n4 < vector3.size()) {
                String string = (String)vector3.elementAt(n4);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(titleData.getTitle())) {
                    titleData.setCutCond(new CutCond(stringTokenizer.nextToken()));
                }
                ++n4;
            }
            ++n2;
        }
        this.titlevect = new Vector();
        int n5 = 0;
        while (n5 < vector.size()) {
            TitleData titleData = (TitleData)vector.elementAt(n5);
            if (titleData != null) {
                this.titlevect.addElement(titleData);
            }
            ++n5;
        }
        this.datavect = new Vector();
        this.tindex = 0;
        this.dindex = 0;
        this.setFont(10);
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
    }

    public void setFont(int n) {
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        this.font = new Font(stringArray[1], 0, n);
        this.boldfont = new Font(stringArray[1], 1, n);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.boldfm = Toolkit.getDefaultToolkit().getFontMetrics(this.boldfont);
        this.charHeight = this.fm.getHeight();
        this.charDescent = this.fm.getDescent();
        this.charAscent = this.fm.getAscent();
        this.charLeading = this.fm.getLeading();
        this.arrowWidth = this.charHeight / 2;
        this.lineHeight = this.charHeight + 2 * this.vgap;
    }

    public void setData(Vector vector) {
        this.datavect.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            ResultData resultData = (ResultData)vector.elementAt(n);
            if (resultData.getFinishedFlag()) {
                this.datavect.addElement(new MxData(n + 1, Integer.toString(n + 1), resultData));
            } else {
                this.datavect.addElement(new MxData(n + 1, "*" + Integer.toString(n + 1), resultData));
            }
            this.sortRequiredFlag = true;
            this.cutOffRequiredFlag = true;
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.cutOffData();
        this.sortData();
        this.handleCutOff();
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.paintData(this.offgraphics);
        graphics.drawImage(this.offscreen, 0, 0, null);
        this.setMaxTDIndex();
        this.boss.resetScrollBar(this.tindex, this.tvisible, 1, this.maxTIndex, this.dindex, this.dvisible, 0, this.maxDIndex);
    }

    private void handleCutOff() {
        TitleData titleData = (TitleData)this.titlevect.elementAt(0);
        if (!titleData.hasCutCond()) {
            return;
        }
        int n = (int)titleData.getCutCond().getVal();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.datavect.size()) {
            MxData mxData = (MxData)this.datavect.elementAt(n3);
            if (mxData.getVisible() && ++n2 > n) {
                mxData.setVisible(false);
            }
            ++n3;
        }
    }

    private int findThOfTd(TitleData titleData) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.titlevect.size()) {
            TitleData titleData2 = (TitleData)this.titlevect.elementAt(n2);
            if (titleData2.getVisible()) {
                if (titleData2 == titleData) {
                    return n;
                }
                ++n;
            }
            ++n2;
        }
        return 0;
    }

    private int findThOfMd(MxData mxData) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.datavect.size()) {
            MxData mxData2 = (MxData)this.datavect.elementAt(n2);
            if (mxData2.getVisible()) {
                if (mxData2 == mxData) {
                    return n;
                }
                ++n;
            }
            ++n2;
        }
        return 0;
    }

    private void setMaxTDIndex() {
        int n = this.getSize().width;
        int n2 = ((TitleData)this.titlevect.elementAt(0)).getWidth();
        TitleData titleData = null;
        int n3 = this.titlevect.size() - 1;
        while (n3 >= 0) {
            TitleData titleData2 = (TitleData)this.titlevect.elementAt(n3);
            if (titleData2.getVisible()) {
                if ((n2 += titleData2.getWidth()) > n) {
                    if (titleData != null) break;
                    titleData = titleData2;
                    break;
                }
                titleData = titleData2;
            }
            --n3;
        }
        this.maxTIndex = this.findThOfTd(titleData);
        int n4 = this.lineHeight;
        MxData mxData = null;
        int n5 = this.datavect.size() - 1;
        while (n5 >= 0) {
            MxData mxData2 = (MxData)this.datavect.elementAt(n5);
            if (mxData2.getVisible()) {
                if ((n4 += this.lineHeight) > this.getSize().height) {
                    if (mxData != null) break;
                    mxData = mxData2;
                    break;
                }
                mxData = mxData2;
            }
            --n5;
        }
        this.maxDIndex = this.findThOfMd(mxData);
    }

    private void paintData(Graphics graphics) {
        this.vfinishflag = true;
        this.hfinishflag = true;
        graphics.setFont(this.font);
        int n = 0;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        boolean bl = true;
        boolean bl2 = true;
        this.tvisible = 0;
        this.dvisible = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.titlevect.size()) {
            block25: {
                TitleData titleData = (TitleData)this.titlevect.elementAt(n5);
                if (!titleData.getVisible() || ++n4 - 1 < this.tindex && n5 != 0) break block25;
                ++this.tvisible;
                int n6 = 0;
                int n7 = 0;
                boolean bl3 = "No".equals(titleData.getTitle());
                int n8 = 0;
                int n9 = this.charLeading + this.charAscent + this.vgap;
                int n10 = 0;
                while (n10 < this.datavect.size() + 1) {
                    block28: {
                        block27: {
                            String string;
                            block26: {
                                string = "";
                                if (n10 != 0) break block26;
                                string = titleData.getTitle();
                                if (titleData.hasCutCond()) {
                                    string = "[" + string + "]";
                                }
                                n7 = this.fm.stringWidth(string);
                                if (titleData.getTitle().equals(this.pref.getSortTitle())) {
                                    n7 += this.arrowWidth * 2;
                                }
                                graphics.setColor(Color.darkGray);
                                if (n5 == 0 && bl2) {
                                    graphics.fillRect(0, n9 - this.charAscent - this.charLeading - this.vgap, n2, this.lineHeight);
                                    graphics.setColor(Color.darkGray);
                                    graphics.drawLine(0, n9 + this.charDescent + this.vgap - 1, n2, n9 + this.charDescent + this.vgap - 1);
                                }
                                graphics.setColor(Color.pink);
                                graphics.drawString(string, n + this.hgap, n9);
                                if (titleData.getTitle().equals(this.pref.getSortTitle())) {
                                    this.paintSortArrow(graphics, string, n, n9);
                                }
                                break block27;
                            }
                            MxData mxData = (MxData)this.datavect.elementAt(n10 - 1);
                            if (!mxData.getVisible() || ++n8 - 1 < this.dindex) break block28;
                            if (bl3) {
                                string = new Integer(n8).toString();
                                if (!mxData.getFinishedFlag()) {
                                    double d = (1.0 - mxData.getProgValue()) / 2.0;
                                    graphics.setColor(Color.getHSBColor((float)d, 0.5f, 1.0f));
                                } else if (bl) {
                                    graphics.setColor(Color.lightGray);
                                    bl = false;
                                } else {
                                    graphics.setColor(Color.white);
                                    bl = true;
                                }
                                if (bl2) {
                                    graphics.fillRect(0, n9 - this.charAscent - this.charLeading - this.vgap, n2, this.lineHeight);
                                    if (mxData.getSelected()) {
                                        graphics.setColor(Color.black);
                                        graphics.fillRect(0, n9 - this.charAscent - this.charLeading - this.vgap, 2, this.lineHeight);
                                        graphics.fillRect(0, n9 + 1, n2, this.charDescent + this.vgap - 1);
                                    }
                                    graphics.setColor(Color.darkGray);
                                    graphics.drawLine(0, n9 + this.charDescent + this.vgap - 1, n2, n9 + this.charDescent + this.vgap - 1);
                                }
                                ++this.dvisible;
                            } else {
                                string = mxData.getMxStr(titleData.getTitle());
                                if (string == null || string.equals("null")) {
                                    string = "ND";
                                }
                            }
                            n7 = this.fm.stringWidth(string);
                            if (bl2) {
                                graphics.setColor(Color.black);
                                graphics.drawString(string, n + this.hgap, n9);
                            }
                        }
                        if (n7 > n6) {
                            n6 = n7;
                        }
                        if (n9 > n3) {
                            n9 += this.lineHeight;
                            this.vfinishflag = false;
                            break;
                        }
                        n9 += this.lineHeight;
                    }
                    ++n10;
                }
                titleData.setRect(n, 0, n6 + this.hgap * 2, this.lineHeight);
                n = n + n6 + this.hgap * 2;
                if (n > n2) {
                    bl2 = false;
                    this.hfinishflag = false;
                } else {
                    graphics.setColor(Color.white);
                    graphics.drawLine(n, 0, n, this.lineHeight);
                    graphics.setColor(Color.darkGray);
                    graphics.drawLine(n, this.lineHeight, n, n9 + this.charDescent + this.vgap - this.lineHeight - 1);
                    if (n5 == 0) {
                        graphics.setColor(Color.white);
                        graphics.drawLine(n - 2, 0, n - 2, this.lineHeight);
                        graphics.setColor(Color.darkGray);
                        graphics.drawLine(n - 2, this.lineHeight, n - 2, n9 + this.charDescent + this.vgap - this.lineHeight - 1);
                    }
                }
            }
            ++n5;
        }
    }

    private void paintSortArrow(Graphics graphics, String string, int n, int n2) {
        int n3 = n + this.hgap + this.fm.stringWidth(string) + this.arrowWidth;
        int n4 = n2 - this.charAscent;
        int n5 = n2;
        graphics.setColor(Color.yellow);
        graphics.drawLine(n3, n4, n3, n5);
        if (this.pref.getSortMode() == 1) {
            graphics.drawLine(n3 - this.arrowWidth / 2, n4 + this.arrowWidth, n3, n4);
            graphics.drawLine(n3 + this.arrowWidth / 2, n4 + this.arrowWidth, n3, n4);
        } else if (this.pref.getSortMode() == 0) {
            graphics.drawLine(n3 - this.arrowWidth / 2, n5 - this.arrowWidth, n3, n5);
            graphics.drawLine(n3 + this.arrowWidth / 2, n5 - this.arrowWidth, n3, n5);
        }
    }

    void MtxCanvas_MouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = false;
        int n = 0;
        while (n < this.titlevect.size()) {
            TitleData titleData;
            if ((n >= this.tindex || n == 0) && (titleData = (TitleData)this.titlevect.elementAt(n)).getVisible() && titleData.contains(point)) {
                this.selectedTd = titleData;
                this.boss.popupmenu(point, titleData);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            int n2 = point.y;
            n2 -= this.lineHeight;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.datavect.size()) {
                MxData mxData = (MxData)this.datavect.elementAt(n4);
                if (mxData.getVisible() && ++n3 - 1 >= this.dindex && (n2 -= this.lineHeight) < 0) {
                    this.boss.selectFromMx(mxData);
                    this.repaint();
                    break;
                }
                ++n4;
            }
        }
    }

    public void listHiddenTitle(Vector vector) {
        int n = 0;
        while (n < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n);
            if (!titleData.getVisible()) {
                vector.addElement(titleData);
            }
            ++n;
        }
    }

    public void hideCurrentTitle() {
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setVisible(false);
        this.setMaxTDIndex();
        this.repaint();
        this.fileOutPref();
    }

    public void showTitle(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n);
            if (!titleData.getVisible() && string.equals(titleData.getTitle())) {
                titleData.setVisible(true);
                break;
            }
            ++n;
        }
        this.setMaxTDIndex();
        this.repaint();
        this.fileOutPref();
    }

    public void miSortData(int n) {
        if (this.selectedTd == null) {
            return;
        }
        this.pref.setSortTitle(this.selectedTd.getTitle());
        this.pref.setSortMode(n);
        this.sortRequiredFlag = true;
        this.repaint();
        this.fileOutPref();
    }

    private void cutOffData() {
        if (!this.cutOffRequiredFlag) {
            return;
        }
        this.clearCutOff();
        int n = 1;
        while (n < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n);
            if (titleData.hasCutCond() && !titleData.getTitle().equals("No")) {
                int n2 = 0;
                while (n2 < this.datavect.size()) {
                    MxData mxData = (MxData)this.datavect.elementAt(n2);
                    double d = mxData.getMxVal(titleData.getTitle());
                    if (!titleData.applyCond(d)) {
                        mxData.setVisible(false);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.cutOffRequiredFlag = false;
    }

    private void clearCutOff() {
        int n = 0;
        while (n < this.datavect.size()) {
            MxData mxData = (MxData)this.datavect.elementAt(n);
            mxData.setVisible(true);
            ++n;
        }
    }

    public void setCondition(CutCond cutCond) {
        if (cutCond == null) {
            return;
        }
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setCutCond(cutCond);
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    public void delCondition() {
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setCutCond(null);
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    public void disableAllConditions() {
        int n = 0;
        while (n < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n);
            titleData.setCutCondState(false);
            ++n;
        }
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    private void sortData() {
        if (!this.sortRequiredFlag) {
            return;
        }
        if (this.pref.getSortTitle() == null) {
            return;
        }
        this.genSortData(this.findTitleData(this.pref.getSortTitle()), this.pref.getSortMode());
        this.sortRequiredFlag = false;
    }

    public void setCutCondState(boolean bl) {
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setCutCondState(bl);
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    private TitleData findTitleData(String string) {
        int n = 0;
        while (n < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n);
            if (titleData.getTitle().equals(string)) {
                return titleData;
            }
            ++n;
        }
        System.out.println("in MtxCanvas.findTitleData, no match found for " + string);
        return null;
    }

    private void genSortData(TitleData titleData, int n) {
        String string = titleData.getTitle();
        int n2 = 0;
        while (n2 < this.datavect.size()) {
            double d = ((MxData)this.datavect.elementAt(n2)).getMxVal(string);
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < this.datavect.size()) {
                double d2 = ((MxData)this.datavect.elementAt(n4)).getMxVal(string);
                if (!this.compare(d2, d, n)) {
                    d = d2;
                    n3 = n4;
                }
                ++n4;
            }
            Object e = this.datavect.elementAt(n2);
            this.datavect.setElementAt(this.datavect.elementAt(n3), n2);
            this.datavect.setElementAt(e, n3);
            ++n2;
        }
    }

    boolean compare(double d, double d2, int n) {
        boolean bl = false;
        if (n == 0) {
            bl = d >= d2;
        } else if (n == 1) {
            bl = d <= d2;
        }
        return bl;
    }

    public void setSortRequiredFlag(boolean bl) {
        this.sortRequiredFlag = bl;
    }

    public void setBoundPref(Rectangle rectangle) {
        this.pref.setBound(rectangle);
    }

    public void fileOutPref() {
        this.pref.clearCutCond();
        this.pref.clearTitle();
        int n = 0;
        while (n < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n);
            CutCond cutCond = titleData.getCutCond();
            String string = titleData.getTitle();
            if (!titleData.getVisible()) {
                string = "*" + string;
            }
            this.pref.addTitle(string);
            if (cutCond != null) {
                this.pref.addCutCond(titleData.getTitle(), titleData.getCutCond());
            }
            ++n;
        }
        FileAnalyzer.fileOutMxPrefs(this.pref);
    }

    public MxPrefValue getPref() {
        return this.pref;
    }

    public void setTIndex(int n) {
        this.tindex = n;
        this.repaint();
    }

    public void setDIndex(int n) {
        this.dindex = n;
        this.repaint();
    }

    void MtxCanvas_ComponentResized(ComponentEvent componentEvent) {
        this.fileOutPref();
    }

    public void exportCSVFile(String string, int n) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n2);
            if (titleData.getVisible()) {
                vector.addElement(titleData.getTitle());
            }
            ++n2;
        }
        vector2.addElement(vector);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.datavect.size()) {
            MxData mxData = (MxData)this.datavect.elementAt(n4);
            if (mxData.getVisible()) {
                Vector<String> vector3 = new Vector<String>();
                ++n3;
                int n5 = 0;
                while (n5 < vector.size()) {
                    String string2 = (String)vector.elementAt(n5);
                    if (string2.equals("No")) {
                        vector3.addElement(Integer.toString(n3));
                    } else {
                        String string3 = mxData.getMxStr(string2);
                        if (string3 == null) {
                            string3 = "ND";
                        }
                        vector3.addElement(string3);
                    }
                    ++n5;
                }
                vector2.addElement(vector3);
            }
            ++n4;
        }
        FileAnalyzer.exportCSVFile(string, vector2, n);
    }

    public TitleData getSelectedTd() {
        return this.selectedTd;
    }

    public void setToSelectedData() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.datavect.size()) {
            MxData mxData = (MxData)this.datavect.elementAt(n2);
            if (mxData.getVisible()) {
                if (mxData.getSelected()) {
                    this.dindex = n;
                    break;
                }
                ++n;
            }
            ++n2;
        }
    }

    public void moveTitle(int n) {
        if (this.selectedTd == null) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n3);
            if (titleData == this.selectedTd) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 < 0) {
            return;
        }
        int n4 = n2;
        if (n == 0) {
            do {
                if (n4 != this.titlevect.size() - 1) continue;
                return;
            } while (!((TitleData)this.titlevect.elementAt(++n4)).getVisible());
        } else if (n == 1) {
            if (n2 == 0) {
                return;
            }
            do {
                if (n4 - 1 != 0) continue;
                return;
            } while (!((TitleData)this.titlevect.elementAt(--n4)).getVisible());
        }
        this.titlevect.removeElement(this.selectedTd);
        this.titlevect.insertElementAt(this.selectedTd, n4);
        this.repaint();
        this.fileOutPref();
    }

    public boolean titleMoveEligible(int n) {
        if (this.selectedTd == null) {
            return true;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.titlevect.size()) {
            if (this.selectedTd == (TitleData)this.titlevect.elementAt(n3)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return true;
        }
        int n4 = 0;
        if (n == 1) {
            int n5 = 0;
            while (n5 < n2) {
                TitleData titleData = (TitleData)this.titlevect.elementAt(n5);
                if (titleData.getVisible()) {
                    ++n4;
                }
                ++n5;
            }
            return n4 > true;
        }
        int n6 = n2 + 1;
        while (n6 < this.titlevect.size()) {
            TitleData titleData = (TitleData)this.titlevect.elementAt(n6);
            if (titleData.getVisible()) {
                ++n4;
            }
            ++n6;
        }
        return n4 != 0;
    }

    public boolean getHFinishFlag() {
        return this.hfinishflag && this.tindex <= 1;
    }

    public boolean getVFinishFlag() {
        return this.vfinishflag && this.dindex == 0;
    }

    public void clearData() {
        int n = 0;
        while (n < this.datavect.size()) {
            MxData mxData = (MxData)this.datavect.elementAt(n);
            mxData.clearLinkToRd();
            ++n;
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == MtxCanvas.this) {
                MtxCanvas.this.MtxCanvas_MouseClicked(mouseEvent);
            }
        }

        SymMouse() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == MtxCanvas.this) {
                MtxCanvas.this.MtxCanvas_ComponentResized(componentEvent);
            }
        }

        SymComponent() {
        }
    }
}

