/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Vector;

public class SkyPainter {
    static double[] bbtable;
    static double[] brtable;
    double sybVolume = 1.0;
    static final int smallRadius = 6;
    final int ingSizeFactor = 3;
    final int particleNo = 50;
    final int particleRad = 100;
    SkyCanvas boss;
    int paintmode;
    int pre_paintmode = this.paintmode = 0;
    boolean gridFlag = true;
    boolean topFlag = true;
    int cstmode = 1;
    int cstnamemode = 1;
    int calccount = 0;
    int gpcount = 0;
    double vra;
    double prev_vra;
    double vde;
    double prev_vde;
    double vangle;
    double prev_vangle;
    Dimension pre_dimension;
    int movelesscount = 0;
    final int movelessValue = 3;
    boolean moveflag;
    boolean pre_moveflag = this.moveflag = false;
    double starBrVal = 5.0;
    boolean tailflag = true;
    double tailbr = 1.0;
    MyClipper mycp;
    int[][] x_line;
    int[][] y_line;
    int[] x_vect;
    int[] y_vect;
    int phase_no;

    static {
        double[] dArray = new double[11];
        dArray[2] = 0.2;
        dArray[3] = 0.4;
        dArray[4] = 0.6;
        dArray[5] = 0.8;
        dArray[6] = 1.0;
        dArray[7] = 1.0;
        dArray[8] = 1.0;
        dArray[9] = 1.0;
        dArray[10] = 1.0;
        bbtable = dArray;
        double[] dArray2 = new double[10];
        dArray2[0] = 1.0;
        dArray2[1] = 0.9;
        dArray2[2] = 0.8;
        dArray2[3] = 0.8;
        dArray2[4] = 0.7;
        dArray2[5] = 0.6;
        dArray2[6] = 0.5;
        dArray2[7] = 0.4;
        dArray2[8] = 0.2;
        brtable = dArray2;
    }

    SkyPainter(SkyCanvas skyCanvas) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = -3;
        nArray[3] = -2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[1] = -2;
        nArray2[2] = -3;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = -1;
        nArray3[2] = 3;
        nArray3[3] = 2;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = -1;
        nArray4[1] = 2;
        nArray4[2] = 3;
        nArrayArray[3] = nArray4;
        this.x_line = nArrayArray;
        int[][] nArrayArray2 = new int[4][];
        int[] nArray5 = new int[4];
        nArray5[0] = 1;
        nArray5[1] = -2;
        nArray5[2] = -3;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = -1;
        nArray6[2] = 3;
        nArray6[3] = 2;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = -1;
        nArray7[1] = -2;
        nArray7[2] = 3;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 1;
        nArray8[2] = -3;
        nArray8[3] = -2;
        nArrayArray2[3] = nArray8;
        this.y_line = nArrayArray2;
        this.x_vect = new int[]{1, 1, -1, -1};
        this.y_vect = new int[]{1, -1, -1, 1};
        this.phase_no = 0;
        this.boss = skyCanvas;
        this.mycp = new MyClipper();
    }

    Dimension getSize() {
        return this.boss.getSize();
    }

    Dimension getSkyMapSize() {
        return this.boss.getSkyMapSize();
    }

    public void paintIngNode(PointData pointData, Graphics graphics, int n) {
        pointData.resetDPoints();
        DPos dPos = pointData.getPoint();
        Point point = this.mapToCanvasWithClip(dPos);
        if (point == null) {
            pointData.resetDPoints();
            return;
        }
        if (this.moveflag && this.paintmode != 0) {
            this.paintSimpleINode(pointData, point, graphics);
        } else {
            if (n == 0) {
                this.paintNNode(pointData, point, graphics);
            } else if (n == 1) {
                this.paintWNode(pointData, point, graphics);
            } else if (n == 2) {
                this.paintBWNode(pointData, point, graphics);
            } else if (n == 3) {
                this.paintLineNode(pointData, point, graphics);
            }
            if (pointData.getTop() && this.topFlag) {
                this.paintTopRing(pointData, graphics, point, (int)((double)(SkyCanvas.maxCircleLevel * 3) * this.sybVolume) + 4);
            }
        }
    }

    private void paintTopRing(PointData pointData, Graphics graphics, Point point, int n) {
        int n2 = 0;
        while (n2 < 3) {
            double d = 1.0 - (double)((float)pointData.getLevel() / (float)SkyCanvas.maxCircleLevel);
            if (n2 % 2 == 1) {
                d = 1.0 - d;
            }
            Color color = Color.pink;
            float[] fArray = new float[3];
            fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
            Color color2 = Color.getHSBColor(fArray[0], fArray[1], (float)d);
            graphics.setColor(color2);
            int n3 = (int)((double)n / Math.sqrt(2.0)) + n2 + 1;
            graphics.drawLine(point.x, point.y + n3, point.x + n3, point.y);
            graphics.drawLine(point.x + n3, point.y, point.x, point.y - n3);
            graphics.drawLine(point.x, point.y - n3, point.x - n3, point.y);
            graphics.drawLine(point.x - n3, point.y, point.x, point.y + n3);
            ++n2;
        }
    }

    private void paintSimpleINode(PointData pointData, Point point, Graphics graphics) {
        int n = 3;
        double d = bbtable[n];
        double d2 = brtable[n] + 0.2;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        double d3 = (1.0 - pointData.getProgValue()) / 2.0;
        graphics.setColor(Color.getHSBColor((float)d3, (float)d, (float)d2));
        int n2 = (int)(18.0 * this.sybVolume);
        int n3 = point.x - (int)((double)n2 * 0.5);
        int n4 = point.y - (int)((double)n2 * 0.5);
        graphics.fillOval(n3, n4, n2, n2);
    }

    private void paintNNode(PointData pointData, Point point, Graphics graphics) {
        int n = pointData.getLevel();
        int n2 = (int)((double)(n * 3) * this.sybVolume);
        while (n2 >= 0) {
            int n3 = (int)((double)n2 / (3.0 * this.sybVolume));
            double d = bbtable[n3];
            double d2 = brtable[n3] + 0.2;
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            double d3 = (1.0 - pointData.getProgValue()) / 2.0;
            graphics.setColor(Color.getHSBColor((float)d3, (float)d, (float)d2));
            int n4 = point.x - (int)((double)n2 * 0.5);
            int n5 = point.y - (int)((double)n2 * 0.5);
            graphics.drawOval(n4, n5, n2, n2);
            n2 -= 2;
        }
    }

    private void paintWNode(PointData pointData, Point point, Graphics graphics) {
        int n = Calendar.getInstance().get(13);
        if (n > 30) {
            n = 60 - n;
        }
        double d = 0.75 + (double)n / 120.0;
        int n2 = 0;
        while (n2 < SkyCanvas.maxCircleLevel) {
            int n3 = (int)((double)(n2 * 3) * this.sybVolume);
            int n4 = (int)((double)n3 * d);
            int n5 = 0;
            while (n5 < SkyCanvas.maxCircleLevel) {
                int n6 = (pointData.getLevel() + n5 + n2) % SkyCanvas.maxCircleLevel;
                int n7 = 36;
                double d2 = bbtable[n6];
                double d3 = brtable[n6];
                double d4 = (1.0 - pointData.getProgValue()) / 2.0;
                graphics.setColor(Color.getHSBColor((float)d4, (float)d2, (float)d3));
                int n8 = point.x;
                int n9 = point.y;
                graphics.drawArc(n8 - n4 / 2, n9 - n3 / 2, n4, n3, n5 * n7 + n, n7);
                graphics.drawArc(n8 - n3 / 2, n9 - n4 / 2, n3, n4, (SkyCanvas.maxCircleLevel - 1 - n5) * n7, n7);
                ++n5;
            }
            ++n2;
        }
    }

    private void paintBWNode(PointData pointData, Point point, Graphics graphics) {
        if (!pointData.hasLingP()) {
            pointData.initRings();
        }
        Vector vector = pointData.getRings();
        pointData.rotate();
        int n = 0;
        while (n < vector.size()) {
            double d = bbtable[n];
            double d2 = brtable[n] + 0.2;
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            double d3 = (1.0 - pointData.getProgValue()) / 2.0;
            graphics.setColor(Color.getHSBColor((float)d3, (float)d, (float)d2));
            SRing sRing = (SRing)vector.elementAt(n);
            int n2 = (int)((double)(SkyCanvas.maxCircleLevel + n * 2) * this.sybVolume);
            int n3 = point.x - (int)((double)n2 * 0.5);
            int n4 = point.y - (int)((double)n2 * 0.5);
            Vector vector2 = sRing.getInfoVect();
            int n5 = 0;
            while (n5 < vector2.size()) {
                Point point2 = (Point)vector2.elementAt(n5);
                graphics.drawArc(n3, n4, n2, n2, point2.x, point2.y);
                ++n5;
            }
            ++n;
        }
    }

    private void paintLineNode(PointData pointData, Point point, Graphics graphics) {
        int n = pointData.getLevel();
        double d = bbtable[n];
        double d2 = brtable[n] + 0.2;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        double d3 = (1.0 - pointData.getProgValue()) / 2.0;
        graphics.setColor(Color.getHSBColor((float)d3, (float)d, (float)d2));
        this.paintLineANode(pointData, point, graphics, true, true);
    }

    public void paintEdNode(PointData pointData, Graphics graphics, int n, int n2, boolean bl) {
        Serializable serializable;
        if (n2 == 3 || n2 == 2) {
            serializable = pointData.getColor();
            float[] fArray = new float[3];
            fArray = Color.RGBtoHSB(serializable.getRed(), serializable.getGreen(), serializable.getBlue(), fArray);
            Color color = Color.getHSBColor(fArray[0], fArray[1], (float)(1.0 - (double)((float)pointData.getLevel() / (float)SkyCanvas.maxCircleLevel)));
            graphics.setColor(color);
        } else {
            graphics.setColor(pointData.getColor());
        }
        serializable = this.mapToCanvasWithClip(pointData.getPoint());
        if (serializable == null) {
            pointData.resetDPoints();
            return;
        }
        if (this.moveflag) {
            pointData.resetDPoints();
            if (this.paintmode != 0) {
                this.paintSimpleANode((Point)serializable, graphics);
            }
        } else {
            if (n == 0) {
                this.paintCircleANode(pointData, (Point)serializable, graphics, bl);
            } else if (n == 1) {
                this.paintSquareANode(pointData, (Point)serializable, graphics, bl);
            } else if (n == 2) {
                this.paintDiaANode(pointData, (Point)serializable, graphics, bl);
            } else if (n == 3) {
                this.paintLineANode(pointData, (Point)serializable, graphics, bl, false);
            }
            if (pointData.getTop() && this.topFlag) {
                this.paintTopRing(pointData, graphics, (Point)serializable, (int)(6.0 * this.sybVolume) + 4);
            }
        }
    }

    private void paintSimpleANode(Point point, Graphics graphics) {
        int n = point.x;
        int n2 = point.y;
        int n3 = (int)(2.4000000000000004 * this.sybVolume);
        int n4 = (int)(1.7999999999999998 * this.sybVolume);
        graphics.drawLine(n, n2 - n3, n, n2 + n3);
        graphics.drawLine(n - n3, n2, n + n3, n2);
        graphics.drawLine(n - n4, n2 - n4, n + n4, n2 + n4);
        graphics.drawLine(n - n4, n2 + n4, n + n4, n2 - n4);
    }

    private void paintCircleANode(PointData pointData, Point point, Graphics graphics, boolean bl) {
        int n = (int)(6.0 * this.sybVolume);
        int n2 = point.x;
        int n3 = point.y;
        n2 -= n / 2;
        n3 -= n / 2;
        if (bl) {
            graphics.fillOval(n2, n3, n, n);
        } else {
            graphics.drawOval(n2, n3, n, n);
        }
    }

    private void paintSquareANode(PointData pointData, Point point, Graphics graphics, boolean bl) {
        int n = (int)(6.0 * this.sybVolume);
        int n2 = point.x;
        int n3 = point.y;
        n2 -= n / 2;
        n3 -= n / 2;
        if (bl) {
            graphics.fill3DRect(n2, n3, n, n, true);
        } else {
            graphics.draw3DRect(n2, n3, n, n, false);
        }
    }

    private void paintDiaANode(PointData pointData, Point point, Graphics graphics, boolean bl) {
        int n = point.x;
        int n2 = point.y;
        int n3 = (int)(2.4000000000000004 * this.sybVolume);
        int n4 = (int)(6.0 * this.sybVolume);
        if (bl) {
            n4 = (int)((double)n4 * 0.7);
            graphics.drawLine(n, n2 - n4, n, n2 + n4);
            graphics.drawLine(n - n4, n2, n + n4, n2);
            graphics.drawLine(n - n3, n2 - n3, n + n3, n2 + n3);
            graphics.drawLine(n - n3, n2 + n3, n + n3, n2 - n3);
        } else {
            Polygon polygon = new Polygon();
            polygon.addPoint(n + n4, n2);
            polygon.addPoint(n + (n3 /= 2), n2 + n3);
            polygon.addPoint(n, n2 + n4);
            polygon.addPoint(n - n3, n2 + n3);
            polygon.addPoint(n - n4, n2);
            polygon.addPoint(n - n3, n2 - n3);
            polygon.addPoint(n, n2 - n4);
            polygon.addPoint(n + n3, n2 - n3);
            graphics.drawPolygon(polygon);
        }
    }

    private void paintLineANode(PointData pointData, Point point, Graphics graphics, boolean bl, boolean bl2) {
        Vector vector = new Vector();
        pointData.getAreaData(vector);
        if (vector.size() == 0) {
            return;
        }
        Polygon polygon = new Polygon();
        TDPoint tDPoint = ((DPos)vector.elementAt(0)).getPoint();
        int n = 1;
        while (n <= vector.size()) {
            DPos dPos = n == vector.size() ? (DPos)vector.elementAt(0) : (DPos)vector.elementAt(n);
            TLine tLine = new TLine(tDPoint, dPos.getPoint());
            if (bl) {
                this.drawLine(graphics, graphics.getColor(), tLine);
            }
            tDPoint = dPos.getPoint();
            ++n;
        }
    }

    public void paintTermParticle(PointData pointData, Graphics graphics) {
        double d = pointData.getProgValue();
        Point point = this.mapToCanvasWithClip(pointData.getPoint());
        if (point == null) {
            return;
        }
        int n = pointData.getLevel();
        if (d > 0.96 && n == SkyCanvas.maxCircleLevel - 1) {
            pointData.addParticle(point, 50, 100, n * 3);
        }
        double d2 = bbtable[n];
        double d3 = (1.0 - d) / 2.0;
        Vector vector = pointData.getPtVect();
        int n2 = 0;
        while (n2 < vector.size()) {
            ParticleData particleData = (ParticleData)vector.elementAt(n2);
            graphics.setColor(Color.getHSBColor((float)d3, (float)d2, (float)particleData.getLifeValue()));
            graphics.drawLine(particleData.getX(), particleData.getY(), particleData.getTX(), particleData.getTY());
            ++n2;
        }
    }

    public void paintProgValue(PointData pointData, Graphics graphics) {
        if (this.moveflag && this.paintmode != 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl = pointData.getSelected();
        String string = pointData.getCpuString();
        String string2 = pointData.getProgString();
        String string3 = pointData.getRemainCpuString();
        if (string3 != null) {
            string3 = "(+" + string3 + ")";
        }
        int n = Math.max(fontMetrics.stringWidth(string), fontMetrics.stringWidth(string2));
        int n2 = fontMetrics.getLeading() + fontMetrics.getAscent();
        int n3 = n2 + fontMetrics.getDescent();
        int n4 = 3;
        int n5 = SkyCanvas.maxCircleLevel * 3 / 2 + n4;
        Dimension dimension = this.getSkyMapSize();
        Point point = this.mapToCanvasWithClip(pointData.getPoint());
        if (point == null) {
            return;
        }
        boolean bl2 = false;
        if (point.x + n + n5 < dimension.width) {
            bl2 = true;
        }
        int n6 = 0;
        int n7 = 0;
        n6 = bl2 ? point.x + n5 : point.x - n5 - fontMetrics.stringWidth(string2);
        n7 = point.y - n4;
        graphics.setColor(Color.black);
        if (bl) {
            graphics.fillRect(n6, n7 - n2, fontMetrics.stringWidth(string2), n3);
        }
        graphics.setColor(Color.pink);
        graphics.drawString(string2, n6, n7);
        n6 = bl2 ? point.x + n5 : point.x - n5 - fontMetrics.stringWidth(string);
        n7 = point.y + n2;
        graphics.setColor(Color.black);
        if (bl) {
            graphics.fillRect(n6, n7 - n2, fontMetrics.stringWidth(string), n3);
        }
        graphics.setColor(Color.pink);
        graphics.drawString(string, n6, n7);
        if (string3 != null) {
            n6 = bl2 ? point.x + n5 : point.x - n5 - fontMetrics.stringWidth(string3);
            n7 = point.y + n2 * 2;
            graphics.setColor(Color.black);
            if (bl) {
                graphics.fillRect(n6, n7 - n2, fontMetrics.stringWidth(string3), n3);
            }
            graphics.setColor(Color.pink);
            graphics.drawString(string3, n6, n7);
        }
    }

    public void paintGPattern(PointData pointData, Graphics graphics) {
        Vector vector = pointData.getBgpot();
        if (vector == null) {
            return;
        }
        Point point = this.mapToCanvasWithClip(pointData.getPoint());
        if (point == null) {
            return;
        }
        double d = 0.0;
        int n = 0;
        while (n < vector.size()) {
            Double d2 = (Double)vector.elementAt(n);
            double d3 = 0.0;
            if (d2 != null) {
                d3 = d2;
            }
            if (d3 > d) {
                d = d3;
            }
            ++n;
        }
        int n2 = 40;
        int n3 = 6;
        Dimension dimension = this.getSkyMapSize();
        if (d > 0.0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = point.y + n2 + SkyCanvas.maxCircleLevel * 3 / 2 + fontMetrics.getHeight();
            int n5 = point.x - vector.size() * n3 / 2;
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 + vector.size() * n3 > dimension.width) {
                n5 = dimension.width - vector.size() * n3;
            }
            int n6 = n5;
            int n7 = n4;
            int n8 = n4;
            int n9 = 0;
            while (n9 < vector.size()) {
                double d4 = 0.5;
                if (n9 < this.gpcount) {
                    d4 = 1.0;
                }
                graphics.setColor(Color.getHSBColor(0.0f, 0.9f, (float)d4));
                Double d5 = (Double)vector.elementAt(n9);
                double d6 = 0.0;
                if (d5 != null) {
                    d6 = d5;
                }
                n8 = n7;
                n7 = n4 - (int)(d6 / d * (double)n2);
                graphics.drawLine(n5, n8, n5, n7);
                graphics.drawLine(n5, n7, n5 + 6, n7);
                n5 += 6;
                ++n9;
            }
            if (this.gpcount >= vector.size() && pointData.getBgTrueMean() > 0.0) {
                graphics.setColor(Color.lightGray);
                n7 = n4 - (int)(pointData.getBgTrueMean() / d * (double)n2);
                n7 = n4 - (int)(pointData.getBgPower() / d * (double)n2);
            }
            this.gpcount += 2;
            if (this.gpcount > vector.size() * 2) {
                this.gpcount = 0;
            }
        }
    }

    public Point paintCrossLine(Graphics graphics, PointData pointData, int n, int n2) {
        Point point = this.mapToCanvasWithClip(pointData.getPoint());
        if (point == null) {
            return new Point();
        }
        Dimension dimension = this.getSkyMapSize();
        graphics.setColor(Color.yellow);
        int n3 = SkyCanvas.maxCircleLevel * 3;
        double d = 0.7;
        n = (int)((double)point.x * d + (double)n * (1.0 - d));
        n2 = (int)((double)point.y * d + (double)n2 * (1.0 - d));
        graphics.drawRect(n - (int)((double)n3 * 0.5), n2 - (int)((double)n3 * 0.5), n3, n3);
        graphics.drawLine(n, 0, n, n2 - (int)((double)n3 * 0.5));
        graphics.drawLine(n, dimension.height, n, n2 + (int)((double)n3 * 0.5));
        graphics.drawLine(0, n2, n - (int)((double)n3 * 0.5), n2);
        graphics.drawLine(dimension.width, n2, n + (int)((double)n3 * 0.5), n2);
        return new Point(n, n2);
    }

    public void paintStarData(Graphics graphics, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            StarData starData = (StarData)vector.elementAt(n);
            Point point = starData.getDPoint();
            Point point2 = this.mapToCanvasWithClip(starData.getPoint());
            if (point2 != null) {
                graphics.setColor(Color.white);
                double d = starData.getBr();
                if (!(d > this.starBrVal)) {
                    int n2 = point2.x;
                    int n3 = point2.y;
                    if (this.moveflag && this.tailflag && (this.paintmode == 1 || this.paintmode == 3)) {
                        if (point != null && d < 4.5) {
                            graphics.setColor(Color.getHSBColor(0.0f, 0.0f, (float)this.tailbr));
                            graphics.drawLine(n2, n3, point.x, point.y);
                        }
                    } else if (d < 1.0) {
                        int n4 = 4;
                        graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    } else if (d < 2.0) {
                        graphics.drawLine(point2.x - 2, n3, n2 + 2, n3);
                        graphics.drawLine(n2, n3 - 2, n2, n3 + 2);
                        graphics.drawLine(n2 - 1, n3 - 1, n2 + 1, n3 + 1);
                        graphics.drawLine(n2 - 1, n3 + 1, n2 + 1, n3 - 1);
                    } else if (d < 3.0) {
                        graphics.drawLine(n2, n3 - 1, n2, n3 + 1);
                        graphics.drawLine(n2 - 1, n3, n2 + 1, n3);
                    } else if (!this.moveflag) {
                        graphics.drawLine(n2, n3, n2, n3);
                    }
                }
            }
            ++n;
        }
    }

    public void paintCst(Graphics graphics, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            CstData cstData = (CstData)vector.elementAt(n);
            if (this.moveflag) {
                cstData.resetDPoint();
            } else {
                DPos dPos = cstData.getNamePos();
                if (this.cstnamemode == 1) {
                    this.drawString(graphics, dPos, cstData.getShortName(), Color.cyan);
                } else if (this.cstnamemode == 0) {
                    this.drawString(graphics, dPos, cstData.getName(), Color.cyan);
                }
                if (this.cstmode != 2 && (this.cstmode != 1 || cstData.getRank() <= 0)) {
                    Vector vector2 = cstData.getLineVect();
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        TLine tLine = (TLine)vector2.elementAt(n2);
                        this.drawLine(graphics, Color.blue, tLine);
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    public void paintGrid(Graphics graphics, Vector vector) {
        if (!this.gridFlag) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            StarData starData = (StarData)vector.elementAt(n);
            DPos dPos = starData.getPoint();
            if (this.moveflag) {
                starData.resetDPoint();
            } else {
                double d = this.vangle / 80.0;
                TDPoint[] tDPointArray = new TDPoint[]{null, null, null, null, null};
                tDPointArray[0] = new TDPoint(dPos.getRa() + d, dPos.getDe());
                tDPointArray[1] = new TDPoint(dPos.getRa() - d, dPos.getDe());
                tDPointArray[2] = new TDPoint(dPos.getRa(), dPos.getDe() + d);
                tDPointArray[3] = new TDPoint(dPos.getRa(), dPos.getDe() - d);
                this.drawLine(graphics, Color.lightGray, new TLine(tDPointArray[0], tDPointArray[1]));
                this.drawLine(graphics, Color.lightGray, new TLine(tDPointArray[2], tDPointArray[3]));
            }
            if (dPos.getDe() == 0.0 || dPos.getRa() == 0.0) {
                this.drawString(graphics, dPos, starData.getStr(), Color.lightGray);
            }
            ++n;
        }
    }

    public void setVra(double d) {
        this.vra = d;
    }

    public void setVde(double d) {
        this.vde = d;
        this.adjustVde();
    }

    public void setVangle(double d) {
        this.vangle = d * Math.PI / 180.0;
        this.adjustVde();
    }

    public double getVangle() {
        return this.vangle;
    }

    public double getRa() {
        return this.vra;
    }

    public double getDe() {
        return this.vde;
    }

    public void setPaintMode(int n) {
        this.pre_paintmode = this.paintmode;
        this.paintmode = n;
        this.movelesscount = 3;
        this.checkMovement();
    }

    public void setGridMode(boolean bl) {
        this.gridFlag = bl;
    }

    public void setTopMode(boolean bl) {
        this.topFlag = bl;
    }

    public void checkMovement() {
        this.pre_moveflag = this.moveflag;
        Dimension dimension = this.getSize();
        if (this.vra == this.prev_vra && this.vde == this.prev_vde && this.vangle == this.prev_vangle && !this.boss.getMouseDownFlag() && dimension.equals(this.pre_dimension) && this.paintmode == this.pre_paintmode) {
            ++this.movelesscount;
        } else {
            this.movelesscount = 0;
            this.moveflag = true;
        }
        if (this.movelesscount >= 3) {
            this.movelesscount = 3;
            this.moveflag = false;
        }
        this.prev_vra = this.vra;
        this.prev_vde = this.vde;
        this.pre_dimension = dimension;
        this.prev_vangle = this.vangle;
        this.pre_paintmode = this.paintmode;
    }

    public void setCstMode(int n) {
        this.cstmode = n;
    }

    public void setCstNameMode(int n) {
        this.cstnamemode = n;
    }

    public void setStarBr(double d) {
        this.starBrVal = d;
    }

    public void setSybSize(String string) {
        if (string.equals("Standard") || string.equals("Normal")) {
            this.sybVolume = 1.0;
        } else if (string.equals("Small")) {
            this.sybVolume = 0.8;
        } else if (string.equals("VerySmall")) {
            this.sybVolume = 0.5;
        } else if (!string.equals("Normal")) {
            System.out.println("Wao, we are in trouble for setSybSize with " + string);
        }
    }

    public void setTailBr(int n) {
        switch (n) {
            case 1: {
                this.tailbr = 1.0;
                break;
            }
            case 2: {
                this.tailbr = 0.9;
                break;
            }
            case 3: {
                this.tailbr = 0.7;
                break;
            }
            case 4: {
                this.tailbr = 0.5;
                break;
            }
            default: {
                System.out.println("outrange in setTailBr " + n);
            }
        }
    }

    public void setStarTrace(boolean bl) {
        this.tailflag = bl;
    }

    private void drawString(Graphics graphics, DPos dPos, String string, Color color) {
        Point point = this.mapToCanvasWithClip(dPos);
        if (point == null) {
            return;
        }
        graphics.setColor(color);
        graphics.drawString(string, point.x, point.y);
    }

    private void drawLine(Graphics graphics, Color color, TLine tLine) {
        if (this.leapP(tLine)) {
            return;
        }
        Point point = this.mapToCanvas(tLine.getP1());
        Point point2 = this.mapToCanvas(tLine.getP2());
        if (point == null || point2 == null) {
            return;
        }
        Rectangle rectangle = null;
        if (this.moveflag) {
            if (!this.mycp.clipPoint(point) || !this.mycp.clipPoint(point2)) {
                return;
            }
            rectangle = new Rectangle(point.x, point.y, point2.x, point2.y);
        } else {
            rectangle = this.mycp.lineclip(point, point2);
        }
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private boolean leapP(TLine tLine) {
        double d;
        double d2;
        if (this.paintmode != 2 && this.paintmode != 0) {
            return false;
        }
        double d3 = this.vra + Math.PI;
        if (this.paintmode == 0) {
            d3 = Math.PI;
        }
        if (d3 > Math.PI * 2) {
            d3 -= Math.PI * 2;
        }
        if ((d2 = tLine.getP1().getRa()) < 0.0) {
            d2 += Math.PI * 2;
        }
        if ((d = tLine.getP2().getRa()) < 0.0) {
            d += Math.PI * 2;
        }
        double d4 = Math.min(d2, d);
        double d5 = Math.max(d2, d);
        if (d5 - d4 < Math.PI) {
            return d5 >= d3 && d4 <= d3;
        }
        return d3 >= d5 || d3 <= d4;
    }

    private boolean leapP2(TLine tLine) {
        double d;
        if (this.paintmode != 2) {
            return false;
        }
        double d2 = this.vra + Math.PI;
        if (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        double d3 = tLine.getP1().getRa();
        double d4 = tLine.getP2().getRa();
        double d5 = d3 - d2;
        if (Math.abs(d5) > Math.PI) {
            d5 = d5 > 0.0 ? Math.abs(d5) - Math.PI * 2 : Math.PI * 2 - Math.abs(d5);
        }
        if (Math.abs(d = d4 - d2) > Math.PI) {
            d = d > 0.0 ? Math.abs(d) - Math.PI * 2 : Math.PI * 2 - Math.abs(d);
        }
        return d5 * d <= 0.0;
    }

    public void setClipRange(Dimension dimension) {
        this.mycp.setClipRange(dimension);
    }

    public Point mapToCanvasWithClip(DPos dPos) {
        Point point = this.mapToCanvas(dPos);
        if (this.clipPoint(point)) {
            return point;
        }
        dPos.resetDPoint();
        return null;
    }

    private boolean clipPoint(Point point) {
        Dimension dimension = this.getSize();
        if (point == null) {
            return false;
        }
        return point.x >= 0 && point.x <= dimension.width && point.y >= 0 && point.y <= dimension.height;
    }

    private Point mapToCanvas(DPos dPos) {
        if (this.moveflag || !dPos.isDPointSet()) {
            Point point = this.calcMapToCanvas(dPos.getPoint());
            dPos.setDPoint(point);
            return point;
        }
        return dPos.getDPoint();
    }

    private Point calcMapToCanvas(TDPoint tDPoint) {
        int n;
        Dimension dimension = this.getSkyMapSize();
        Point point = new Point();
        if (this.paintmode == 0) {
            point = this.get2DConv(tDPoint, (double)dimension.width / (Math.PI * 2));
            --point.x;
        } else if (this.paintmode == 1) {
            n = Math.min(dimension.width, dimension.height) / 2;
            double d = (double)n / Math.tan(this.vangle / 2.0);
            point = tDPoint.getConv(this.vra, this.vde, d);
        } else if (this.paintmode == 2) {
            point = this.get2DConv(tDPoint, this.getVolume());
        } else if (this.paintmode == 3) {
            n = Math.min(dimension.height / 2, dimension.width / 2);
            point = tDPoint.getPtConv(this.vra, this.vde, n);
        }
        if (point == null) {
            return null;
        }
        n = dimension.width / 2 - point.x;
        int n2 = dimension.height / 2 - point.y;
        return new Point(n, n2);
    }

    private double getVolume() {
        Dimension dimension = this.getSkyMapSize();
        int n = Math.max(dimension.height, dimension.width / 2);
        return (double)n / this.vangle;
    }

    private Point get2DConv(TDPoint tDPoint, double d) {
        double d2 = tDPoint.getRa() - this.vra;
        if (Math.abs(d2) > Math.PI) {
            d2 = d2 > 0.0 ? -1.0 * (Math.PI * 2 - Math.abs(d2)) : Math.PI * 2 - Math.abs(d2);
        }
        int n = (int)(d2 * d);
        int n2 = (int)((tDPoint.getDe() - this.vde) * d);
        return new Point(n, n2);
    }

    private void adjustVde() {
        if (this.paintmode != 2) {
            return;
        }
        double d = this.getVolume();
        Dimension dimension = this.getSkyMapSize();
        double d2 = (double)(dimension.height / 2) / d;
        if (this.vde + d2 > 1.5707963267948966) {
            this.vde = 1.5707963267948966 - d2;
        } else if (this.vde - d2 < -1.5707963267948966) {
            this.vde = -1.5707963267948966 + d2;
        }
    }
}

