/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import xnap.XNap;
import xnap.gui.AbstractPanel;
import xnap.gui.ChatGlobalSubPanel;
import xnap.gui.ChatSubPanel;
import xnap.gui.CloseableTabbedPane;
import xnap.gui.XNapFrame;
import xnap.net.IChannel;
import xnap.net.event.ChannelEvent;
import xnap.net.event.ChannelListener;
import xnap.util.ChatManager;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class ChatPanel
extends AbstractPanel
implements ListListener,
ChannelListener {
    protected CloseableTabbedPane jtp;
    protected ChatGlobalSubPanel cspGlobal;
    protected Hashtable panelsByChannel = new Hashtable();
    protected Hashtable autoJoinPanelsByChannelName = new Hashtable();

    private final void initialize() {
        this.jtp = new CloseableTabbedPane();
        this.jtp.addContainerListener(new TabListener());
        this.cspGlobal = new ChatGlobalSubPanel();
        this.cspGlobal.setStatusListener(this);
        this.jtp.addTab(XNap.tr("Global"), this.cspGlobal, false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jtp, "Center");
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.jtp.addChangeListener(changeListener);
    }

    public void channelClosed(ChannelEvent channelEvent) {
    }

    public synchronized void elementAdded(ListEvent listEvent) {
        ChatSubPanel chatSubPanel;
        IChannel iChannel = (IChannel)listEvent.getElement();
        if (ChatManager.getInstance().isAutoJoinChannel(iChannel)) {
            chatSubPanel = (ChatSubPanel)this.autoJoinPanelsByChannelName.get(iChannel.getName().toLowerCase());
            if (chatSubPanel != null) {
                chatSubPanel.addChannel(iChannel);
                this.panelsByChannel.put(iChannel, chatSubPanel);
                return;
            }
            chatSubPanel = new ChatSubPanel(iChannel);
            this.autoJoinPanelsByChannelName.put(iChannel.getName().toLowerCase(), chatSubPanel);
        } else {
            chatSubPanel = new ChatSubPanel(iChannel);
        }
        this.panelsByChannel.put(iChannel, chatSubPanel);
        ChatSubPanel chatSubPanel2 = chatSubPanel;
        Runnable runnable = new Runnable(this, iChannel, chatSubPanel2){
            private final /* synthetic */ ChatPanel this$0;
            private final /* synthetic */ IChannel val$c;
            private final /* synthetic */ ChatSubPanel val$tab;

            public final void run() {
                this.this$0.jtp.addTab(this.val$c.getName(), this.val$tab);
                if (!ChatManager.getInstance().isAutoJoinChannel(this.val$c)) {
                    XNapFrame.setFocusTo("chat");
                    if (AbstractPanel.prefs.getBlinkOnChannelJoin()) {
                        XNapFrame.getInstance().chatBlink();
                    }
                }
            }
            {
                this.val$c = iChannel;
                this.val$tab = chatSubPanel;
                this.this$0 = chatPanel;
                this.constructor$0(chatPanel);
            }

            private final void constructor$0(ChatPanel chatPanel) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public synchronized void elementRemoved(ListEvent listEvent) {
        IChannel iChannel = (IChannel)listEvent.getElement();
        ChatSubPanel chatSubPanel = (ChatSubPanel)this.panelsByChannel.get(listEvent.getElement());
        if (chatSubPanel != null) {
            chatSubPanel.removeChannel(iChannel);
            if (chatSubPanel.getChannelCount() == 0) {
                Runnable runnable = new Runnable(this, chatSubPanel){
                    private final /* synthetic */ ChatPanel this$0;
                    private final /* synthetic */ ChatSubPanel val$csp;

                    public final void run() {
                        this.this$0.jtp.remove(this.val$csp);
                    }
                    {
                        this.val$csp = chatSubPanel;
                        this.this$0 = chatPanel;
                        this.constructor$0(chatPanel);
                    }

                    private final void constructor$0(ChatPanel chatPanel) {
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public JMenu getChannelTableMenu() {
        return this.cspGlobal.getChannelTableMenu();
    }

    public Component getSelectedTab() {
        return this.jtp.getSelectedComponent();
    }

    public void messageReceived(ChannelEvent channelEvent) {
        this.cspGlobal.messageReceived(channelEvent);
    }

    public void userAdded(ChannelEvent channelEvent) {
    }

    public void userRemoved(ChannelEvent channelEvent) {
    }

    public void savePrefs() {
        this.cspGlobal.savePrefs();
    }

    public void topicChanged(ChannelEvent channelEvent) {
    }

    public ChatPanel() {
        this.initialize();
        ChatManager.getInstance().getChannels().addListListener(this);
        ChatManager.getInstance().addChannelListener(this);
    }

    protected class TabListener
    extends ContainerAdapter {
        public void componentRemoved(ContainerEvent containerEvent) {
            ChatSubPanel chatSubPanel = (ChatSubPanel)containerEvent.getChild();
            if (ChatManager.getInstance().isAutoJoinChannel(chatSubPanel.getChannel())) {
                ChatPanel.this.autoJoinPanelsByChannelName.remove(chatSubPanel.getChannel().getName().toLowerCase());
            }
            IChannel[] iChannelArray = chatSubPanel.getChannels();
            int n = 0;
            while (n < iChannelArray.length) {
                ChatPanel.this.panelsByChannel.remove(iChannelArray[n]);
                ChatManager.getInstance().removeChannel(iChannelArray[n]);
                ++n;
            }
        }

        TabListener() {
        }
    }
}

