/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.DefaultDialog;
import xnap.gui.Dialogs;
import xnap.gui.FileListCellRenderer;
import xnap.gui.GridBagHelper;
import xnap.gui.MultiLineLabel;
import xnap.gui.TransferListCellRenderer;
import xnap.net.ITransferContainer;
import xnap.util.FileHelper;
import xnap.util.Preferences;

public class Dialogs {
    public static final int COPY_FILES = 0;
    public static final int DELETE_FILES = 1;
    public static final int MOVE_FILES = 2;
    protected static Preferences prefs = Preferences.getInstance();
    private static Logger logger = Logger.getLogger(class$Lxnap$gui$Dialogs != null ? class$Lxnap$gui$Dialogs : (class$Lxnap$gui$Dialogs = Dialogs.class$("xnap.gui.Dialogs")));
    private static /* synthetic */ Class class$Lxnap$gui$Dialogs;

    public static boolean copy(File[] fileArray, File file) {
        boolean bl = true;
        if ((fileArray = Dialogs.showCopyDialog(null, fileArray, file)) != null) {
            int n = 0;
            while (n < fileArray.length) {
                try {
                    FileHelper.copy(fileArray[n], new File(file, fileArray[n].getName()));
                }
                catch (IOException iOException) {
                    bl = false;
                    JOptionPane.showMessageDialog(null, "Could not copy file: " + iOException.getLocalizedMessage(), XNap.tr("Error"), 0);
                }
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static void error(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, XNap.tr("Error"), 0);
    }

    public static boolean move(File[] fileArray, File file) {
        boolean bl = true;
        if ((fileArray = Dialogs.showMoveDialog(null, fileArray, file)) != null) {
            int n = 0;
            while (n < fileArray.length) {
                try {
                    FileHelper.moveUnique(fileArray[n], file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    bl = false;
                    JOptionPane.showMessageDialog(null, "Could not move file: " + iOException.getLocalizedMessage(), XNap.tr("Error"), 0);
                }
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean showCloseDialog(Component component) {
        JCheckBox jCheckBox = new JCheckBox(XNap.tr("Always exit without prompting me."));
        Object[] objectArray = new Object[]{XNap.tr("This will abort any downloads and uploads."), XNap.tr("Do you really want to exit XNap?"), jCheckBox};
        int n = JOptionPane.showConfirmDialog(component, objectArray, XNap.tr("Exit XNap"), 2);
        prefs.setShowCloseDialog(!jCheckBox.isSelected());
        prefs.write();
        return n == 0;
    }

    public static File[] showCopyDialog(Component component, File[] fileArray, File file) {
        if (!prefs.getShowCopyDialog()) {
            return fileArray;
        }
        String string = MessageFormat.format(XNap.tr("Do you really want to copy these files to \"{0}\"?"), file);
        return Dialogs.showFilesActionDialog(component, fileArray, string, 0, XNap.tr("Copy"));
    }

    public static File[] showDeleteFilesDialog(Component component, File[] fileArray) {
        if (!prefs.getShowDeleteFilesDialog()) {
            return fileArray;
        }
        return Dialogs.showFilesActionDialog(component, fileArray, XNap.tr("Do you really want to delete these files?"), 1, XNap.tr("Delete"));
    }

    public static ITransferContainer[] showDeleteDownloadsDialog(Component component, ITransferContainer[] iTransferContainerArray) {
        if (!prefs.getShowDeleteDownloadsDialog()) {
            return iTransferContainerArray;
        }
        JList<ITransferContainer> jList = new JList<ITransferContainer>(iTransferContainerArray);
        jList.setCellRenderer(new TransferListCellRenderer());
        jList.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jList);
        jList.setSelectionInterval(0, iTransferContainerArray.length - 1);
        JCheckBox jCheckBox = new JCheckBox(XNap.tr("Do not ask me again."));
        Object[] objectArray = new Object[]{jScrollPane, jCheckBox, XNap.tr("Do you really want to delete these files?")};
        int n = JOptionPane.showConfirmDialog(component, objectArray, MessageFormat.format(XNap.tr("{0} Files"), XNap.tr("Delete")), 0);
        prefs.setShowDeleteDownloadsDialog(!jCheckBox.isSelected());
        if (n == 0) {
            Object[] objectArray2 = jList.getSelectedValues();
            ITransferContainer[] iTransferContainerArray2 = new ITransferContainer[objectArray2.length];
            System.arraycopy(objectArray2, 0, iTransferContainerArray2, 0, iTransferContainerArray2.length);
            return iTransferContainerArray2;
        }
        return null;
    }

    protected static File[] showFilesActionDialog(Component component, File[] fileArray, String string, int n, String string2) {
        JList<File> jList = new JList<File>(fileArray);
        jList.setCellRenderer(new FileListCellRenderer());
        jList.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jList);
        jList.setSelectionInterval(0, fileArray.length - 1);
        JCheckBox jCheckBox = new JCheckBox(XNap.tr("Do not ask me again."));
        Object[] objectArray = new Object[]{jScrollPane, jCheckBox, string};
        int n2 = JOptionPane.showConfirmDialog(component, objectArray, MessageFormat.format(XNap.tr("{0} Files"), string2), 0);
        Dialogs.setShowDialog(n, !jCheckBox.isSelected());
        if (n2 == 0) {
            Object[] objectArray2 = jList.getSelectedValues();
            File[] fileArray2 = new File[objectArray2.length];
            System.arraycopy(objectArray2, 0, fileArray2, 0, fileArray2.length);
            return fileArray2;
        }
        return null;
    }

    public static void showFullPathSharing(Component component) {
        JCheckBox jCheckBox = new JCheckBox(XNap.tr("Share Full Path"), prefs.getShareFullPath());
        Object[] objectArray = new Object[]{XNap.tr("A new feature has been added in this XNap release, which shares your files \n with their full path and not only with a meaningless number as directory entry. \nThis makes browsing much nicer from other clients and therefore it makes \na lot of sense to leave this enabled. \nPlease change this setting only if you really know what you are doing!"), jCheckBox};
        JOptionPane.showMessageDialog(component, objectArray, XNap.tr("New Version"), -1);
        prefs.setShareFullPath(jCheckBox.isSelected());
    }

    public static File[] showMoveDialog(Component component, File[] fileArray, File file) {
        if (!prefs.getShowMoveDialog()) {
            return fileArray;
        }
        String string = MessageFormat.format(XNap.tr("Do you really want to move these files to \"{0}\"?"), file);
        return Dialogs.showFilesActionDialog(component, fileArray, string, 2, XNap.tr("Move"));
    }

    public static void showNotification(Component component, String string, String string2, String string3) {
        if (!prefs.getNotShowDialog(string)) {
            NotificationDialog notificationDialog = new NotificationDialog(null, string, string2, string3);
            notificationDialog.show(component);
        }
    }

    public static void showPortRange(Component component) {
        String string = XNap.tr("XNap now supports port ranges. You can set a port range in the OpenNap preferences panel like '6600-6700'. XNap will pick a random port that is available in that range. Also multiple distinct ports or ranges can be seperated with a semikolon like '6699;7788'.");
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        multiLineLabel.setBorder(new TitledBorder(XNap.tr("Port Range", 1)));
        multiLineLabel.setColumns(40);
        Object[] objectArray = new Object[]{multiLineLabel};
        JOptionPane.showMessageDialog(component, objectArray, XNap.tr("New Version"), -1);
    }

    public static String showRenameDialog(Component component, String string) {
        JTextField jTextField = new JTextField(string);
        Object[] objectArray = new Object[]{XNap.tr("Filename"), jTextField};
        int n = JOptionPane.showConfirmDialog(component, objectArray, XNap.tr("Rename File"), 2);
        return n == 0 ? jTextField.getText() : null;
    }

    public static void showRestartNotification(Component component) {
        JOptionPane.showMessageDialog(component, XNap.tr("You need to restart XNap to activate your changes."), XNap.tr("Preferences"), 1);
    }

    private static final void setShowDialog(int n, boolean bl) {
        switch (n) {
            case 0: {
                prefs.setShowCopyDialog(bl);
                return;
            }
            case 1: {
                prefs.setShowDeleteFilesDialog(bl);
                return;
            }
            case 2: {
                prefs.setShowMoveDialog(bl);
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NotificationDialog
    extends DefaultDialog {
        private static Preferences prefs = Preferences.getInstance();
        private JCheckBox jcbDoNotShowAgain;
        private String dialogName;

        public void apply() {
            prefs.setNotShowDialog(this.dialogName, this.jcbDoNotShowAgain.isSelected());
        }

        private NotificationDialog(String string, String string2, String string3) {
            super(DefaultDialog.BUTTON_OKAY);
            this.dialogName = string;
            MultiLineLabel multiLineLabel = new MultiLineLabel(string3);
            multiLineLabel.setBorder(new TitledBorder(" " + string2 + " "));
            multiLineLabel.setColumns(40);
            this.jcbDoNotShowAgain = new JCheckBox(XNap.tr("Do not show again"), prefs.getNotShowDialog(string));
            this.setTitle(XNap.tr("Notification"));
            this.getMainPanel().setBorder(new EmptyBorder(5, 5, 5, 5));
            this.getMainPanel().setLayout(new GridBagLayout());
            GridBagHelper.add((Container)this.getMainPanel(), multiLineLabel);
            GridBagHelper.add((Container)this.getMainPanel(), this.jcbDoNotShowAgain);
            this.pack();
        }

        /* synthetic */ NotificationDialog(1 var1_1, String string, String string2, String string3) {
            this(string, string2, string3);
        }
    }
}

