/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.XNapFrame;
import xnap.gui.event.PopupListener;
import xnap.util.FileHelper;
import xnap.util.Preferences;

public class EditableComboBox
extends JComboBox
implements ActionListener,
PropertyChangeListener {
    protected static Logger logger = Logger.getLogger(class$Lxnap$gui$EditableComboBox != null ? class$Lxnap$gui$EditableComboBox : (class$Lxnap$gui$EditableComboBox = EditableComboBox.class$("xnap.gui.EditableComboBox")));
    protected boolean autoComplete;
    protected int historySize;
    protected boolean itemsOnly;
    protected JTextField jtf;
    private static /* synthetic */ Class class$Lxnap$gui$EditableComboBox;

    public void addDistinctItemAtTop(Object object) {
        logger.debug("i;: " + object);
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            if (object.toString().equals(this.getItemAt(n).toString())) {
                this.removeItemAt(n);
            }
            --n;
        }
        this.insertItemAt(object, 0);
        this.setSelectedIndex(0);
    }

    public boolean getAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean bl) {
        this.autoComplete = bl;
    }

    public Dimension getMinimumSize() {
        return this.jtf.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.jtf.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.jtf.getMaximumSize();
    }

    public void setHistorySize(int n) {
        this.historySize = n;
    }

    public boolean isItemSelected() {
        return this.isItem(this.jtf.getText());
    }

    public boolean getItemsOnly() {
        return this.itemsOnly;
    }

    public void setItemsOnly(boolean bl) {
        this.itemsOnly = bl;
    }

    public JTextField getJTextField() {
        return this.jtf;
    }

    public Object getSelectedItem() {
        ComboBoxModel comboBoxModel = this.getModel();
        Object object = comboBoxModel.getSelectedItem();
        if (object != null) {
            if (object instanceof String) {
                Object object2 = this.getItem((String)object);
                if (object2 != null) {
                    return object2;
                }
                return this.jtf.getText();
            }
            return object;
        }
        return this.jtf.getText();
    }

    public String getText() {
        return this.jtf.getText();
    }

    public void setText(String string) {
        this.jtf.setText(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setAutoComplete(Preferences.getInstance().getAutoComplete());
    }

    public void readBinaryHistoryFile(File file, Class clazz) {
    }

    public void readBinaryHistoryFile(File file) {
        logger.debug("reading binary history: " + file);
        ArrayList arrayList = new ArrayList();
        try {
            FileHelper.readBinary(file, arrayList);
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                this.addItem(iterator.next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    public void readHistoryFile(File file) {
        block12: {
            String string;
            logger.debug("reading history: " + file);
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while (n < this.historySize && (string = bufferedReader.readLine()) != null) {
                this.addItem(string);
                ++n;
            }
            bufferedReader.close();
            Object var4_6 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block12;
            }
            catch (IOException iOException) {}
            break block12;
            {
                catch (IOException iOException) {
                    Object var4_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void writeBinaryHistoryFile(File file) {
        logger.debug("writing binary history: " + file);
        int n = Math.min(this.getItemCount(), this.historySize);
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.getItemAt(n2));
            ++n2;
        }
        try {
            FileHelper.writeBinary(file, arrayList);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeHistoryFile(File var1_1) {
        block13: {
            EditableComboBox.logger.debug("writing history: " + var1_1);
            var2_2 = null;
            var2_2 = new BufferedWriter(new FileWriter(var1_1));
            var6_3 = this.getItemCount();
            var7_5 = 0;
            if (true) ** GOTO lbl13
            do {
                var2_2.write(this.getItemAt(var7_5).toString());
                var2_2.newLine();
                ++var7_5;
lbl13:
                // 2 sources

                if (var7_5 >= this.historySize) break;
            } while (var7_5 < var6_3);
            var4_6 = null;
            try {
                if (var2_2 != null) {
                    var2_2.close();
                }
                break block13;
            }
            catch (IOException var5_9) {}
            break block13;
            {
                catch (IOException var6_4) {
                    var4_7 = null;
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                        break block13;
                    }
                    catch (IOException var5_10) {}
                }
            }
            catch (Throwable var3_12) {
                var4_8 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                catch (IOException var5_11) {
                    // empty catch block
                }
                throw var3_12;
            }
        }
    }

    protected boolean isItem(String string) {
        return this.getItem(string) != null;
    }

    private final Object getItem(String string) {
        ComboBoxModel comboBoxModel = this.getModel();
        int n = 0;
        while (n < comboBoxModel.getSize()) {
            if (comboBoxModel.getElementAt(n).equals(string)) {
                return comboBoxModel.getElementAt(n);
            }
            ++n;
        }
        return null;
    }

    private final boolean selectFirstMatchingItem(String string) {
        ComboBoxModel comboBoxModel = this.getModel();
        int n = -1;
        string = string.toLowerCase();
        int n2 = 0;
        while (n2 < comboBoxModel.getSize()) {
            if (comboBoxModel.getElementAt(n2).toString().toLowerCase().startsWith(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            this.setSelectedItem(null);
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EditableComboBox(Action action, int n) {
        Serializable serializable;
        this.historySize = n;
        this.setAutoComplete(Preferences.getInstance().getAutoComplete());
        this.jtf = (JTextField)this.getEditor().getEditorComponent();
        this.jtf.addFocusListener(new FocusHandler());
        this.jtf.addKeyListener(new KeyHandler());
        this.setEditable(true);
        if (action != null) {
            serializable = KeyStroke.getKeyStroke(10, 0);
            this.jtf.getInputMap().put((KeyStroke)serializable, action);
            this.jtf.getActionMap().put(action, action);
        }
        Preferences.getInstance().addPropertyChangeListener("autoComplete", this);
        serializable = new JPopupMenu();
        ((JPopupMenu)serializable).add(new JMenuItem(new ClearHistoryAction()));
        this.jtf.addMouseListener(new PopupListener((JPopupMenu)serializable));
    }

    public EditableComboBox(Action action) {
        this(action, 30);
    }

    public EditableComboBox() {
        this((Action)null);
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            int n = EditableComboBox.this.jtf.getCaretPosition();
            if (EditableComboBox.this.getItemsOnly() && !EditableComboBox.this.isItemSelected()) {
                EditableComboBox.this.requestFocus();
                EditableComboBox.this.selectFirstMatchingItem(EditableComboBox.this.jtf.getText());
                EditableComboBox.this.jtf.setCaretPosition(EditableComboBox.this.jtf.getText().length());
                EditableComboBox.this.jtf.moveCaretPosition(n);
            }
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            if (!EditableComboBox.this.autoComplete) {
                return;
            }
            if (keyEvent.getKeyChar() == KeyEvent.VK_ENTER) {
                EditableComboBox.this.hidePopup();
                EditableComboBox.this.jtf.setCaretPosition(EditableComboBox.this.jtf.getText().length());
                return;
            }
            if (keyEvent.getKeyChar() == KeyEvent.VK_BACK_SPACE) {
                EditableComboBox.this.hidePopup();
                return;
            }
            String string = EditableComboBox.this.jtf.getText().substring(0, EditableComboBox.this.jtf.getSelectionStart()) + keyEvent.getKeyChar();
            if (EditableComboBox.this.selectFirstMatchingItem(string)) {
                EditableComboBox.this.jtf.setCaretPosition(EditableComboBox.this.jtf.getText().length());
                EditableComboBox.this.jtf.moveCaretPosition(string.length());
                keyEvent.consume();
                EditableComboBox.this.showPopup();
            } else if (EditableComboBox.this.getItemsOnly()) {
                keyEvent.consume();
            } else {
                EditableComboBox.this.hidePopup();
            }
        }
    }

    private class ClearHistoryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditableComboBox.this.removeAllItems();
        }

        public ClearHistoryAction() {
            this.putValue("Name", XNap.tr("Clear history"));
            this.putValue("SmallIcon", XNapFrame.getIcon("eraser.png"));
        }
    }
}

