/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelectionPanel
extends JPanel {
    protected JList fontFamilyList_;
    protected FontStyleList fontStyleList_;
    protected JTextField fontSize_;
    protected JList fontSizeList_;
    protected PhraseCanvas phraseCanvas_;
    protected PublicChangeObservable observable_ = new PublicChangeObservable();
    protected int maxNumCharsInFontSize_ = 3;

    private final Integer[] validateAndConvertPredefinedSizes(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("int[] predefinedSizes may not be null");
        }
        if (nArray.length < 1) {
            throw new IllegalArgumentException("int[] predefinedSizes must contain one or more values");
        }
        Integer[] integerArray = new Integer[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 1) {
                throw new IllegalArgumentException("int[] predefinedSizes may not contain integers with value less than 1");
            }
            integerArray[n] = new Integer(nArray[n]);
            ++n;
        }
        return integerArray;
    }

    public void addObserver(Observer observer) {
        this.observable_.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable_.deleteObserver(observer);
    }

    public String getSelectedFontFamily() throws NoFontFamilySelectedException {
        String string = (String)this.fontFamilyList_.getSelectedValue();
        if (string == null) {
            throw new NoFontFamilySelectedException("No font family is currently selected");
        }
        return string;
    }

    public int getSelectedFontStyle() throws NoFontStyleSelectedException {
        return this.fontStyleList_.getSelectedStyle();
    }

    public int getSelectedFontSize() throws NoFontSizeSpecifiedException, InvalidFontSizeException {
        String string = this.fontSize_.getText();
        if (string == null || string.equals("")) {
            throw new NoFontSizeSpecifiedException("No font size specified");
        }
        if (string.length() > this.maxNumCharsInFontSize_) {
            throw new InvalidFontSizeException("Too many characters in font size");
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFontSizeException("The number specified in the font size text field (" + this.fontSize_.getText() + ") is not a valid integer.");
        }
    }

    public Font getSelectedFont() throws InvalidFontException {
        return new Font(this.getSelectedFontFamily(), this.getSelectedFontStyle(), this.getSelectedFontSize());
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFontFamily(font.getFamily());
        this.setSelectedFontStyle(font.getStyle());
        this.setSelectedFontSize(font.getSize());
    }

    public void setSelectedFontFamily(String string) {
        ListModel listModel = this.fontFamilyList_.getModel();
        int n = 0;
        while (n < listModel.getSize()) {
            String string2 = listModel.getElementAt(n).toString();
            if (string2.equalsIgnoreCase(string)) {
                this.fontFamilyList_.setSelectedIndex(n);
                this.fontFamilyList_.ensureIndexIsVisible(n);
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("The font family supplied, '" + string + "', is not in the list of availalbe " + "font families.");
    }

    public void setSelectedFontStyle(int n) {
        this.fontStyleList_.setSelectedStyle(n);
    }

    public void setSelectedFontSize(int n) {
        this.fontSize_.setText(String.valueOf(n));
    }

    public FontSelectionPanel() {
        this((Font)null);
    }

    public FontSelectionPanel(Font font) {
        this(font, new String[]{"Plain", "Bold", "Italic", "Bold Italic"}, new int[]{8, 9, 10, 12, 14});
    }

    public FontSelectionPanel(Font font, String[] stringArray, int[] nArray) {
        super(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 11, 11));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (font == null) {
            font = new Font(stringArray2[0], 0, nArray[0]);
        }
        this.fontFamilyList_ = new JList<String>(stringArray2);
        this.fontFamilyList_.setSelectionMode(0);
        this.fontFamilyList_.setVisibleRowCount(8);
        ListSelectionListener listSelectionListener = new ListSelectionListener(this){
            private final /* synthetic */ FontSelectionPanel this$0;

            public final void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    this.this$0.observable_.setChanged();
                    this.this$0.observable_.notifyObservers();
                }
            }
            {
                this.this$0 = fontSelectionPanel;
                this.constructor$0(fontSelectionPanel);
            }

            private final void constructor$0(FontSelectionPanel fontSelectionPanel) {
            }
        };
        this.fontFamilyList_.addListSelectionListener(listSelectionListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 2;
        this.add((Component)new JScrollPane(this.fontFamilyList_), gridBagConstraints);
        this.fontStyleList_ = new FontStyleList(stringArray);
        this.fontStyleList_.setSelectionMode(0);
        this.fontStyleList_.setVisibleRowCount(4);
        this.fontStyleList_.addListSelectionListener(listSelectionListener);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)new JScrollPane(this.fontStyleList_), gridBagConstraints);
        this.fontSize_ = new JTextField();
        this.fontSize_.setHorizontalAlignment(4);
        this.fontSize_.setColumns(4);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.fontSize_, gridBagConstraints);
        this.fontSizeList_ = new JList<Integer>(this.validateAndConvertPredefinedSizes(nArray));
        this.fontSizeList_.setSelectionMode(0);
        this.fontSizeList_.setVisibleRowCount(1);
        this.fontSizeList_.setCellRenderer(new ListCellRenderer());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this.fontSizeList_), gridBagConstraints);
        this.phraseCanvas_ = new PhraseCanvas(font.getFamily(), font, Color.black);
        this.addObserver(new Observer(this){
            private final /* synthetic */ FontSelectionPanel this$0;

            public final void update(Observable observable, Object object) {
                try {
                    this.this$0.phraseCanvas_.setPhrase((String)this.this$0.fontFamilyList_.getSelectedValue());
                    this.this$0.phraseCanvas_.setFont(this.this$0.getSelectedFont());
                }
                catch (InvalidFontException invalidFontException) {
                    this.this$0.phraseCanvas_.setPhrase("");
                }
                this.this$0.phraseCanvas_.invalidate();
                this.this$0.phraseCanvas_.repaint();
            }
            {
                this.this$0 = fontSelectionPanel;
                this.constructor$0(fontSelectionPanel);
            }

            private final void constructor$0(FontSelectionPanel fontSelectionPanel) {
            }
        });
        this.phraseCanvas_.setSize((int)this.getPreferredSize().getWidth(), 100);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.fill = 2;
        this.add((Component)new JScrollPane(this.phraseCanvas_), gridBagConstraints);
        FontSizeSynchronizer fontSizeSynchronizer = new FontSizeSynchronizer(this.fontSizeList_, this.fontSize_);
        this.fontSizeList_.addListSelectionListener(fontSizeSynchronizer);
        this.fontSize_.getDocument().addDocumentListener(fontSizeSynchronizer);
        this.fontFamilyList_.setSelectedValue(font.getFamily(), true);
        this.fontStyleList_.setSelectedStyle(font.getStyle());
        this.fontSize_.setText(String.valueOf(font.getSize()));
    }

    protected class FontSizeSynchronizer
    implements DocumentListener,
    ListSelectionListener {
        protected JList list_;
        protected JTextField textField_;
        protected boolean updating_;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.updating_) {
                return;
            }
            this.updating_ = true;
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object e = ((JList)listSelectionEvent.getSource()).getSelectedValue();
                if (e != null) {
                    this.textField_.setText(e.toString());
                }
                FontSelectionPanel.this.observable_.setChanged();
                FontSelectionPanel.this.observable_.notifyObservers();
            }
            this.updating_ = false;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.handle(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.handle(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handle(documentEvent);
        }

        protected void handle(DocumentEvent documentEvent) {
            if (this.updating_) {
                return;
            }
            this.updating_ = true;
            try {
                Integer n = Integer.valueOf(this.textField_.getText());
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.list_.getModel().getSize()) {
                    Object e = this.list_.getModel().getElementAt(n2);
                    if (e.equals(n)) {
                        this.list_.setSelectedValue(n, true);
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.list_.clearSelection();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.list_.clearSelection();
            }
            FontSelectionPanel.this.observable_.setChanged();
            FontSelectionPanel.this.observable_.notifyObservers();
            this.updating_ = false;
        }

        public FontSizeSynchronizer(JList jList, JTextField jTextField) {
            this.list_ = jList;
            this.textField_ = jTextField;
        }
    }

    protected static class FontStyleList
    extends JList {
        private static final String[] validateStyleDisplayNames(String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("String[] styleDisplayNames may not be null");
            }
            if (stringArray.length != 4) {
                throw new IllegalArgumentException("String[] styleDisplayNames must have a length of 4");
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null) {
                    throw new IllegalArgumentException("No member of String[] styleDisplayNames may be null");
                }
                ++n;
            }
            return stringArray;
        }

        public int getSelectedStyle() throws NoFontStyleSelectedException {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new NoFontStyleSelectedException("No font style is currently selected");
        }

        public void setSelectedStyle(int n) {
            switch (n) {
                case 0: {
                    this.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.setSelectedIndex(2);
                    break;
                }
                case 3: {
                    this.setSelectedIndex(3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("int style must come from java.awt.Font");
                }
            }
        }

        public FontStyleList(String[] stringArray) {
            super(FontStyleList.validateStyleDisplayNames(stringArray));
        }
    }

    protected static class ListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setHorizontalAlignment(4);
            return jLabel;
        }

        ListCellRenderer() {
        }
    }

    protected static class PublicChangeObservable
    extends Observable {
        public void setChanged() {
            super.setChanged();
        }

        PublicChangeObservable() {
        }
    }

    public static class PhraseCanvas
    extends Canvas {
        protected String phrase_;
        protected Font font_;
        protected Color color_;
        protected boolean antialiasOn_;

        public void paint(Graphics graphics) {
            Font font = new Font(this.font_.getFamily(), this.font_.getStyle(), this.font_.getSize() + 1);
            font.createGlyphVector(new FontRenderContext(null, this.antialiasOn_, false), this.phrase_);
            GlyphVector glyphVector = this.font_.createGlyphVector(new FontRenderContext(null, this.antialiasOn_, false), this.phrase_);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            double d = rectangle2D.getWidth() < (double)this.getWidth() ? (double)(this.getWidth() / 2) - rectangle2D.getWidth() / 2.0 : 0.0;
            double d2 = rectangle2D.getHeight() < (double)this.getHeight() ? (double)(this.getHeight() / 2) + rectangle2D.getHeight() / 2.0 : (double)this.getHeight();
            graphics.setColor(this.color_);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawGlyphVector(glyphVector, (float)d, (float)d2);
        }

        public String getPhrase() {
            return this.phrase_;
        }

        public void setPhrase(String string) {
            this.phrase_ = string;
        }

        public Font getFont() {
            return this.font_;
        }

        public void setFont(Font font) {
            this.font_ = font;
        }

        public Color getColor() {
            return this.color_;
        }

        public void setColor(Color color) {
            this.color_ = color;
        }

        public boolean isAntialiasOn() {
            return this.antialiasOn_;
        }

        public void setAntialiasOn(boolean bl) {
            this.antialiasOn_ = bl;
        }

        public PhraseCanvas(String string, Font font, Color color) {
            this.phrase_ = string;
            this.font_ = font;
            this.color_ = color;
        }
    }

    public static class InvalidFontException
    extends Exception {
        public InvalidFontException(String string) {
            super(string);
        }
    }

    public static class NoFontFamilySelectedException
    extends InvalidFontException {
        public NoFontFamilySelectedException(String string) {
            super(string);
        }
    }

    public static class NoFontStyleSelectedException
    extends InvalidFontException {
        public NoFontStyleSelectedException(String string) {
            super(string);
        }
    }

    public static class NoFontSizeSpecifiedException
    extends InvalidFontException {
        public NoFontSizeSpecifiedException(String string) {
            super(string);
        }
    }

    public static class InvalidFontSizeException
    extends InvalidFontException {
        public InvalidFontSizeException(String string) {
            super(string);
        }
    }
}

