/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xnap.gui.IconSplitPane;

public class ToggableIconPane
extends JPanel
implements ChangeListener {
    public static final int BLINK_INTERVAL = 500;
    Vector cls = new Vector();
    IconSplitPane ipane = null;
    int dividerSize;
    JTabbedPane tpane = null;
    boolean useTabbedPane;
    Hashtable components = new Hashtable();
    Timer timer;
    Blinker blinker = new Blinker();

    public void insertTab(String string, Icon icon, JComponent jComponent, String string2, int n) {
        this.components.put(string, jComponent);
        if (this.useTabbedPane) {
            this.tpane.insertTab(string, icon, jComponent, string2, n);
        } else {
            this.ipane.insertTab(string, icon, jComponent, n);
        }
        ++this.blinker.index;
    }

    public void addTab(String string, Icon icon, JComponent jComponent) {
        this.components.put(string, jComponent);
        if (this.useTabbedPane) {
            this.tpane.addTab(string, icon, jComponent);
        } else {
            this.ipane.addTab(string, icon, jComponent);
        }
        ++this.blinker.index;
    }

    public Component[] getTabs() {
        if (this.useTabbedPane) {
            return this.tpane.getComponents();
        }
        return this.ipane.getTabs();
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public void remove(Component component) {
        Object var2_2 = null;
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.components.get(k) != component) continue;
            var2_2 = k;
        }
        if (var2_2 != null) {
            this.components.remove(var2_2);
        }
        if (this.useTabbedPane) {
            this.tpane.remove(component);
        } else {
            this.ipane.remove(component);
        }
        --this.blinker.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cls.add(changeListener);
        if (this.useTabbedPane) {
            this.tpane.addChangeListener(changeListener);
        } else {
            this.ipane.addChangeListener(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cls.remove(changeListener);
        if (this.useTabbedPane) {
            this.tpane.removeChangeListener(changeListener);
        } else {
            this.ipane.removeChangeListener(changeListener);
        }
    }

    public Icon getIconAt(int n) {
        if (this.useTabbedPane) {
            return this.tpane.getIconAt(n);
        }
        return this.ipane.getIconAt(n);
    }

    public void setIconAt(int n, Icon icon) {
        if (this.useTabbedPane) {
            this.tpane.setIconAt(n, icon);
        } else {
            this.ipane.setIconAt(n, icon);
        }
    }

    public void blink(int n, Icon icon) {
        this.unblink();
        this.blinker = new Blinker(n, icon);
        this.timer = new Timer(500, this.blinker);
        this.timer.start();
    }

    public void unblink() {
        if (this.timer != null) {
            this.timer.stop();
            this.setIconAt(this.blinker.index, this.blinker.savedIcon);
            this.timer = null;
        }
    }

    public int getSelectedIndex() {
        if (this.useTabbedPane) {
            return this.tpane.getSelectedIndex();
        }
        return this.ipane.getSelectedIndex();
    }

    public Component getSelectedComponent() {
        if (this.useTabbedPane) {
            return this.tpane.getSelectedComponent();
        }
        return this.ipane.getSelectedComponent();
    }

    public int getTabCount() {
        if (this.useTabbedPane) {
            return this.tpane.getTabCount();
        }
        return this.ipane.getTabCount();
    }

    public void setSelectedComponent(String string) {
        this.setSelectedComponent((Component)this.components.get(string));
    }

    public void setSelectedComponent(Component component) {
        if (this.useTabbedPane) {
            this.tpane.setSelectedComponent(component);
        } else {
            this.ipane.setSelectedComponent(component);
        }
    }

    public void setUseTabbedPane(boolean bl) {
        this.useTabbedPane = bl;
        if (this.useTabbedPane && this.tpane == null) {
            this.tpane = new JTabbedPane();
            if (this.ipane != null) {
                Object object;
                super.remove(this.ipane);
                Component component = this.ipane.getSelectedComponent();
                Object object2 = ((AbstractList)this.cls).iterator();
                while (object2.hasNext()) {
                    object = (ChangeListener)object2.next();
                    this.ipane.removeChangeListener((ChangeListener)object);
                    this.tpane.addChangeListener((ChangeListener)object);
                }
                while (this.ipane.getTabCount() > 0) {
                    object2 = this.ipane.getTitleAt(0);
                    object = this.ipane.getIconAt(0);
                    Component component2 = this.ipane.getTabAt(0);
                    this.ipane.removeTabAt(0);
                    this.tpane.addTab((String)object2, (Icon)object, component2);
                }
                this.ipane = null;
                this.tpane.setSelectedComponent(component);
            }
            super.add((Component)this.tpane, "Center");
        } else if (!this.useTabbedPane && this.ipane == null) {
            this.ipane = new IconSplitPane();
            if (this.dividerSize != -1) {
                this.ipane.setDividerSize(this.dividerSize);
            }
            if (this.tpane != null) {
                Object object;
                super.remove(this.tpane);
                Component component = this.tpane.getSelectedComponent();
                Object object3 = ((AbstractList)this.cls).iterator();
                while (object3.hasNext()) {
                    object = (ChangeListener)object3.next();
                    this.tpane.removeChangeListener((ChangeListener)object);
                    this.ipane.addChangeListener((ChangeListener)object);
                }
                while (this.tpane.getTabCount() > 0) {
                    object3 = this.tpane.getTitleAt(0);
                    object = this.tpane.getIconAt(0);
                    Component component3 = this.tpane.getComponentAt(0);
                    this.tpane.removeTabAt(0);
                    this.ipane.addTab((String)object3, (Icon)object, component3);
                }
                this.tpane = null;
                this.ipane.setSelectedComponent(component);
            }
            super.add((Component)this.ipane, "Center");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.timer != null && this.getSelectedIndex() == this.blinker.index) {
            this.unblink();
        }
    }

    public ToggableIconPane(boolean bl, int n) {
        this.dividerSize = n;
        this.setLayout(new BorderLayout());
        this.setUseTabbedPane(bl);
        this.addChangeListener(this);
    }

    public ToggableIconPane(boolean bl) {
        this(bl, -1);
    }

    protected class Blinker
    implements ActionListener {
        public Icon blinkIcon;
        public Icon savedIcon;
        public int index = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            Icon icon = ToggableIconPane.this.getIconAt(this.index) == this.savedIcon ? this.blinkIcon : this.savedIcon;
            ToggableIconPane.this.setIconAt(this.index, icon);
        }

        public Blinker(int n, Icon icon) {
            this.index = n;
            this.blinkIcon = icon;
            this.savedIcon = ToggableIconPane.this.getIconAt(n);
        }

        public Blinker() {
        }
    }
}

