/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.event;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import xnap.XNap;
import xnap.cmdl.Console;
import xnap.gui.XNapFrame;
import xnap.gui.event.FileCollector;
import xnap.util.Preferences;
import xnap.util.launcher.LauncherSupport;

public class OpenFileAction
extends AbstractAction
implements PropertyChangeListener {
    private FileCollector fc;
    private Preferences prefs = Preferences.getInstance();
    protected String command;

    public void actionPerformed(ActionEvent actionEvent) {
        File[] fileArray = this.fc.getFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n] != null && fileArray[n].length() != 0L) {
                try {
                    LauncherSupport.open(fileArray[n]);
                }
                catch (IOException iOException) {
                    Console.getInstance().println(iOException.getMessage());
                }
            }
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setEnabled(LauncherSupport.isEnabled());
    }

    public OpenFileAction(FileCollector fileCollector) {
        this.fc = fileCollector;
        this.putValue("Name", XNap.tr("Open"));
        this.putValue("ShortDescription", XNap.tr("Open selected files"));
        this.putValue("SmallIcon", XNapFrame.getIcon("fileopen.png"));
        this.putValue("MnemonicKey", new Integer(79));
        this.setEnabled(LauncherSupport.isEnabled());
        this.prefs.addPropertyChangeListener("fileLauncherCmd", this);
        this.prefs.addPropertyChangeListener("fileLauncherType", this);
    }
}

