/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import xnap.gui.AbstractPanel;
import xnap.gui.XNapFrame;
import xnap.gui.event.PopupListener;
import xnap.gui.event.UserSupport;
import xnap.gui.menu.UserMenu;
import xnap.net.IUser;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.gui.table.WhoisTableModel;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.util.NapPreferences;

public class WhoisPanel
extends AbstractPanel
implements UserSupport {
    protected NapPreferences napPrefs = NapPreferences.getInstance();
    protected JTable jtaUsers;
    protected WhoisTableModel wtm;
    protected ClearAction acClear = new ClearAction();
    protected UpdateAction acUpdate = new UpdateAction();
    protected WhoisAction acWhois = new WhoisAction();

    private final void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        UserMenu userMenu = new UserMenu(this, true);
        userMenu.add(this.acWhois);
        userMenu.addSeparator();
        this.wtm = new WhoisTableModel();
        this.jtaUsers = this.wtm.createJTable();
        this.jtaUsers.addMouseListener(new PopupListener(userMenu));
        this.jtaUsers.setShowGrid(false);
        JScrollPane jScrollPane = new JScrollPane(this.jtaUsers);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JButton(this.acUpdate));
        jPanel2.add(new JButton(this.acClear));
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "Center");
    }

    public void addUser(User user) {
        user.update(true);
        this.wtm.add(user);
    }

    public AbstractAction[] getActions() {
        return new AbstractAction[]{this.acUpdate, this.acClear};
    }

    public IUser[] getUsers() {
        int[] nArray = this.jtaUsers.getSelectedRows();
        IUser[] iUserArray = new IUser[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            iUserArray[n] = this.wtm.get(nArray[n]);
            ++n;
        }
        return iUserArray;
    }

    public WhoisPanel() {
        this.initialize();
    }

    private class ClearAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            WhoisPanel.this.wtm.clear();
        }

        public ClearAction() {
            this.putValue("Name", Plugin.tr("Clear"));
            this.putValue("ShortDescription", Plugin.tr("Clear table"));
            this.putValue("SmallIcon", XNapFrame.getIcon("edittrash.png"));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }

    private class UpdateAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            WhoisPanel.this.wtm.reload();
        }

        public UpdateAction() {
            this.putValue("Name", Plugin.tr("Update"));
            this.putValue("ShortDescription", Plugin.tr("Update table"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
            this.putValue("MnemonicKey", new Integer(85));
        }
    }

    private class WhoisAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            IUser[] iUserArray = WhoisPanel.this.getUsers();
            int n = 0;
            while (n < iUserArray.length) {
                User user = (User)iUserArray[n];
                user.update(true);
                ++n;
            }
        }

        public WhoisAction() {
            this.putValue("Name", Plugin.tr("Requery Whois"));
            this.putValue("ShortDescription", Plugin.tr("Do a whois query"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }
}

