/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Timer;

public class SearchResultCache {
    public static final int PURGE_INTERVAL = 600000;
    protected static Timer timer;
    protected Hashtable cache = new Hashtable();
    protected Object lock = new Object();

    public void put(String string, LinkedList linkedList) {
        SearchContainer searchContainer = new SearchContainer(linkedList);
        Object object = this.lock;
        synchronized (object) {
            this.cache.put(string, searchContainer);
        }
    }

    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.cache.clear();
        }
    }

    public LinkedList get(String string) {
        Object v;
        Object object = this.lock;
        synchronized (object) {
            v = this.cache.get(string);
        }
        return v != null ? ((SearchContainer)v).results : null;
    }

    public void purge() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.cache.keys();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                SearchContainer searchContainer = (SearchContainer)this.cache.get(string);
                if (System.currentTimeMillis() - searchContainer.time <= 600000L) continue;
                linkedList.add(string);
            }
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                this.cache.remove(object2.next());
            }
        }
    }

    public void remove(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.remove(string);
        }
    }

    protected class SearchContainer {
        public LinkedList results;
        public long time;

        public SearchContainer(LinkedList linkedList) {
            this.results = linkedList;
            this.time = System.currentTimeMillis();
        }
    }
}

