/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.net.AbstractRunnable;
import xnap.net.IChannel;
import xnap.net.IChatServer;
import xnap.net.IUser;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Browse;
import xnap.plugin.nap.net.NapListener;
import xnap.plugin.nap.net.Packet;
import xnap.plugin.nap.net.Search;
import xnap.plugin.nap.net.SearchResult;
import xnap.plugin.nap.net.SearchResultCache;
import xnap.plugin.nap.net.ServerVersion;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.net.msg.client.ListChannelsMessage;
import xnap.plugin.nap.net.msg.client.NickCheckMessage;
import xnap.plugin.nap.net.msg.server.BrowseResponseMessage;
import xnap.plugin.nap.net.msg.server.EndBrowseMessage;
import xnap.plugin.nap.net.msg.server.EndSearchMessage;
import xnap.plugin.nap.net.msg.server.ErrorMessage;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.InvalidNickMessage;
import xnap.plugin.nap.net.msg.server.LoginAckMessage;
import xnap.plugin.nap.net.msg.server.LoginErrorMessage;
import xnap.plugin.nap.net.msg.server.MessageFactory;
import xnap.plugin.nap.net.msg.server.NickAlreadyRegisteredMessage;
import xnap.plugin.nap.net.msg.server.NickNotRegisteredMessage;
import xnap.plugin.nap.net.msg.server.SearchResponseMessage;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.net.msg.server.ServerStatsMessage;
import xnap.plugin.nap.util.Channel;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.ChatManager;
import xnap.util.Preferences;
import xnap.util.PriorityQueue;
import xnap.util.Range;
import xnap.util.prefs.StringValidator;

public class Server
extends AbstractRunnable
implements IChatServer,
Runnable {
    public static final int SOCKET_TIMEOUT = 1000;
    public static final int STATUS_NOT_CONNECTED = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_CONNECTED = 2;
    public static final int STATUS_LOGIN_FAILED = 4;
    public static final int STATUS_FAILED = 5;
    public static final int STATUS_ERROR = 6;
    public static final int STATUS_NEW_STATS = 7;
    public static final String[] STATUS_MSGS = new String[]{"", Plugin.tr("connecting") + "...", Plugin.tr("connected"), Plugin.tr("login failed"), Plugin.tr("failed"), Plugin.tr("connected"), Plugin.tr("error")};
    protected static Logger logger = Logger.getLogger(class$Lxnap$plugin$nap$net$Server != null ? class$Lxnap$plugin$nap$net$Server : (class$Lxnap$plugin$nap$net$Server = Server.class$("xnap.plugin.nap.net.Server")));
    protected static Preferences prefs = Preferences.getInstance();
    private String remoteHost;
    private int remotePort;
    private String remoteIP = null;
    private String network;
    private int userCount = -1;
    private String username = null;
    private String password = null;
    private String email = null;
    private boolean newUser;
    private int fileCount = -1;
    private int fileSize = -1;
    private int ping = -1;
    private boolean temporay = false;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private long lastLogin = 0L;
    private NapListener listener = null;
    protected Search currentSearch = null;
    protected Browse currentBrowse = null;
    protected String lastError;
    private PriorityQueue searchQueue = new PriorityQueue();
    private LinkedList browseQueue = new LinkedList();
    private SearchResultCache searchCache = new SearchResultCache();
    private long lastSearch = 0L;
    protected Hashtable users = new Hashtable();
    protected int searchCount = 0;
    protected Hashtable channels = new Hashtable();
    protected ServerVersion version = ServerVersion.UNKNOWN;
    protected Range shared;
    private int maxPacketsPerTick = NapPreferences.getInstance().getMaxPacketsPerTick();
    private long tickLength = NapPreferences.getInstance().getTickLength();
    private long writeTickPacketCount = 0L;
    private long writeTickStart = 0L;
    private static /* synthetic */ Class class$Lxnap$plugin$nap$net$Server;

    public boolean isConnected() {
        return this.status == 2;
    }

    public boolean isLoginCustomized() {
        return this.username != null || this.password != null || this.email != null;
    }

    public boolean isReady() {
        return this.status == 1 || this.status == 2;
    }

    protected String getStatusMsg(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(STATUS_MSGS[n]);
        if (n == 2) {
            if (this.getLocalPort() == 0) {
                stringBuffer.append(" (firewalled)");
            }
            stringBuffer.append(" [");
            stringBuffer.append(this.searchCount);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public IChannel create(String string) {
        Channel channel = new Channel(this, string, "", 0);
        this.channels.put(string, channel);
        return channel;
    }

    public boolean equals(Object object) {
        if (object instanceof Server) {
            Server server = (Server)object;
            return this.getHost().equalsIgnoreCase(server.getHost()) && this.getPort() == server.getPort();
        }
        return false;
    }

    public Channel getChannel(String string) {
        Channel channel = (Channel)this.channels.get(string);
        if (channel == null) {
            channel = new Channel(this, string, "", 0);
            this.channels.put(string, channel);
        }
        return channel;
    }

    public IChannel[] getChannels() {
        Object[] objectArray = this.channels.values().toArray();
        IChannel[] iChannelArray = new IChannel[objectArray.length];
        System.arraycopy(objectArray, 0, iChannelArray, 0, iChannelArray.length);
        return iChannelArray;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getEmail() {
        return this.email != null ? this.email : prefs.getEmail();
    }

    public void setEmail(String string) {
        if (string != null) {
            try {
                StringValidator.EMAIL.validate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.email = string;
    }

    public String getHost() {
        return this.remoteHost;
    }

    public void setHost(String string) {
        this.remoteHost = string;
    }

    public void setIP(String string) {
        this.remoteIP = string;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public NapListener getListener() {
        return this.listener;
    }

    public void setListener(NapListener napListener) {
        this.listener = napListener;
    }

    public int getLocalPort() {
        return this.listener != null ? this.listener.getPort() : 0;
    }

    public String getName() {
        String string = this.getNetwork();
        if (string.length() > 0) {
            return string;
        }
        return this.getHost();
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String string) {
        this.network = string;
    }

    public String getPassword() {
        return this.password != null ? this.password : prefs.getPassword();
    }

    public void setPassword(String string) {
        if (string != null) {
            try {
                StringValidator.REGULAR_STRING.validate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.password = string;
    }

    public int getPort() {
        return this.remotePort;
    }

    public void setPort(int n) {
        this.remotePort = n;
    }

    public Range getShared() {
        return (Range)this.shared.clone();
    }

    public void setShared(Range range) {
        this.shared = (Range)range.clone();
    }

    public boolean isTemporary() {
        return this.temporay;
    }

    public void setTemporary(boolean bl) {
        this.temporay = bl;
    }

    public User getUser(String string) {
        User user = (User)this.users.get(string);
        if (user == null) {
            user = new User(string, this);
            this.users.put(string, user);
        }
        return user;
    }

    public IUser getUser() {
        return this.getUser(this.getUsername());
    }

    public int getUserCount() {
        return this.userCount;
    }

    public String getUsername() {
        return this.username != null ? this.username : prefs.getUsername();
    }

    public void setUsername(String string) {
        if (string != null) {
            try {
                StringValidator.REGULAR_STRING.validate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.username = string;
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = new ServerVersion(string);
    }

    public void login(boolean bl) {
        if (!this.canStart()) {
            return;
        }
        this.lastLogin = System.currentTimeMillis();
        this.setStatus(1);
        this.newUser = bl;
        this.runner = new Thread((Runnable)this, "OpenNapServer " + this.getHost());
        this.runner.start();
    }

    public void logout() {
        this.die(0);
    }

    public void messageReceived(String string, String string2, String string3) {
        Channel channel = (Channel)this.channels.get(string);
        if (channel != null) {
            channel.messageReceived(this.getUser(string2), string3);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getHost());
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(") : ");
            stringBuffer.append(string3);
            ChatManager.getInstance().globalMessageReceived(stringBuffer.toString());
        }
    }

    public synchronized void addBrowse(Browse browse) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("server disconnected");
        }
        this.browseQueue.add(browse);
        this.allowBrowse();
    }

    public synchronized void addSearch(Search search) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("server disconnected");
        }
        if (this.currentSearch != null && this.currentSearch.equals(search)) {
            Iterator iterator = this.currentSearch.getResults().iterator();
            while (iterator.hasNext()) {
                search.add((SearchResult)iterator.next());
            }
            this.currentSearch.addPeer(search);
        } else {
            int n = this.searchQueue.indexOf(search);
            if (n != -1) {
                ((Search)this.searchQueue.get(n)).addPeer(search);
            } else if (!this.useSearchCache(search)) {
                this.searchQueue.add(search, search.getPriority());
                this.allowSearch();
            }
        }
    }

    public void waitUntilReadyToSend() {
        long l = this.tickLength - (System.currentTimeMillis() - this.writeTickStart);
        if (l <= 0L) {
            this.writeTickStart = System.currentTimeMillis();
            this.writeTickPacketCount = 0L;
        } else if (this.writeTickPacketCount >= (long)this.maxPacketsPerTick) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void removeBrowse(Browse browse) {
        this.browseQueue.remove(browse);
    }

    public synchronized void removeSearch(Search search) {
        this.searchQueue.remove(search);
    }

    public void send(ClientMessage clientMessage) throws IOException {
        this.sendPacket(new Packet(clientMessage.getType(), clientMessage.getData(this.version)));
    }

    public void updateChannels() throws IOException {
        MessageHandler.send(this, new ListChannelsMessage());
    }

    private final ServerMessage getNextMessage() {
        Packet packet = null;
        while (!this.die) {
            try {
                packet = this.recvPacket();
                return MessageFactory.create(this, packet.id, packet.data);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                logger.error(this.getHost() + ":" + this.getPort() + " getNextMessage: " + iOException.getMessage());
                logger.debug(this.getHost() + ":" + this.getPort() + " getNextMessage ", iOException);
                if (this.getStatus() == 1) {
                    this.die(4, this.lastError);
                    continue;
                }
                this.die(5, this.lastError);
            }
            catch (InvalidMessageException invalidMessageException) {
                logger.error(this.getHost() + ":" + this.getPort() + " getNextMessage: " + packet, invalidMessageException);
            }
        }
        return null;
    }

    private final byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                int n3 = this.in.read(byArray, n2, n - n2);
                if (n3 == -1) {
                    throw new IOException("Connection closed");
                }
                n2 += n3;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.die) continue;
                throw interruptedIOException;
            }
        }
        return byArray;
    }

    private final Packet recvPacket() throws IOException {
        String string = "";
        byte[] byArray = this.read(4);
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFFFF & (n2 << 8 | n);
        n = 0xFF & byArray[2];
        n2 = 0xFF & byArray[3];
        int n4 = 0xFFFF & (n2 << 8 | n);
        if (n3 > 0) {
            string = new String(this.read(n3));
        }
        logger.debug("< " + this.getHost() + ":" + this.getPort() + " (" + n4 + ") " + string);
        return new Packet(n4, string);
    }

    private final void sendPacket(Packet packet) throws IOException {
        logger.debug("> " + this.getHost() + ":" + this.getPort() + " (" + packet.id + ") " + packet.data);
        try {
            int n = packet.data.getBytes().length;
            byte[] byArray = new byte[4 + n];
            short s = (short)packet.id;
            short s2 = (short)n;
            byArray[0] = (byte)s2;
            byArray[1] = (byte)(s2 >> 8);
            byArray[2] = (byte)s;
            byArray[3] = (byte)(s >> 8);
            System.arraycopy(packet.data.getBytes(), 0, byArray, 4, n);
            this.out.write(byArray);
            this.out.flush();
            ++this.writeTickPacketCount;
        }
        catch (NullPointerException nullPointerException) {
            logger.debug(this.getHost() + ":" + this.getPort() + " sendPacket " + packet, nullPointerException);
            if (this.getStatus() == 1) {
                this.die(4, ((Throwable)nullPointerException).getMessage());
            } else {
                this.die(5, ((Throwable)nullPointerException).getMessage());
            }
            throw new IOException("Internal error");
        }
        catch (IOException iOException) {
            logger.debug(this.getHost() + ":" + this.getPort() + " sendPacket " + packet, iOException);
            if (this.getStatus() == 1) {
                this.die(4, iOException.getMessage());
            } else {
                this.die(5, iOException.getMessage());
            }
            throw iOException;
        }
    }

    public void run() {
        Object object;
        Object object2;
        block60: {
            Thread.currentThread().setPriority(1);
            this.socket = null;
            this.in = null;
            this.out = null;
            this.die = false;
            this.currentBrowse = null;
            this.currentSearch = null;
            this.searchCount = 0;
            this.lastError = null;
            this.searchCache.clear();
            this.users.clear();
            try {
                this.socket = null;
                if (this.remoteIP != null) {
                    try {
                        this.socket = new Socket(this.remoteIP, this.remotePort);
                    }
                    catch (IOException iOException) {
                        logger.debug("connect to " + this.remoteIP + ":" + this.remotePort, iOException);
                        this.setIP(null);
                    }
                }
                if (this.socket == null) {
                    this.socket = new Socket(this.remoteHost, this.remotePort);
                }
                this.in = new BufferedInputStream(this.socket.getInputStream());
                this.out = this.socket.getOutputStream();
                try {
                    this.socket.setSoTimeout(1000);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                this.setStatus(1, XNap.tr("logging in") + "...");
                if (this.newUser) {
                    this.send(new NickCheckMessage(this.getUsername()));
                    break block60;
                }
                MessageHandler.login(this, false);
            }
            catch (ConnectException connectException) {
                this.die(5, MessageFormat.format(XNap.tr("failed: {0}"), connectException.getLocalizedMessage()));
            }
            catch (IOException iOException) {
                this.die(6, MessageFormat.format(XNap.tr("error: {0}"), iOException.getLocalizedMessage()));
            }
        }
        while (!this.die) {
            Object object3;
            object2 = this.getNextMessage();
            if (this.die) break;
            if (object2 instanceof NickNotRegisteredMessage) {
                if (this.getStatus() == 1) {
                    try {
                        MessageHandler.login(this, true);
                    }
                    catch (IOException iOException) {
                        this.setStatus(4, iOException.getMessage());
                    }
                }
            } else if (object2 instanceof NickAlreadyRegisteredMessage) {
                this.die(4, Plugin.tr("nick already registered"));
            } else if (object2 instanceof InvalidNickMessage) {
                this.die(4, Plugin.tr("invalid nick"));
            } else if (object2 instanceof LoginAckMessage) {
                if (this.getStatus() == 1) {
                    this.setStatus(2);
                }
            } else if (object2 instanceof LoginErrorMessage) {
                this.die(4, ((LoginErrorMessage)object2).message);
            } else if (object2 instanceof BrowseResponseMessage) {
                if (this.currentBrowse != null) {
                    this.currentBrowse.add((BrowseResponseMessage)object2);
                }
            } else if (object2 instanceof EndBrowseMessage) {
                if (this.currentBrowse != null) {
                    this.currentBrowse.finished();
                    this.currentBrowse = null;
                    this.updateStatus();
                }
            } else if (object2 instanceof SearchResponseMessage) {
                if (this.currentSearch != null) {
                    this.currentSearch.add((SearchResponseMessage)object2);
                }
            } else if (object2 instanceof EndSearchMessage) {
                if (this.currentSearch != null) {
                    object3 = this;
                    synchronized (object3) {
                        this.currentSearch.finished();
                        if (this.currentSearch.getPriority() == 1) {
                            this.searchCache.put(this.currentSearch.getRequest(), this.currentSearch.getResults());
                        }
                        this.currentSearch = null;
                    }
                    this.updateStatus();
                }
            } else if (object2 instanceof ServerStatsMessage) {
                object3 = (ServerStatsMessage)object2;
                this.userCount = ((ServerStatsMessage)object3).userCount;
                this.fileCount = ((ServerStatsMessage)object3).fileCount;
                this.fileSize = ((ServerStatsMessage)object3).fileSize;
                this.fireStatusChange(this.status, 7);
            } else if (object2 instanceof ErrorMessage) {
                this.lastError = ((ErrorMessage)object2).message;
            }
            MessageHandler.handle((ServerMessage)object2);
            this.allowSearch();
            this.allowBrowse();
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = this;
        synchronized (object2) {
            if (this.currentBrowse != null) {
                this.currentBrowse.failed(Plugin.tr("Server disconnected"));
            }
            object = this.browseQueue.iterator();
            while (object.hasNext()) {
                ((Browse)object.next()).failed(Plugin.tr("Server disconnected"));
            }
            this.browseQueue.clear();
        }
        object2 = this;
        synchronized (object2) {
            if (this.currentSearch != null) {
                this.currentSearch.failed(Plugin.tr("Server disconnected"));
            }
            object = this.searchQueue.toArray();
            int n = 0;
            while (n < ((Object[])object).length) {
                ((Search)object[n]).failed(Plugin.tr("Server disconnected"));
                ++n;
            }
            this.searchQueue.clear();
        }
        object = this.channels.values().iterator();
        while (object.hasNext()) {
            ((IChannel)object.next()).close();
        }
        logger.debug(this.toString() + " has died");
        this.died();
    }

    private final void updateStatus() {
        if (this.status == 2) {
            StringBuffer stringBuffer = new StringBuffer(this.getStatusMsg(this.status));
            if (this.currentSearch != null) {
                stringBuffer.append(", searching");
            }
            if (this.searchQueue.size() > 0) {
                stringBuffer.append(", ");
                stringBuffer.append(this.searchQueue.size());
                stringBuffer.append(" searches pending");
            }
            if (this.currentBrowse != null) {
                stringBuffer.append(", browsing");
            }
            this.setStatus(this.status, stringBuffer.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHost());
        stringBuffer.append(":");
        stringBuffer.append(this.getPort());
        String string = this.getNetwork();
        if (string != null && !string.equals("")) {
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private final synchronized void allowBrowse() {
        if (this.currentBrowse != null || this.browseQueue.size() == 0) {
            return;
        }
        this.currentBrowse = (Browse)this.browseQueue.removeFirst();
        this.currentBrowse.start();
        this.updateStatus();
    }

    private final synchronized void allowSearch() {
        if (this.currentSearch != null || this.searchQueue.size() == 0) {
            return;
        }
        Search search = (Search)this.searchQueue.peek();
        if (this.useSearchCache(search)) {
            this.searchQueue.pop();
            return;
        }
        this.searchQueue.pop();
        this.currentSearch = search;
        this.lastSearch = System.currentTimeMillis();
        ++this.searchCount;
        this.currentSearch.start();
        this.updateStatus();
    }

    private final synchronized boolean useSearchCache(Search search) {
        if (search.getPriority() < 2) {
            this.searchCache.purge();
            LinkedList linkedList = this.searchCache.get(search.getRequest());
            if (linkedList != null) {
                logger.debug("nap server: reuse of searchresults");
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    SearchResult searchResult = (SearchResult)iterator.next();
                    search.add(searchResult);
                }
                search.close();
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Server(String string, String string2, int n, String string3, int n2, int n3, int n4) {
        this.status = 0;
        this.remoteHost = string;
        this.remoteIP = string2;
        this.remotePort = n;
        this.network = string3;
        this.userCount = n4;
        this.fileCount = n2;
        this.fileSize = n3;
    }

    public Server(String string, int n, String string2) {
        this(string, null, n, string2, -1, -1, -1);
    }

    public Server(String string, int n) {
        this(string, n, "");
    }

    public Server() {
        this("", 8888);
    }
}

