/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.Executer;
import xnap.cmdl.ParameterException;
import xnap.cmdl.SyntaxException;
import xnap.net.IDownloadContainer;
import xnap.net.ITransferContainer;
import xnap.net.MultiDownload;
import xnap.util.TransferQueue;

public class DownloadQueue
extends TransferQueue
implements PropertyChangeListener {
    private static DownloadQueue singleton = new DownloadQueue();
    private static /* synthetic */ Class class$Lxnap$util$DownloadQueue;

    public static DownloadQueue getInstance() {
        return singleton;
    }

    public synchronized boolean add(IDownloadContainer iDownloadContainer, boolean bl) {
        this.logger.debug("add download: " + iDownloadContainer);
        int n = super.indexOf(iDownloadContainer);
        if (n == -1) {
            super.add(iDownloadContainer);
            return bl ? this.enqueue(iDownloadContainer) : true;
        }
        Object object = super.get(n);
        if (object instanceof MultiDownload && iDownloadContainer instanceof MultiDownload) {
            MultiDownload multiDownload = (MultiDownload)object;
            multiDownload.merge((MultiDownload)iDownloadContainer);
            return bl && !multiDownload.isRunning() ? this.enqueue(multiDownload) : true;
        }
        return false;
    }

    public boolean add(IDownloadContainer iDownloadContainer) {
        return this.add(iDownloadContainer, true);
    }

    public boolean delete(IDownloadContainer iDownloadContainer) {
        iDownloadContainer.delete();
        return true;
    }

    public boolean resume(IDownloadContainer iDownloadContainer) {
        return this.enqueue(iDownloadContainer);
    }

    public void resumeAll() {
        try {
            Iterator iterator = super.iterator();
            while (iterator.hasNext()) {
                this.enqueue((ITransferContainer)iterator.next());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateLimit();
    }

    public void updateLimit() {
        this.setMaxTransfers(TransferQueue.prefs.getLimitDownloads() ? TransferQueue.prefs.getMaxDownloads() : 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private DownloadQueue() {
        super("DownloadQueue", false);
        this.logger = Logger.getLogger(class$Lxnap$util$DownloadQueue != null ? class$Lxnap$util$DownloadQueue : (class$Lxnap$util$DownloadQueue = DownloadQueue.class$("xnap.util.DownloadQueue")));
        TransferQueue.prefs.addPropertyChangeListener("limitDownloads", this);
        TransferQueue.prefs.addPropertyChangeListener("maxDownloads", this);
        this.updateLimit();
        Executer.addCommand(new ListDlsCmd());
        Executer.addCommand(new AbortDlCmd());
        Executer.addCommand(new ResumeDlCmd());
    }

    protected class ListDlsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            DownloadQueue.this.print();
            return true;
        }

        public ListDlsCmd() {
            this.putValue("cmd", new String[]{"listdownloads", "ldl", "pdown"});
            this.putValue("shortHelp", "Shows the download queue.");
        }
    }

    protected class AbortDlCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) throws SyntaxException, ParameterException {
            if (DownloadQueue.this.lastTransfers == null) {
                DownloadQueue.this.lastTransfers = DownloadQueue.this.getTransfers();
            }
            int n = this.getInt(stringArray, 0, DownloadQueue.this.lastTransfers.length - 1);
            DownloadQueue.this.abort(DownloadQueue.this.lastTransfers[n]);
            return true;
        }

        public AbortDlCmd() {
            this.putValue("cmd", new String[]{"abortdownload", "adl"});
            this.putValue("parameter", "id");
            this.putValue("shortHelp", "Aborts a download.");
        }
    }

    protected class ResumeDlCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) throws SyntaxException, ParameterException {
            if (DownloadQueue.this.lastTransfers == null) {
                DownloadQueue.this.lastTransfers = DownloadQueue.this.getTransfers();
            }
            int n = this.getInt(stringArray, 0, DownloadQueue.this.lastTransfers.length - 1);
            DownloadQueue.this.resume((IDownloadContainer)DownloadQueue.this.lastTransfers[n]);
            return true;
        }

        public ResumeDlCmd() {
            this.putValue("cmd", new String[]{"resumedownload", "rdl"});
            this.putValue("parameter", "id");
            this.putValue("shortHelp", "Resumes a download.");
        }
    }
}

