#/p/perl/perl -w
#
# ======================================================================
# This file is copyright 1998 by the Purdue Research Foundation and may
# only be used under license.  For terms of the license, see the file
# named COPYRIGHT included with this software release.
# ======================================================================
#
# Agent for detecting "NFS server not responding" situations.
#
# AAFID project, COAST Laboratory, 1998.
# 
# Diego Zamboni, Mar 16, 1998.
#
# $Id: CheckNFSserver.pm,v 1.1.1.1 1998/08/12 22:11:34 zamboni Exp $
# $Log: CheckNFSserver.pm,v $
# Revision 1.1.1.1  1998/08/12 22:11:34  zamboni
# AAFID2 prototype as released to COAST sponsors.
#
# Revision 1.2  1998/06/29 20:36:30  zamboni
# Added Copyright notice.
#
# Revision 1.1  1998/06/05 20:50:40  zamboni
# Initial revision
#
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package CheckNFSserver;

# The following makes the agent version number keep up with the RCS
# version number. The self-assignment at the end keeps the -w switch
# from complaining (because $VERSION may not be used here, but it is
# used in our base class).
$VERSION = do { my @r = (q$Revision: 1.1.1.1 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; $VERSION = $VERSION;

########################################################################
# AGENT PARAMETERS
# Important, set them here

%PARAMETERS=(
	     Description	=> "Check for NFS servers not responding",
	     # CheckPeriod may be omitted, it defaults to 10 seconds.
	     CheckPeriod	=> 10,  # Seconds
	     MyFileToCheck	=> '/var/adm/messages',
	     MyFailedServers	=> {}
	    );

########################################################################

use strict;
use AAFID::Agent;
use AAFID::Common;

use vars qw(
	    @ISA
	    $VERSION
	    %PARAMETERS
	   );

# Define the superclasses of our agent.
@ISA=qw(AAFID::Agent);

=head1 Description

TODO

=head1 Implementation

Here we go.

=cut

sub Init {
  my $self=checkref(shift);

  $self->openfile($self->getParameter('MyFileToCheck'));
  $self->Log_activate("debug");
  return $self;
}

sub openfile {
  my $self=checkref(shift);
  my $fname=shift;
  if ($fname) {
    my $file=IO::File->new($fname);
    if (!$file) {
      $self->Log("errors", "Error opening $fname: $!\n");
      return undef;
    }
    $self->Log("debug", "File $fname opened successfully.\n");
    $self->setParameter(MyFileHandle => $file);
    $file->seek(0,2);
    return $self;
  }
  else {
    $self->Log("debug", "No file name provided, waiting.\n");
    return $self;
  }
}

sub Check {
  my $self=checkref(shift);

  my $file=$self->getParameter('MyFileHandle');
  my ($month,$day,$hour,$min,$sec,$host,$prog,$server,$situation);
  my $count;

  if ($file) {
    $file->seek(0,1);
    while (<$file>) {
      $self->Log("debug", "Line read: $_");
      next unless /NFS server.*(not responding|ok)/;
      chop;
      ($month,$day,$hour,$min,$sec,$host,$prog,$server,$situation)=
	(split(/[\s:]+/))[0,1,2,3,4,5,6,9,10];
      if ($situation eq 'not') {
	$self->getParameter('MyFailedServers')->{$server}++;
      }
    }
    my @servs=keys %{$self->getParameter('MyFailedServers')};
    $count=scalar(@servs);
    $count=10 if $count>10;
    my $msg;
    if ($count) {
      $msg="Servers that have failed: ";
      foreach (@servs) {
	$msg.="$_ (".$self->getParameter('MyFailedServers')->{$_}.") ";
      }
    }
    else {
      $msg="No servers have failed.";
    }
    $self->Log("debug", 
	       "Returning ($count, $msg)\n");
    return ($count, $msg);
  }
  return (0, "No file to monitor has been specified");
}

# Syntax: SETFILE File => 'file'
sub command_SETFILE {
  my ($self, $message, %params)=@_;
  if ($params{File}) {
    $self->Log("debug", "Setting file to monitor: $params{File}\n");
    $self->setParameter(MyFileToCheck => $params{File});
    if ($self->openfile($self->getParameter('MyFileToCheck'))) {
      return undef;
    }
    else {
      return {Error => "Error opening $params{File}: $!"};
    }
  }
  else {
    $self->Log("debug", "No File parameter provided.\n");
    return undef;
  }
}

_EndOfEntity;
