eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        CmdSequence
# Agent description: Look for a sequence of processes
# Author:            Diego Zamboni
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# - Monitor for several different sequences simultaneously.
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:46 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "CmdSequence.aas"
package CmdSequence;

# Version number
# 12 "CmdSequence.aas"
$VERSION=eval {do { my @r = (q$Revision: 1.9 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "Look for a sequence of processes",
             CheckPeriod        => eval {10},
# 16 "CmdSequence.aas"
             MyFileToCheck	=> '/var/adm/pacct',
             MyStates		=> {},
             MySequence		=> [],
             MySequenceStr	=> undef,
             MyTargetState	=> undef,
             FiltersNeeded => {  }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;


use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 CmdSequence



=cut

# Preamble code
# 30 "CmdSequence.aas"
sub openfile {
  my $self=checkref(shift);
  my $fname=shift;
  if ($fname) {
    my $file=IO::File->new($fname);
    if (!$file) {
      $self->Log("errors", "Error opening $fname: $!\n");
      return undef;
    }
    $self->Log("debug", "File $fname opened successfully.\n");
    $Params{MyFileHandle}=$file;
    $file->seek(0,2);
    return $self;
  }
  else {
    $self->Log("debug", "No file name provided, waiting.\n");
    return $self;
  }
}

# Provide an Init function.
sub Init {
  my $self=checkref(shift);
# 26 "CmdSequence.aas"
  $self->openfile($Params{MyFileToCheck}) or return undef;
  return $self;
  return $self;
}

# The Check function.
sub Check {
  my $self=checkref(shift);
# 51 "CmdSequence.aas"
  my $file=$Params{MyFileHandle};
  my ($month,$day,$hour,$min,$sec,$host,$prog,$term,$wherefrom);
  my $buf;
  my @seq=@{$Params{MySequence}};
  my $countref;

  if (@seq) {
    if (!$Params{MyCount}) {
      $Params{MyCount}=0;
    }
    $countref=$self->getParameterRef('MyCount');
  if ($file) {
    $file->seek(0,1);
    while ($file->read($buf, 40)) {
      $self->Log("debug", "Read 40-byte block.\n");
      my @splitem=unpack("c c c c l l L l s s s s s s c8", $buf);
      my $cmd= sprintf("%c%c%c%c%c%c%c%c", $splitem[14], $splitem[15],
		       $splitem[16], $splitem[17], $splitem[18], $splitem[19],
		       $splitem[20], $splitem[21]);
      my ($user, $rest)=getpwuid($splitem[4]);
      my $i;
      my $seqstr=$Params{MySequenceStr};
      if (!$Params{MyStates}) {
	$Params{MyStates}={};
      }
      my $states=$Params{MyStates};
      if (!$states->{$user.$seqstr}) {
	$states->{$user.$seqstr}=0;
      }
      for ($i=0; $i<@seq; $i++) {
	my $expcmd=$seq[$i];
	my $actcmd=substr($cmd, 0, length($expcmd));
	if ($expcmd eq $actcmd) {
	  if ($states->{$user.$seqstr} == $i) {
	    $states->{$user.$seqstr}++;
	    if ($states->{$user.$seqstr} == 
		$Params{MyTargetState}) {
	      $ {$countref}++;
	      $states->{$user.$seqstr}=0;
	    }
	  }
	}
      }
    }
    my $count=$$countref;
    $count=10 if $count>10;
    my $msg="Sequence @seq has occurred $count times";
    $self->Log("debug", "Returning ($count, $msg)\n");
    return ($count, $msg);
  }
  return (0, "No file to monitor has been specified");
  }
  return (0, "No sequence to look for has been specified");
}
# Agent commands

sub command_SETFILE {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{File}) && 1) {
    my $File = $p{File};
# 106 "CmdSequence.aas"
# Syntax: SETFILE File => 'file'
  $self->Log("debug", "Setting file to monitor: $File\n");
  $Params{MyFileToCheck}=$File;
  if ($self->openfile($Params{MyFileToCheck})) {
    return undef;
  }
  else {
    return {Error => "Error opening $File: $!"};
  }
    # By default, return undef
    return undef;
  }
}

sub command_SETSEQUENCE {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Sequence}) && 1) {
    my $Sequence = $p{Sequence};
# 117 "CmdSequence.aas"
# Syntax: SETSEQUENCE Sequence => 'cmd,cmd...'
  my $seq=$Sequence;
  $self->Log("debug", "Setting command sequence to look for: $seq\n");
  my @cmdseq=splitList($seq);
  $seq=~s/\s+//g;
  $Params{MySequence} = \@cmdseq;
  $Params{MySequenceStr} = $seq;
  $Params{MyTargetState} = scalar(@cmdseq);
    # By default, return undef
    return undef;
  }
}

# End of entity marker
_EndOfEntity;
