# Part of the A-A-P recipe executive: store the command line arguments.

# Copyright (C) 2002 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING


# An Args object contains the processed command line arguments.
# It consists of these items:
#  options   -  dictionary of options
#		the key is the long name of the option
#		each item is a number or a string
#		"aap -f foo" -> options["recipe"] = "foo"
#  values    -  dictionary of variables assigned a value
#		each item is a string
#		"aap bar=asdf" -> values["bar"] = "asdf"
#  targets   -  list of targets
#		each item is a string
#		"aap clean" -> "clean" target

import types
import string

class Args:
    def __init__(self):
	self.options = {}
	self.values = {}
	self.targets = []

    def has_option(self, name):
	return self.options.has_key(name)

    def printit(self):
	"""print the contents of the attributes (for debugging)"""

	print "Options:"
	for o in self.options.keys():
	    if self.options[o]:
		if type(self.options[o]) is types.ListType:
		    print "    " + o + ": " + string.join(self.options[o], ", ")
		else:
		    print "    " + o + ": " + str(self.options[o])
	    else:
		print "    " + o

	print "Values:"
	for v in self.values.keys():
	    print "    " + v + "=" + self.values[v]

	print "Targets:"
	for t in self.targets:
	    print "    " + t

# vim: set sw=4 sts=4 tw=79 fo+=l:
