# Part of the A-A-P recipe executive: remember the work specified in the recipe

# Copyright (C) 2002 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# Global variables, can be used anywhere
#
# Always use "import Global" and prepend "Global.", so that it's clear a global
# variable is being used.
#

# recdict with global variables for current (build) commands.  Set before
# executing the build commands.
globals = None

# arguments from the command line
cmd_args = None

# The directory in which A-A-P places its files.
# It used to be called differently, it is automatically renamed for a while.
# TODO: remove the old name later
aap_dirname = "AAPDIR"
aap_dirname_old = "AAP"

# directory where the A-A-P modules are
aap_rootdir = None

# Forced building, ignore --nobuild and --force arguments.  Used for updating
# dependencies.
force_build = 0

# all standard targets that are virtual
virtual_targets = [
		    "add",
		    "all",
		    "build",
		    "check",
		    "checkin",
		    "checkout",
		    "clean",
		    "commit",
		    "configure",
		    "distclean",
		    "extract",
		    "fetch",
		    "finally",
		    "install",
		    "patch",
		    "publish",
		    "reference",
		    "fetch",
		    "remove",
		    "revise",
		    "test",
		    "tryout",
		    "unlock",
		    "update",
		  ]

# vim: set sw=4 sts=4 tw=79 fo+=l:
