dnl @synopsis AG_CHECK_ALLOCATED_CTIME
dnl
dnl Check whether we need to free the memory returned by ctime.
dnl
dnl @author autogen.sf.net is a project of Bruce Korb <bkorb@gnu.org>
dnl @version $Id: ag_check_allocated_ctime.m4,v 1.1 2001/11/11 05:50 ac-archive-0.5.32 $
dnl
AC_DEFUN(AG_CHECK_ALLOCATED_CTIME,[
  AC_MSG_CHECKING([whether ctime() allocates memory for its result])
  AC_CACHE_VAL([ag_cv_allocated_ctime],[
  AC_TRY_RUN([#include <time.h>
int main (int argc, char** argv) {
   time_t  timeVal = time( (time_t*)NULL );
   char*   pzTime  = ctime( &timeVal );
   free( (void*)pzTime );
   return 0; }],[ag_cv_allocated_ctime=yes],[ag_cv_allocated_ctime=no],[ag_cv_allocated_ctime=no]
           ) # end of TRY_RUN]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_allocated_ctime])
 if test x$ag_cv_allocated_ctime = xyes
 then
   AC_DEFINE(HAVE_ALLOCATED_CTIME, 1,
      [Define this if ctime() allocates memory for its result])
 fi
 ]) # end of AC_DEFUN
