dnl @synopsis AG_CHECK_POSIX_SYSINFO
dnl
dnl Check that the POSIX compliant sysinfo(2) call works properly.
dnl Linux has its own weirdo alternative.
dnl
dnl @author autogen.sf.net is a project of Bruce Korb <bkorb@gnu.org>
dnl @version $Id: ag_check_posix_sysinfo.m4,v 1.1 2001/11/11 05:50 ac-archive-0.5.32 $
dnl
AC_DEFUN(AG_CHECK_POSIX_SYSINFO,[
  AC_MSG_CHECKING([whether sysinfo(2) is POSIX])
  AC_CACHE_VAL([ag_cv_posix_sysinfo],[
  AC_TRY_RUN([#include <sys/systeminfo.h>
int main() { char z[ 256 ];
long sz = sysinfo( SI_SYSNAME, z, sizeof( z ));
return (sz > 0) ? 0 : 1; }],[ag_cv_posix_sysinfo=yes],[ag_cv_posix_sysinfo=no],[ag_cv_posix_sysinfo=no]
           ) # end of TRY_RUN]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_posix_sysinfo])
 if test x$ag_cv_posix_sysinfo = xyes
 then
   AC_DEFINE(HAVE_POSIX_SYSINFO, 1,
      [Define this if sysinfo(2) is POSIX])
 fi
 ]) # end of AC_DEFUN
