dnl @synopsis AG_CHECK_SYS_SIGLIST
dnl
dnl Check that the POSIX compliant regular expression compiler
dnl is available in the POSIX specified manner, and it works.
dnl
dnl @author autogen.sf.net is a project of Bruce Korb <bkorb@gnu.org>
dnl @version $Id: ag_check_sys_siglist.m4,v 1.1 2001/11/11 05:50 ac-archive-0.5.32 $
dnl
AC_DEFUN(AG_CHECK_SYS_SIGLIST,[
  AC_MSG_CHECKING([whether there is a global text array sys_siglist])
  AC_CACHE_VAL([ag_cv_sys_siglist],[
  AC_TRY_RUN([#include <signal.h>
int main() {
  const char* pz = sys_siglist[1];
  return (pz != 0) ? 0 : 1; }],[ag_cv_sys_siglist=yes],[ag_cv_sys_siglist=no],[ag_cv_sys_siglist=no]
           ) # end of TRY_RUN]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_sys_siglist])
 if test x$ag_cv_sys_siglist = xyes
 then
   AC_DEFINE(HAVE_SYS_SIGLIST, 1,
      [Define this if there is a global text array sys_siglist])
 fi
 ]) # end of AC_DEFUN
