dnl @synopsis AC_PROG_FIG2DEV
dnl
dnl If `fig2dev' is found, sets the output variable `FIG2DEV' to `fig2dev',
dnl and `FIG2DEV_ESPLANG' to the graphics language which can be used to
dnl produce Encapsulated PostScript.  Older versions of `fig2dev' produce
dnl EPS with `-Lps' and new versions with `-Leps', this macro finds out the
dnl correct language option automatically.
dnl
dnl @version $Id: ac_prog_fig2dev.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.32 $
dnl @author Ville Laurikari <vl@iki.fi>

AC_DEFUN([AC_PROG_FIG2DEV], [
  AC_CHECK_PROG(FIG2DEV, fig2dev, fig2dev)
  if test "x$FIG2DEV" != "x"; then
    AC_CACHE_CHECK(how to produce EPS with fig2dev,
                   ac_cv_sys_fig2dev_epslang, [
      if $FIG2DEV -Leps /dev/null 2>&1 |grep Unknown > /dev/null; then
        ac_cv_sys_fig2dev_epslang=ps
      else
        ac_cv_sys_fig2dev_epslang=eps
      fi
    ])
    FIG2DEV_EPSLANG=$ac_cv_sys_fig2dev_epslang
    AC_SUBST(FIG2DEV_EPSLANG)
  fi
])
