dnl @synopsis AC_PROG_MYSQL
dnl
dnl Check for the program 'mysql'
dnl let script continue if exists & works
dnl pops up error message if not.
dnl
dnl Testing of functionality is by invoking it with root password 'rootpass'
dnl and a 'SELECT * FROM user' SQL statement.
dnl That SQL statement will select all user information from the 'user' privileges table,
dnl and should work on every proper MySQL server.
dnl
dnl Besides checking mysql, this macro also set these environment variables upon completion:
dnl
dnl     MYSQL = which mysql
dnl
dnl @version $Id: ac_prog_mysql.m4,v 1.1 2002/09/12 21:50 ac-archive-0.5.39 $
dnl @author Gleen Salmon <gleensalmon@yahoo.com>
dnl
AC_DEFUN([AC_PROG_MYSQL],[
AC_REQUIRE([AC_EXEEXT])dnl
AC_PATH_PROG(MYSQL, mysql$EXEEXT, nocommand)
if test "$MYSQL" = nocommand; then
        AC_MSG_ERROR([mysql not found in $PATH])
fi
AC_MSG_CHECKING([if mysql works])
if echo 'SELECT * FROM user' | $MYSQL -u root -prootpass mysql > /dev/null; then
        AC_MSG_RESULT([yes])
else
        AC_MSG_NOTICE([Before installation, set MySQL root password to rootpass; restore your root password afterwards.])
        AC_MSG_ERROR([mysql cannot execute SELECT with root password = rootpass])
fi;dnl
])
