dnl @synopsis AC_CXX_OLD_FOR_SCOPING
dnl
dnl If the compiler accepts the old for scoping rules (the scope of a
dnl variable declared inside the parentheses extends outside the
dnl for-body), define HAVE_OLD_FOR_SCOPING. Note that some
dnl compilers (notably g++ and egcs) support both new and old
dnl rules since they accept the old rules and only generate a warning.
dnl
dnl @version $Id: ac_cxx_old_for_scoping.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.39 $
dnl @author Luc Maisonobe
dnl
AC_DEFUN([AC_CXX_OLD_FOR_SCOPING],
[AC_CACHE_CHECK(whether the compiler accepts the old for scoping rules,
ac_cv_cxx_old_for_scoping,
[AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE(,[int z;for (int i=0; i < 10; ++i)z=z+i;z=i;return z;],
 ac_cv_cxx_old_for_scoping=yes, ac_cv_cxx_old_for_scoping=no)
 AC_LANG_RESTORE
])
if test "$ac_cv_cxx_old_for_scoping" = yes; then
  AC_DEFINE(HAVE_OLD_FOR_SCOPING,,[define if the compiler accepts the old for scoping rules])
fi
])
