dnl @synopsis AC_PROG_MODPROBE
dnl
dnl This macro searches for a modprobe command, such as can be found on
dnl Linux systems with loadable kernel module support. PATH is checked
dnl first, then the default location(s).
dnl
dnl This is one of several autoconf macros intended to assist in configuring
dnl and installing loadable kernel modules.
dnl
dnl @version $Id: ac_prog_modprobe.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.39 $
dnl @author Kaelin Colclasure <kaelin@acm.org>
dnl
AC_DEFUN([AC_PROG_MODPROBE],[
AC_PATH_PROG(MODPROBE, modprobe, , $PATH:/sbin)
if test -z "$MODPROBE"; then
  AC_MSG_WARN([no support for loadable kernel modules])
else
  AC_MSG_CHECKING([for module_prefix])
  module_prefix=`$MODPROBE -c | grep path.kernel.= \
                 | sed -e '2,$d' -e 's/.*=//' -e 's/.kernel//'`
  AC_MSG_RESULT($module_prefix)
  AC_SUBST(module_prefix)
fi
])
