dnl @synopsis PETI_SILENT_MODE(on/off)
dnl
dnl Some macros provided by autoconf do automatically issue screen
dnl output when called, for example AC_CHECK_LIB. This may be
dnl undesirable at times, for example when these routines are called
dnl within a more complex macro consisting of several tests in a row.
dnl
dnl Hence this macro provides a mechanism to switch screen output by
dnl autoconf generally off. All screen i/o within configure scripts
dnl takes place on file descriptor "6", which is in fact a copy of
dnl the standard output. By setting this file descriptor to
dnl "/dev/null" or to standard output again, silent mode can be
dnl enabled or disabled.
dnl
dnl    PETI_SILENT_MODE(on)    dnl be silent
dnl    AC_PROG_CXX
dnl    PETI_SILENT_MODE(off)   dnl talk to me again
dnl    AC_PROG_RANLIB
dnl
dnl This macro was proposed and inspired by Paolo Bonzini <bonzini@gnu.org>.
dnl
dnl @author Peter Simons <simons@computer.org>
dnl @version $Id: peti_silent_mode.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.39 $
dnl
AC_DEFUN([PETI_SILENT_MODE],
    [
    case "$1" in
      on)
        exec 6>/dev/null
        ;;
      off)
        exec 6>&1
        ;;
      *)
        AC_MSG_ERROR(Silent mode can only be switched "on" or "off".)
        ;;
    esac
    ])
