dnl @synopsis QEF_C_NORETURN
dnl
dnl Check if we can use GCC's __noreturn__ attribute in prototypes to indicate
dnl that functions never return.  This can be used by the compiler to do some
dnl extra optimizations.
dnl
dnl FUNCATTR_NORETURN is defined as what we should put at the end of function
dnl prototypes to achieve this.  If the compiler doesn't support it then it is
dnl defined as empty.
dnl
dnl An example of a a function's prototype and implementation using this macro:
dnl
dnl   void this_function_never_returns (void) FUNCATTR_NORETURN;
dnl
dnl   void this_function_never_returns (void) {
dnl      exit (0);
dnl   }
dnl
dnl @version $Id: qef_c_noreturn.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.39 $
dnl @author Geoff Richards <ctzgpr@scs.leeds.ac.uk>
dnl
AC_DEFUN([QEF_C_NORETURN],
[AC_REQUIRE([AC_PROG_CC])
AC_MSG_CHECKING(whether the C compiler (${CC-cc}) accepts noreturn attribute)
AC_CACHE_VAL(qef_cv_c_noreturn,
[qef_cv_c_noreturn=no
AC_TRY_COMPILE(
[#include <stdio.h>
void f (void) __attribute__ ((noreturn));
void f (void)
{
   exit (1);
}
], [
   f ();
],
[qef_cv_c_noreturn="yes";  FUNCATTR_NORETURN_VAL="__attribute__ ((noreturn))"],
[qef_cv_c_noreturn="no";   FUNCATTR_NORETURN_VAL="/* will not return */"])
])

AC_MSG_RESULT($qef_cv_c_noreturn)
AC_DEFINE_UNQUOTED(FUNCATTR_NORETURN, $FUNCATTR_NORETURN_VAL)
])dnl
