dnl @synopsis AG_CHECK_POSIX_REGCOMP
dnl
dnl Check that the POSIX compliant regular expression compiler
dnl is available in the POSIX specified manner, and it works.
dnl
dnl @author autogen.sf.net is a project of Bruce Korb <bkorb@gnu.org>
dnl @version $Id: ag_check_posix_gegcomp.m4,v 1.1 2001/11/11 05:50 ac-archive-0.5.39 $
dnl
AC_DEFUN(AG_CHECK_POSIX_REGCOMP,[
  AC_MSG_CHECKING([whether POSIX compliant regcomp()/regexec()])
  AC_CACHE_VAL([ag_cv_posix_regcomp],[
  AC_TRY_RUN([#include <sys/types.h>
#include <regex.h>
int main() {
  regex_t  re;
  return regcomp( &re, "^.*$", REG_EXTENDED|REG_ICASE|REG_NEWLINE ); }],[ag_cv_posix_regcomp=yes],[ag_cv_posix_regcomp=no],[ag_cv_posix_regcomp=no]
           ) # end of TRY_RUN]) # end of CACHE_VAL

 AC_MSG_RESULT([$ag_cv_posix_regcomp])
 if test x$ag_cv_posix_regcomp = xyes
 then
   AC_DEFINE(HAVE_POSIX_REGCOMP, 1,
      [Define this if POSIX compliant regcomp()/regexec()])
 fi
 ]) # end of AC_DEFUN
