dnl AC_SET_RELEASEINFO_VERSIONINFO_AND_DEFINES [(VERSION)]         -*- sh -*-
dnl   default $1 = $VERSION                                     
dnl
dnl check the $VERSION number and cut the two last digit-sequences off
dnl which will form a -version-info in a @VERSIONINFO@ ac_subst while
dnl the rest is going to the -release name in a @RELEASEINFO@ ac_subst.
dnl
dnl you should keep these two seperate - the release-name may contain
dnl alpha-characters and can be modified later with extra release-hints
dnl e.g. RELEASEINFO="$RELEASINFO-debug" for a debug version of your lib.
dnl
dnl  example: a VERSION="2.4.18" will be transformed into
dnl           -release 2 -version-info 4:18
dnl  and for a linux-target this will tell libtool to install the lib as
dnl           libmy.so libmy.la libmy.a libmy-2.so.4 libmy-2.so.4.0.18
dnl and executables will get link-resolve-infos for libmy-2.so.4 - therefore
dnl the patch-level is ignored during ldso linking, and ldso will use the
dnl one with the highest patchlevel. Using just "-release $(VERSION)"
dnl during libtool-linking would not do that - omitting the -version-info
dnl will libtool install libmy.so libmy.la libmy.a libmy-2.4.18.so and
dnl executables would get hardlinked with the 2.4.18 version of your lib.
dnl
dnl This background does also explain the default dll name for a win32
dnl target : libtool will choose to make up libmy-2-4.dll for this 
dnl version spec.
dnl
dnl Unlike the older/straight ac_set_releaseinfo_versioninfo this macro 
dnl does set the three parts MAJOR_VERSION.;MINOR_VERSION.MICRO_VERSION
dnl from the VERSION-spec *and* does also ac_subst them like the two INFOs
dnl *and* the three version-parts are ac_defined numerically too.
dnl If you prefer a two-part VERSION-spec, the VERSION_REL will still be set,
dnl either to the host_cpu or just a simple "00", so watch out.
dnl You may add sublevel parts like "1.4.2-ac5" where the sublevel is 
dnl just killed from these versioninfo/releasinfo substvars.
dnl
dnl @version $Id: ac_set_releaseinfo_versioninfo.m4,v 1.2 2001/08/25 15:59 ac-archive-0.5.39 $
dnl @author Guido Draheim <guidod@gmx.de>

AC_DEFUN([AC_SET_RELEASEINFO_VERSIONINFO_AND_DEFINES],
[# ------ AC SET RELEASEINFO VERSIONINFO_AND_DEFINES --------------------------
AC_MSG_CHECKING(version info)
  MINOR_VERSION=`echo ifelse( $1, , $VERSION, $1 )` # VERSION_TMP really...
  MAJOR_VERSION=`echo $MINOR_VERSION | sed -e 's/[[.]][[^.]]*$//'`  # delete micro
  MICRO_VERSION=`echo $MINOR_VERSION | sed -e "s/^$MAJOR_VERSION.//"` # the rest
  MINOR_VERSION=`echo $MAJOR_VERSION | sed -e 's/.*[[.]]//'`  # delete prefix now
  MICRO_VERSION=`echo $MICRO_VERSION | sed -e 's/[[^0-9]].*//'` # 5-p4 -> 5
  if test "$MINOR_VERSION" != "$MAJOR_VERSION" ; then # three-part version...
  MAJOR_VERSION=`echo $MAJOR_VERSION | sed -e "s/.$MINOR_VERSION\$//"`
  else # or has been two-part version - try using host_cpu if available
  MAJOR_VERSION="00" ; test "_$host_cpu" != "_" && MAJOR_VERSION="$host_cpu"
  fi
  RELEASEINFO="-release $MAJOR_VERSION"
  VERSIONINFO="-version-info $MINOR_VERSION:$MICRO_VERSION"
AC_MSG_RESULT([$RELEASEINFO $VERSIONINFO])
AC_SUBST([RELEASEINFO])
AC_SUBST([VERSIONINFO])
AC_SUBST([MAJOR_VERSION])
AC_SUBST([MINOR_VERSION])
AC_SUBST([MICRO_VERSION])
AC_DEFINE_UNQUOTED([MAJOR_VERSION], $MAJOR_VERSION, [package major version])
AC_DEFINE_UNQUOTED([MINOR_VERSION], $MINOR_VERSION, [package minor version])
AC_DEFINE_UNQUOTED([MICRO_VERSION], $MICRO_VERSION, [package micro version])
])




