dnl @synopsis AC_DEFINE_SUB_PATH(DEFNAME, varname, description)
dnl
dnl look at varname and detect the subpath that it contains
dnl relative to $prefix/$exec_prefix
dnl
dnl If the path is indeed relative to $prefix/$exec_prefix, 
dnl then a single "./" (dotslash) is prepended, otherwise it
dnl can be seen as an absolute path that can not be moved,
dnl which you possibly do for "/etc" files, or even those
dnl ending up in "/lib/modules" or "/winnt/system".
dnl
dnl this macro is not very intelligent, it's just a first
dnl try in this direction. It does currently just look into
dnl the current patterns, and replaces a ${prefix} with
dnl a simple dot. Amazingly, it works quite well for most
dnl packages.
dnl
dnl correct usage:
dnl in configure ac
dnl    AC_DEFINE_DIR([EPREFIX], [exec_prefix], [--exec-prefix or default])
dnl    AC_DEFINE_SUB_PATH([PATH_LIBDIR], [libdir], [--bindir subdir])
dnl    AC_DEFINE_UNQUOTED([PACKAGE],"$PACKAGE", [Name of package])
dnl in "C"
dnl    static const char _libdir[] = PATH_LIBDIR; /* configure default */
dnl    char* libdir;
dnl    char* eprefix = getenv (PACKAGE "DIR");
dnl    if (! eprefix) eprefix = EPREFIX; /* default */
dnl    if (*_libdir != '.') libdir = strdup(_libdir);
dnl    else {
dnl       libdir = malloc(strlen(eprefix) + strlen(_libdir) + 2);
dnl       strcpy(libdir, eprefix);
dnl       strcat(libdir, PATH_DELIMITER_STRING);
dnl       strcat(libdir, _libdir);
dnl    }
dnl    ...
dnl    free (libdir);
dnl          
dnl    
dnl AC_DEFINE_SUB_PATHS(varnames)
dnl
dnl look for the given various install-paths that largely depend on
dnl either ${prefix} or ${exec_prefix}. Just cut out the prefix
dnl and ac_define the value. The value is uppercased and PATH_ prepended
dnl ie. ac_define_sub_paths(bindir libdir pkgdatadir) will create
dnl the defines PATH_BINDIR PATH_LIBDIR PATH_PKGDATADIR - see
dnl posix' include/paths.h that creates _PATH_DEV and friends.
dnl
dnl @version $Id: ac_subst_prefix_subpaths.m4,v 1.1.1.1 2001/07/26 00:46 ac-archive-0.5.39 $
dnl @author: Guido Draheim <guidod@gmx.de>     STATUS: never used

AC_DEFUN([AC_DEFINE_SUB_PATH],
[dnl
  test "_$prefix" = _NONE && prefix="$ac_default_prefix"
  test "_$exec_prefix" = _NONE && exec_prefix='${prefix}'
  P=`echo ifelse( $2, , [$]$1, [$]$2) | sed -e 's:^\${[a-z_]*prefix}:.:'`
  ifelse ($3, , 
    AC_DEFINE($1, $P, [sub path $2]),
    AC_DEFINE($1, $P, $3))
])

AC_DEFUN([AC_DEFINE_SUB_PATHS],
[dnl
  test "_$prefix" = _NONE && prefix="$ac_default_prefix"
  test "_$exec_prefix" = _NONE && exec_prefix='${prefix}'
  for i in $1 ; do
  P=`echo \$$i | sed -e 's:^\${[a-z_]*prefix}:.:'`
  V=`echo path_$i | sed -e 'y:abcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZ:'`
    AC_DEFINE($V, $P, [sub path $i]),
])
  